/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ermodelrelation;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.ermodelrelation.ERModelRelationshipCardinality;
import com.linkedin.ermodelrelation.RelationshipFieldMappingArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ERModelRelationshipProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ermodelrelation/**Properties associated with a ERModelRelationship*/@Aspect.name=\"erModelRelationshipProperties\"record ERModelRelationshipProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**Name of the ERModelRelation*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"TEXT_PARTIAL\"}name:string/**First dataset in the erModelRelationship (no directionality)*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"ermodelrelationA\"}@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"TEXT_PARTIAL\"}source:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Second dataset in the erModelRelationship (no directionality)*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"ermodelrelationB\"}@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"TEXT_PARTIAL\"}destination:com.linkedin.common.Urn/**ERModelRelationFieldMapping (in future we can make it an array)*/relationshipFieldMappings:array[/**Individual Field Mapping of a relationship- one of several*/record RelationshipFieldMapping{/**All fields from dataset A that are required for the join, maps to bFields 1:1*/sourceField:{namespace com.linkedin.dataset/**Schema field path. TODO: Add formal documentation on normalization rules.*/typeref SchemaFieldPath=string}/**All fields from dataset B that are required for the join, maps to aFields 1:1*/destinationField:com.linkedin.dataset.SchemaFieldPath}]/**A timestamp documenting when the asset was created in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\"}created:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**A timestamp documenting when the asset was last modified in the source Data Platform (not on DataHub)*/@Searchable.`/time`={\"fieldName\":\"lastModifiedAt\",\"fieldType\":\"DATETIME\"}lastModified:optional com.linkedin.common.AuditStamp/**Cardinality of the relationship*/cardinality:enum ERModelRelationshipCardinality{ONE_ONE,ONE_N,N_ONE,N_N}=\"N_N\"}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private String _nameField = null;
    private Urn _sourceField = null;
    private Urn _destinationField = null;
    private RelationshipFieldMappingArray _relationshipFieldMappingsField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private ERModelRelationshipCardinality _cardinalityField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_Name;
    private static final RecordDataSchema.Field FIELD_Source;
    private static final RecordDataSchema.Field FIELD_Destination;
    private static final RecordDataSchema.Field FIELD_RelationshipFieldMappings;
    private static final RecordDataSchema.Field FIELD_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final RecordDataSchema.Field FIELD_Cardinality;
    private static final ERModelRelationshipCardinality DEFAULT_Cardinality;

    public ERModelRelationshipProperties() {
        super(new DataMap(11, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public ERModelRelationshipProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public ERModelRelationshipProperties setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.ermodelrelation.ERModelRelationshipProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public ERModelRelationshipProperties setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.ermodelrelation.ERModelRelationshipProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public ERModelRelationshipProperties setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.ermodelrelation.ERModelRelationshipProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public ERModelRelationshipProperties setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.ermodelrelation.ERModelRelationshipProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasSource() {
        if (this._sourceField != null) {
            return true;
        }
        return this._map.containsKey("source");
    }

    public void removeSource() {
        this._map.remove("source");
    }

    @Nullable
    public Urn getSource(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSource();
            }
            case DEFAULT: 
            case NULL: {
                if (this._sourceField != null) {
                    return this._sourceField;
                }
                Object __rawValue = this._map.get("source");
                this._sourceField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._sourceField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getSource() {
        if (this._sourceField != null) {
            return this._sourceField;
        }
        Object __rawValue = this._map.get("source");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("source");
        }
        this._sourceField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._sourceField;
    }

    public ERModelRelationshipProperties setSource(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSource(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field source of com.linkedin.ermodelrelation.ERModelRelationshipProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "source", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSource();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "source", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "source", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceField = value;
            }
        }
        return this;
    }

    public ERModelRelationshipProperties setSource(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field source of com.linkedin.ermodelrelation.ERModelRelationshipProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "source", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._sourceField = value;
        return this;
    }

    public boolean hasDestination() {
        if (this._destinationField != null) {
            return true;
        }
        return this._map.containsKey("destination");
    }

    public void removeDestination() {
        this._map.remove("destination");
    }

    @Nullable
    public Urn getDestination(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDestination();
            }
            case DEFAULT: 
            case NULL: {
                if (this._destinationField != null) {
                    return this._destinationField;
                }
                Object __rawValue = this._map.get("destination");
                this._destinationField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._destinationField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getDestination() {
        if (this._destinationField != null) {
            return this._destinationField;
        }
        Object __rawValue = this._map.get("destination");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("destination");
        }
        this._destinationField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._destinationField;
    }

    public ERModelRelationshipProperties setDestination(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDestination(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field destination of com.linkedin.ermodelrelation.ERModelRelationshipProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "destination", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._destinationField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDestination();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "destination", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._destinationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "destination", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._destinationField = value;
            }
        }
        return this;
    }

    public ERModelRelationshipProperties setDestination(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field destination of com.linkedin.ermodelrelation.ERModelRelationshipProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "destination", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._destinationField = value;
        return this;
    }

    public boolean hasRelationshipFieldMappings() {
        if (this._relationshipFieldMappingsField != null) {
            return true;
        }
        return this._map.containsKey("relationshipFieldMappings");
    }

    public void removeRelationshipFieldMappings() {
        this._map.remove("relationshipFieldMappings");
    }

    @Nullable
    public RelationshipFieldMappingArray getRelationshipFieldMappings(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRelationshipFieldMappings();
            }
            case DEFAULT: 
            case NULL: {
                if (this._relationshipFieldMappingsField != null) {
                    return this._relationshipFieldMappingsField;
                }
                Object __rawValue = this._map.get("relationshipFieldMappings");
                this._relationshipFieldMappingsField = __rawValue == null ? null : new RelationshipFieldMappingArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._relationshipFieldMappingsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public RelationshipFieldMappingArray getRelationshipFieldMappings() {
        if (this._relationshipFieldMappingsField != null) {
            return this._relationshipFieldMappingsField;
        }
        Object __rawValue = this._map.get("relationshipFieldMappings");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("relationshipFieldMappings");
        }
        this._relationshipFieldMappingsField = __rawValue == null ? null : new RelationshipFieldMappingArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._relationshipFieldMappingsField;
    }

    public ERModelRelationshipProperties setRelationshipFieldMappings(@Nullable RelationshipFieldMappingArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRelationshipFieldMappings(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field relationshipFieldMappings of com.linkedin.ermodelrelation.ERModelRelationshipProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "relationshipFieldMappings", value.data());
                this._relationshipFieldMappingsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRelationshipFieldMappings();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "relationshipFieldMappings", value.data());
                this._relationshipFieldMappingsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "relationshipFieldMappings", value.data());
                this._relationshipFieldMappingsField = value;
            }
        }
        return this;
    }

    public ERModelRelationshipProperties setRelationshipFieldMappings(@Nonnull RelationshipFieldMappingArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field relationshipFieldMappings of com.linkedin.ermodelrelation.ERModelRelationshipProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "relationshipFieldMappings", value.data());
        this._relationshipFieldMappingsField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public ERModelRelationshipProperties setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public ERModelRelationshipProperties setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.ermodelrelation.ERModelRelationshipProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public ERModelRelationshipProperties setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public ERModelRelationshipProperties setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.ermodelrelation.ERModelRelationshipProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasCardinality() {
        if (this._cardinalityField != null) {
            return true;
        }
        return this._map.containsKey("cardinality");
    }

    public void removeCardinality() {
        this._map.remove("cardinality");
    }

    @Nullable
    public ERModelRelationshipCardinality getCardinality(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCardinality();
            }
            case NULL: {
                if (this._cardinalityField != null) {
                    return this._cardinalityField;
                }
                Object __rawValue = this._map.get("cardinality");
                this._cardinalityField = DataTemplateUtil.coerceEnumOutput(__rawValue, ERModelRelationshipCardinality.class, ERModelRelationshipCardinality.$UNKNOWN);
                return this._cardinalityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ERModelRelationshipCardinality getCardinality() {
        if (this._cardinalityField != null) {
            return this._cardinalityField;
        }
        Object __rawValue = this._map.get("cardinality");
        if (__rawValue == null) {
            return DEFAULT_Cardinality;
        }
        this._cardinalityField = DataTemplateUtil.coerceEnumOutput(__rawValue, ERModelRelationshipCardinality.class, ERModelRelationshipCardinality.$UNKNOWN);
        return this._cardinalityField;
    }

    public ERModelRelationshipProperties setCardinality(@Nullable ERModelRelationshipCardinality value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCardinality(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field cardinality of com.linkedin.ermodelrelation.ERModelRelationshipProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "cardinality", value.name());
                this._cardinalityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCardinality();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "cardinality", value.name());
                this._cardinalityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "cardinality", value.name());
                this._cardinalityField = value;
            }
        }
        return this;
    }

    public ERModelRelationshipProperties setCardinality(@Nonnull ERModelRelationshipCardinality value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field cardinality of com.linkedin.ermodelrelation.ERModelRelationshipProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "cardinality", value.name());
        this._cardinalityField = value;
        return this;
    }

    @Override
    public ERModelRelationshipProperties clone() throws CloneNotSupportedException {
        ERModelRelationshipProperties __clone = (ERModelRelationshipProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ERModelRelationshipProperties copy() throws CloneNotSupportedException {
        ERModelRelationshipProperties __copy = (ERModelRelationshipProperties)super.copy();
        __copy._customPropertiesField = null;
        __copy._relationshipFieldMappingsField = null;
        __copy._createdField = null;
        __copy._nameField = null;
        __copy._destinationField = null;
        __copy._sourceField = null;
        __copy._lastModifiedField = null;
        __copy._cardinalityField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Name = SCHEMA.getField("name");
        FIELD_Source = SCHEMA.getField("source");
        FIELD_Destination = SCHEMA.getField("destination");
        FIELD_RelationshipFieldMappings = SCHEMA.getField("relationshipFieldMappings");
        FIELD_Created = SCHEMA.getField("created");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_Cardinality = SCHEMA.getField("cardinality");
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
        DEFAULT_Cardinality = DataTemplateUtil.coerceEnumOutput(FIELD_Cardinality.getDefault(), ERModelRelationshipCardinality.class, ERModelRelationshipCardinality.$UNKNOWN);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ERModelRelationshipProperties __objectRef;

        private ChangeListener(ERModelRelationshipProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "relationshipFieldMappings": {
                    this.__objectRef._relationshipFieldMappingsField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "destination": {
                    this.__objectRef._destinationField = null;
                    break;
                }
                case "source": {
                    this.__objectRef._sourceField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "cardinality": {
                    this.__objectRef._cardinalityField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec source() {
            return new PathSpec(this.getPathComponents(), "source");
        }

        public PathSpec destination() {
            return new PathSpec(this.getPathComponents(), "destination");
        }

        public RelationshipFieldMappingArray.Fields relationshipFieldMappings() {
            return new RelationshipFieldMappingArray.Fields(this.getPathComponents(), "relationshipFieldMappings");
        }

        public PathSpec relationshipFieldMappings(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "relationshipFieldMappings");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }

        public PathSpec cardinality() {
            return new PathSpec(this.getPathComponents(), "cardinality");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private RelationshipFieldMappingArray.ProjectionMask _relationshipFieldMappingsMask;
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
            super(11);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withSource() {
            this.getDataMap().put("source", 1);
            return this;
        }

        public ProjectionMask withDestination() {
            this.getDataMap().put("destination", 1);
            return this;
        }

        public ProjectionMask withRelationshipFieldMappings(Function<RelationshipFieldMappingArray.ProjectionMask, RelationshipFieldMappingArray.ProjectionMask> nestedMask) {
            this._relationshipFieldMappingsMask = nestedMask.apply(this._relationshipFieldMappingsMask == null ? RelationshipFieldMappingArray.createMask() : this._relationshipFieldMappingsMask);
            this.getDataMap().put("relationshipFieldMappings", this._relationshipFieldMappingsMask.getDataMap());
            return this;
        }

        public ProjectionMask withRelationshipFieldMappings() {
            this._relationshipFieldMappingsMask = null;
            this.getDataMap().put("relationshipFieldMappings", 1);
            return this;
        }

        public ProjectionMask withRelationshipFieldMappings(Function<RelationshipFieldMappingArray.ProjectionMask, RelationshipFieldMappingArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._relationshipFieldMappingsMask = nestedMask.apply(this._relationshipFieldMappingsMask == null ? RelationshipFieldMappingArray.createMask() : this._relationshipFieldMappingsMask);
            this.getDataMap().put("relationshipFieldMappings", this._relationshipFieldMappingsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("relationshipFieldMappings").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relationshipFieldMappings").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRelationshipFieldMappings(Integer start, Integer count) {
            this._relationshipFieldMappingsMask = null;
            this.getDataMap().put("relationshipFieldMappings", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("relationshipFieldMappings").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relationshipFieldMappings").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withCardinality() {
            this.getDataMap().put("cardinality", 1);
            return this;
        }
    }
}

