/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataproduct;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.dataproduct.DataProductAssociation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class DataProductAssociationArray
extends WrappingArrayTemplate<DataProductAssociation> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.dataproduct/**Represents an association of assets to a Data Product.\n*/record DataProductAssociation includes{namespace com.linkedin.common/**A common structure to represent all edges to entities when used inside aspects as collections\nThis ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically.\n*/record Edge{/**Urn of the source of this relationship edge.\nIf not specified, assumed to be the entity that this aspect belongs to.*/sourceUrn:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**Urn of the destination of this relationship edge.*/destinationUrn:Urn/**Audit stamp containing who created this relationship edge and when*/created:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional AuditStamp/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]}}{/**If set to true, this asset is an output port of the Data Product.*/outputPort:boolean=false}}]", SchemaFormatType.PDL);

    public DataProductAssociationArray() {
        this(new DataList());
    }

    public DataProductAssociationArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public DataProductAssociationArray(Collection<DataProductAssociation> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public DataProductAssociationArray(DataList data) {
        super(data, SCHEMA, DataProductAssociation.class);
    }

    public DataProductAssociationArray(DataProductAssociation first, DataProductAssociation ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public DataProductAssociationArray clone() throws CloneNotSupportedException {
        DataProductAssociationArray __clone = (DataProductAssociationArray)super.clone();
        return __clone;
    }

    @Override
    public DataProductAssociationArray copy() throws CloneNotSupportedException {
        DataProductAssociationArray __copy = (DataProductAssociationArray)super.copy();
        return __copy;
    }

    @Override
    protected DataProductAssociation coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new DataProductAssociation(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataProductAssociation.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<DataProductAssociation.ProjectionMask, DataProductAssociation.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? DataProductAssociation.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DataProductAssociation.Fields items() {
            return new DataProductAssociation.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

