/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataprocess;

import com.linkedin.common.DatasetUrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataProcessInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataprocess/**The inputs and outputs of this data process*/@Aspect.name=\"dataProcessInfo\"record DataProcessInfo{/**the inputs of the data process*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"inputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputDatasets\",\"queryByDefault\":false}inputs:optional array[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]/**the outputs of the data process*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@Searchable.`/*`={\"fieldName\":\"outputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numOutputDatasets\",\"queryByDefault\":false}outputs:optional array[com.linkedin.common.DatasetUrn]}", SchemaFormatType.PDL);
    private DatasetUrnArray _inputsField = null;
    private DatasetUrnArray _outputsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Inputs = SCHEMA.getField("inputs");
    private static final RecordDataSchema.Field FIELD_Outputs = SCHEMA.getField("outputs");

    public DataProcessInfo() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public DataProcessInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasInputs() {
        if (this._inputsField != null) {
            return true;
        }
        return this._map.containsKey("inputs");
    }

    public void removeInputs() {
        this._map.remove("inputs");
    }

    @Nullable
    public DatasetUrnArray getInputs(GetMode mode) {
        return this.getInputs();
    }

    @Nullable
    public DatasetUrnArray getInputs() {
        if (this._inputsField != null) {
            return this._inputsField;
        }
        Object __rawValue = this._map.get("inputs");
        this._inputsField = __rawValue == null ? null : new DatasetUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._inputsField;
    }

    public DataProcessInfo setInputs(@Nullable DatasetUrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInputs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInputs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "inputs", value.data());
                this._inputsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "inputs", value.data());
                this._inputsField = value;
            }
        }
        return this;
    }

    public DataProcessInfo setInputs(@Nonnull DatasetUrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field inputs of com.linkedin.dataprocess.DataProcessInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "inputs", value.data());
        this._inputsField = value;
        return this;
    }

    public boolean hasOutputs() {
        if (this._outputsField != null) {
            return true;
        }
        return this._map.containsKey("outputs");
    }

    public void removeOutputs() {
        this._map.remove("outputs");
    }

    @Nullable
    public DatasetUrnArray getOutputs(GetMode mode) {
        return this.getOutputs();
    }

    @Nullable
    public DatasetUrnArray getOutputs() {
        if (this._outputsField != null) {
            return this._outputsField;
        }
        Object __rawValue = this._map.get("outputs");
        this._outputsField = __rawValue == null ? null : new DatasetUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._outputsField;
    }

    public DataProcessInfo setOutputs(@Nullable DatasetUrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOutputs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOutputs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "outputs", value.data());
                this._outputsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "outputs", value.data());
                this._outputsField = value;
            }
        }
        return this;
    }

    public DataProcessInfo setOutputs(@Nonnull DatasetUrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field outputs of com.linkedin.dataprocess.DataProcessInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "outputs", value.data());
        this._outputsField = value;
        return this;
    }

    @Override
    public DataProcessInfo clone() throws CloneNotSupportedException {
        DataProcessInfo __clone = (DataProcessInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataProcessInfo copy() throws CloneNotSupportedException {
        DataProcessInfo __copy = (DataProcessInfo)super.copy();
        __copy._outputsField = null;
        __copy._inputsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataProcessInfo __objectRef;

        private ChangeListener(DataProcessInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "outputs": {
                    this.__objectRef._outputsField = null;
                    break;
                }
                case "inputs": {
                    this.__objectRef._inputsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec inputs() {
            return new PathSpec(this.getPathComponents(), "inputs");
        }

        public PathSpec inputs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "inputs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec outputs() {
            return new PathSpec(this.getPathComponents(), "outputs");
        }

        public PathSpec outputs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "outputs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withInputs() {
            this.getDataMap().put("inputs", 1);
            return this;
        }

        public ProjectionMask withInputs(Integer start, Integer count) {
            this.getDataMap().put("inputs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("inputs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputs").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOutputs() {
            this.getDataMap().put("outputs", 1);
            return this;
        }

        public ProjectionMask withOutputs(Integer start, Integer count) {
            this.getDataMap().put("outputs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("outputs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("outputs").put("$count", count);
            }
            return this;
        }
    }
}

