/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataplatforminstance;

import com.linkedin.common.FabricType;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IcebergWarehouseInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataplatforminstance/**An Iceberg warehouse location and credentails whose read/writes are governed by datahub catalog.*/@Aspect.name=\"icebergWarehouseInfo\"record IcebergWarehouseInfo{/**Path of the root for the backing store of the tables in the warehouse.*/dataRoot:string/**clientId to be used to authenticate with storage hosting this warehouse*/clientId:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**client secret to authenticate with storage hosting this warehouse*/clientSecret:com.linkedin.common.Urn/**region where the warehouse is located.*/region:string,role:optional string,tempCredentialExpirationSeconds:optional int,env:{namespace com.linkedin.common/**Fabric group type*/enum FabricType{/**Designates development fabrics*/DEV/**Designates testing fabrics*/TEST/**Designates quality assurance fabrics*/QA/**Designates user acceptance testing fabrics*/UAT/**Designates early-integration fabrics*/EI/**Designates pre-production fabrics*/PRE/**Designates staging fabrics*/STG/**Designates non-production fabrics*/NON_PROD/**Designates production fabrics*/PROD/**Designates corporation fabrics*/CORP/**Designates review fabrics*/RVW/**Alternative Prod spelling*/PRD/**Alternative Test spelling*/TST/**System Integration Testing*/SIT/**Alternative spelling for sandbox*/SBX/**Designates sandbox fabrics*/SANDBOX}}}", SchemaFormatType.PDL);
    private String _dataRootField = null;
    private Urn _clientIdField = null;
    private Urn _clientSecretField = null;
    private String _regionField = null;
    private String _roleField = null;
    private Integer _tempCredentialExpirationSecondsField = null;
    private FabricType _envField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_DataRoot = SCHEMA.getField("dataRoot");
    private static final RecordDataSchema.Field FIELD_ClientId = SCHEMA.getField("clientId");
    private static final RecordDataSchema.Field FIELD_ClientSecret = SCHEMA.getField("clientSecret");
    private static final RecordDataSchema.Field FIELD_Region = SCHEMA.getField("region");
    private static final RecordDataSchema.Field FIELD_Role = SCHEMA.getField("role");
    private static final RecordDataSchema.Field FIELD_TempCredentialExpirationSeconds = SCHEMA.getField("tempCredentialExpirationSeconds");
    private static final RecordDataSchema.Field FIELD_Env = SCHEMA.getField("env");

    public IcebergWarehouseInfo() {
        super(new DataMap(10, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public IcebergWarehouseInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDataRoot() {
        if (this._dataRootField != null) {
            return true;
        }
        return this._map.containsKey("dataRoot");
    }

    public void removeDataRoot() {
        this._map.remove("dataRoot");
    }

    @Nullable
    public String getDataRoot(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDataRoot();
            }
            case DEFAULT: 
            case NULL: {
                if (this._dataRootField != null) {
                    return this._dataRootField;
                }
                Object __rawValue = this._map.get("dataRoot");
                this._dataRootField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._dataRootField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDataRoot() {
        if (this._dataRootField != null) {
            return this._dataRootField;
        }
        Object __rawValue = this._map.get("dataRoot");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("dataRoot");
        }
        this._dataRootField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._dataRootField;
    }

    public IcebergWarehouseInfo setDataRoot(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDataRoot(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field dataRoot of com.linkedin.dataplatforminstance.IcebergWarehouseInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "dataRoot", value);
                this._dataRootField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDataRoot();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dataRoot", value);
                this._dataRootField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dataRoot", value);
                this._dataRootField = value;
            }
        }
        return this;
    }

    public IcebergWarehouseInfo setDataRoot(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dataRoot of com.linkedin.dataplatforminstance.IcebergWarehouseInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dataRoot", value);
        this._dataRootField = value;
        return this;
    }

    public boolean hasClientId() {
        if (this._clientIdField != null) {
            return true;
        }
        return this._map.containsKey("clientId");
    }

    public void removeClientId() {
        this._map.remove("clientId");
    }

    @Nullable
    public Urn getClientId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getClientId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._clientIdField != null) {
                    return this._clientIdField;
                }
                Object __rawValue = this._map.get("clientId");
                this._clientIdField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._clientIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getClientId() {
        if (this._clientIdField != null) {
            return this._clientIdField;
        }
        Object __rawValue = this._map.get("clientId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("clientId");
        }
        this._clientIdField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._clientIdField;
    }

    public IcebergWarehouseInfo setClientId(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setClientId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field clientId of com.linkedin.dataplatforminstance.IcebergWarehouseInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "clientId", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._clientIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeClientId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "clientId", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._clientIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "clientId", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._clientIdField = value;
            }
        }
        return this;
    }

    public IcebergWarehouseInfo setClientId(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field clientId of com.linkedin.dataplatforminstance.IcebergWarehouseInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "clientId", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._clientIdField = value;
        return this;
    }

    public boolean hasClientSecret() {
        if (this._clientSecretField != null) {
            return true;
        }
        return this._map.containsKey("clientSecret");
    }

    public void removeClientSecret() {
        this._map.remove("clientSecret");
    }

    @Nullable
    public Urn getClientSecret(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getClientSecret();
            }
            case DEFAULT: 
            case NULL: {
                if (this._clientSecretField != null) {
                    return this._clientSecretField;
                }
                Object __rawValue = this._map.get("clientSecret");
                this._clientSecretField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._clientSecretField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getClientSecret() {
        if (this._clientSecretField != null) {
            return this._clientSecretField;
        }
        Object __rawValue = this._map.get("clientSecret");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("clientSecret");
        }
        this._clientSecretField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._clientSecretField;
    }

    public IcebergWarehouseInfo setClientSecret(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setClientSecret(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field clientSecret of com.linkedin.dataplatforminstance.IcebergWarehouseInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "clientSecret", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._clientSecretField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeClientSecret();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "clientSecret", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._clientSecretField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "clientSecret", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._clientSecretField = value;
            }
        }
        return this;
    }

    public IcebergWarehouseInfo setClientSecret(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field clientSecret of com.linkedin.dataplatforminstance.IcebergWarehouseInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "clientSecret", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._clientSecretField = value;
        return this;
    }

    public boolean hasRegion() {
        if (this._regionField != null) {
            return true;
        }
        return this._map.containsKey("region");
    }

    public void removeRegion() {
        this._map.remove("region");
    }

    @Nullable
    public String getRegion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRegion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._regionField != null) {
                    return this._regionField;
                }
                Object __rawValue = this._map.get("region");
                this._regionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._regionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getRegion() {
        if (this._regionField != null) {
            return this._regionField;
        }
        Object __rawValue = this._map.get("region");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("region");
        }
        this._regionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._regionField;
    }

    public IcebergWarehouseInfo setRegion(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRegion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field region of com.linkedin.dataplatforminstance.IcebergWarehouseInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "region", value);
                this._regionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRegion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "region", value);
                this._regionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "region", value);
                this._regionField = value;
            }
        }
        return this;
    }

    public IcebergWarehouseInfo setRegion(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field region of com.linkedin.dataplatforminstance.IcebergWarehouseInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "region", value);
        this._regionField = value;
        return this;
    }

    public boolean hasRole() {
        if (this._roleField != null) {
            return true;
        }
        return this._map.containsKey("role");
    }

    public void removeRole() {
        this._map.remove("role");
    }

    @Nullable
    public String getRole(GetMode mode) {
        return this.getRole();
    }

    @Nullable
    public String getRole() {
        if (this._roleField != null) {
            return this._roleField;
        }
        Object __rawValue = this._map.get("role");
        this._roleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._roleField;
    }

    public IcebergWarehouseInfo setRole(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRole(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRole();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "role", value);
                this._roleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "role", value);
                this._roleField = value;
            }
        }
        return this;
    }

    public IcebergWarehouseInfo setRole(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field role of com.linkedin.dataplatforminstance.IcebergWarehouseInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "role", value);
        this._roleField = value;
        return this;
    }

    public boolean hasTempCredentialExpirationSeconds() {
        if (this._tempCredentialExpirationSecondsField != null) {
            return true;
        }
        return this._map.containsKey("tempCredentialExpirationSeconds");
    }

    public void removeTempCredentialExpirationSeconds() {
        this._map.remove("tempCredentialExpirationSeconds");
    }

    @Nullable
    public Integer getTempCredentialExpirationSeconds(GetMode mode) {
        return this.getTempCredentialExpirationSeconds();
    }

    @Nullable
    public Integer getTempCredentialExpirationSeconds() {
        if (this._tempCredentialExpirationSecondsField != null) {
            return this._tempCredentialExpirationSecondsField;
        }
        Object __rawValue = this._map.get("tempCredentialExpirationSeconds");
        this._tempCredentialExpirationSecondsField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._tempCredentialExpirationSecondsField;
    }

    public IcebergWarehouseInfo setTempCredentialExpirationSeconds(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTempCredentialExpirationSeconds(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTempCredentialExpirationSeconds();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "tempCredentialExpirationSeconds", DataTemplateUtil.coerceIntInput(value));
                this._tempCredentialExpirationSecondsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "tempCredentialExpirationSeconds", DataTemplateUtil.coerceIntInput(value));
                this._tempCredentialExpirationSecondsField = value;
            }
        }
        return this;
    }

    public IcebergWarehouseInfo setTempCredentialExpirationSeconds(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field tempCredentialExpirationSeconds of com.linkedin.dataplatforminstance.IcebergWarehouseInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "tempCredentialExpirationSeconds", DataTemplateUtil.coerceIntInput(value));
        this._tempCredentialExpirationSecondsField = value;
        return this;
    }

    public IcebergWarehouseInfo setTempCredentialExpirationSeconds(int value) {
        CheckedUtil.putWithoutChecking(this._map, "tempCredentialExpirationSeconds", DataTemplateUtil.coerceIntInput(value));
        this._tempCredentialExpirationSecondsField = value;
        return this;
    }

    public boolean hasEnv() {
        if (this._envField != null) {
            return true;
        }
        return this._map.containsKey("env");
    }

    public void removeEnv() {
        this._map.remove("env");
    }

    @Nullable
    public FabricType getEnv(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEnv();
            }
            case DEFAULT: 
            case NULL: {
                if (this._envField != null) {
                    return this._envField;
                }
                Object __rawValue = this._map.get("env");
                this._envField = DataTemplateUtil.coerceEnumOutput(__rawValue, FabricType.class, FabricType.$UNKNOWN);
                return this._envField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FabricType getEnv() {
        if (this._envField != null) {
            return this._envField;
        }
        Object __rawValue = this._map.get("env");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("env");
        }
        this._envField = DataTemplateUtil.coerceEnumOutput(__rawValue, FabricType.class, FabricType.$UNKNOWN);
        return this._envField;
    }

    public IcebergWarehouseInfo setEnv(@Nullable FabricType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEnv(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field env of com.linkedin.dataplatforminstance.IcebergWarehouseInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "env", value.name());
                this._envField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEnv();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "env", value.name());
                this._envField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "env", value.name());
                this._envField = value;
            }
        }
        return this;
    }

    public IcebergWarehouseInfo setEnv(@Nonnull FabricType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field env of com.linkedin.dataplatforminstance.IcebergWarehouseInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "env", value.name());
        this._envField = value;
        return this;
    }

    @Override
    public IcebergWarehouseInfo clone() throws CloneNotSupportedException {
        IcebergWarehouseInfo __clone = (IcebergWarehouseInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IcebergWarehouseInfo copy() throws CloneNotSupportedException {
        IcebergWarehouseInfo __copy = (IcebergWarehouseInfo)super.copy();
        __copy._clientIdField = null;
        __copy._roleField = null;
        __copy._clientSecretField = null;
        __copy._regionField = null;
        __copy._envField = null;
        __copy._dataRootField = null;
        __copy._tempCredentialExpirationSecondsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IcebergWarehouseInfo __objectRef;

        private ChangeListener(IcebergWarehouseInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "clientId": {
                    this.__objectRef._clientIdField = null;
                    break;
                }
                case "role": {
                    this.__objectRef._roleField = null;
                    break;
                }
                case "clientSecret": {
                    this.__objectRef._clientSecretField = null;
                    break;
                }
                case "region": {
                    this.__objectRef._regionField = null;
                    break;
                }
                case "env": {
                    this.__objectRef._envField = null;
                    break;
                }
                case "dataRoot": {
                    this.__objectRef._dataRootField = null;
                    break;
                }
                case "tempCredentialExpirationSeconds": {
                    this.__objectRef._tempCredentialExpirationSecondsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec dataRoot() {
            return new PathSpec(this.getPathComponents(), "dataRoot");
        }

        public PathSpec clientId() {
            return new PathSpec(this.getPathComponents(), "clientId");
        }

        public PathSpec clientSecret() {
            return new PathSpec(this.getPathComponents(), "clientSecret");
        }

        public PathSpec region() {
            return new PathSpec(this.getPathComponents(), "region");
        }

        public PathSpec role() {
            return new PathSpec(this.getPathComponents(), "role");
        }

        public PathSpec tempCredentialExpirationSeconds() {
            return new PathSpec(this.getPathComponents(), "tempCredentialExpirationSeconds");
        }

        public PathSpec env() {
            return new PathSpec(this.getPathComponents(), "env");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(10);
        }

        public ProjectionMask withDataRoot() {
            this.getDataMap().put("dataRoot", 1);
            return this;
        }

        public ProjectionMask withClientId() {
            this.getDataMap().put("clientId", 1);
            return this;
        }

        public ProjectionMask withClientSecret() {
            this.getDataMap().put("clientSecret", 1);
            return this;
        }

        public ProjectionMask withRegion() {
            this.getDataMap().put("region", 1);
            return this;
        }

        public ProjectionMask withRole() {
            this.getDataMap().put("role", 1);
            return this;
        }

        public ProjectionMask withTempCredentialExpirationSeconds() {
            this.getDataMap().put("tempCredentialExpirationSeconds", 1);
            return this;
        }

        public ProjectionMask withEnv() {
            this.getDataMap().put("env", 1);
            return this;
        }
    }
}

