/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import com.linkedin.data.schema.annotation.TraverserContext;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvedPropertiesReaderVisitor
implements SchemaVisitor {
    private Map<PathSpec, Map<String, Object>> _leafFieldsToResolvedPropertiesMap = new HashMap<PathSpec, Map<String, Object>>();
    private static final Logger LOG = LoggerFactory.getLogger(ResolvedPropertiesReaderVisitor.class);

    @Override
    public void callbackOnContext(TraverserContext context, DataSchemaTraverse.Order order) {
        if (order == DataSchemaTraverse.Order.POST_ORDER) {
            return;
        }
        DataSchema currentSchema = context.getCurrentSchema();
        if (currentSchema.isPrimitive() || currentSchema instanceof EnumDataSchema || currentSchema instanceof FixedDataSchema) {
            Map<String, Object> resolvedProperties = currentSchema.getResolvedProperties();
            this._leafFieldsToResolvedPropertiesMap.put(new PathSpec(context.getSchemaPathSpec()), resolvedProperties);
            if (LOG.isDebugEnabled()) {
                String mapStringified = resolvedProperties.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining("&"));
                LOG.debug(String.format("/%s ::: %s", String.join((CharSequence)"/", context.getSchemaPathSpec()), mapStringified));
            }
        }
    }

    @Override
    public SchemaVisitor.VisitorContext getInitialVisitorContext() {
        return new SchemaVisitor.VisitorContext(){};
    }

    @Override
    public SchemaVisitorTraversalResult getSchemaVisitorTraversalResult() {
        return null;
    }

    @Deprecated
    public Map<String, Map<String, Object>> getLeafFieldsPathSpecToResolvedPropertiesMap() {
        return this._leafFieldsToResolvedPropertiesMap.entrySet().stream().collect(Collectors.toMap(e -> ((PathSpec)e.getKey()).toString(), Map.Entry::getValue));
    }

    public Map<PathSpec, Map<String, Object>> getLeafFieldsToResolvedPropertiesMap() {
        return this._leafFieldsToResolvedPropertiesMap;
    }
}

