/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.Null;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.template.JacksonDataTemplateCodec;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

abstract class PdlBuilder {
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("array", "enum", "fixed", "import", "includes", "map", "namespace", "optional", "package", "record", "typeref", "union", "null", "true", "false"));
    private static final char ESCAPE_CHAR = '`';
    private static final Pattern IDENTIFIER_CHARS = Pattern.compile("[0-9a-zA-Z_-]*");
    private static final int DEFAULT_JSON_CODEC_BUFFER_SIZE = 4096;
    private final Writer _writer;

    PdlBuilder(Writer writer) {
        this._writer = writer;
    }

    PdlBuilder write(String text) throws IOException {
        this._writer.write(text);
        return this;
    }

    PdlBuilder writeComma() throws IOException {
        this.write(",");
        return this;
    }

    PdlBuilder writeSpace() throws IOException {
        this.write(" ");
        return this;
    }

    abstract PdlBuilder newline() throws IOException;

    abstract PdlBuilder indent() throws IOException;

    abstract PdlBuilder increaseIndent();

    abstract PdlBuilder decreaseIndent();

    abstract boolean writeDoc(String var1) throws IOException;

    PdlBuilder writeProperties(List<String> prefix, Map<String, Object> properties) throws IOException {
        List orderedProperties = properties.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        for (Map.Entry entry : orderedProperties) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            ArrayList<String> pathParts = new ArrayList<String>(prefix);
            pathParts.add(key);
            if (value instanceof DataMap) {
                DataMap dm = (DataMap)value;
                if (dm.size() == 1) {
                    this.writeProperties(pathParts, dm);
                    continue;
                }
                this.writeProperty(pathParts, dm);
                continue;
            }
            if (Boolean.TRUE.equals(value)) {
                this.indent().write("@").writePath(pathParts).newline();
                continue;
            }
            this.writeProperty(pathParts, value);
        }
        return this;
    }

    private void writeProperty(List<String> path, Object value) throws IOException {
        this.indent().write("@").writePath(path).writeSpace().write("=").writeSpace().writeJson(value).newline();
    }

    private PdlBuilder writePath(List<String> path) throws IOException {
        this.write(path.stream().map(PdlBuilder::escapePropertyKey).collect(Collectors.joining(".")));
        return this;
    }

    private static String escapePropertyKey(String propertyKey) {
        if (KEYWORDS.contains(propertyKey = propertyKey.trim()) || !IDENTIFIER_CHARS.matcher(propertyKey).matches()) {
            return '`' + propertyKey + '`';
        }
        return propertyKey;
    }

    PdlBuilder writeIdentifier(String unescapedIdentifier) throws IOException {
        this.write(PdlBuilder.escapeIdentifier(unescapedIdentifier));
        return this;
    }

    private static String escapeIdentifier(String identifier) {
        return Arrays.stream(identifier.split("\\.")).map(part -> {
            if (KEYWORDS.contains(part)) {
                return '`' + part.trim() + '`';
            }
            return part.trim();
        }).collect(Collectors.joining("."));
    }

    PdlBuilder writeJson(Object value) throws IOException {
        return this.writeJson(value, null);
    }

    abstract PdlBuilder writeJson(Object var1, DataSchema var2) throws IOException;

    protected String toJson(Object value, JacksonDataCodec jsonCodec) throws IOException {
        if (value instanceof DataMap) {
            return jsonCodec.mapToString((DataMap)value);
        }
        if (value instanceof DataList) {
            return jsonCodec.listToString((DataList)value);
        }
        if (value instanceof String) {
            return PdlBuilder.escapeJsonString((String)value);
        }
        if (value instanceof Number) {
            return String.valueOf(value);
        }
        if (value instanceof Boolean) {
            return String.valueOf(value);
        }
        if (value instanceof ByteString) {
            return PdlBuilder.escapeJsonString(((ByteString)value).asAvroString());
        }
        if (value instanceof Null) {
            return "null";
        }
        throw new IllegalArgumentException("Unsupported data type: " + value.getClass());
    }

    protected String toJson(Object value, JacksonDataTemplateCodec jsonCodec, DataSchema schema) throws IOException {
        if (value instanceof DataMap || value instanceof DataList) {
            StringWriter out = new StringWriter(4096);
            jsonCodec.writeDataTemplate(value, schema, out, true);
            return out.toString();
        }
        return this.toJson(value, jsonCodec);
    }

    private static String escapeJsonString(String value) {
        return "\"" + StringEscapeUtils.escapeJava(value) + "\"";
    }

    protected static interface Provider {
        public PdlBuilder newInstance(Writer var1);
    }
}

