/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.entitystream.AbstractJacksonDataEncoder;
import com.linkedin.data.codec.entitystream.JacksonLICORStreamDataCodec;
import com.linkedin.data.codec.symbol.SymbolTable;
import java.io.IOException;

public class JacksonLICORDataEncoder
extends AbstractJacksonDataEncoder {
    private final SymbolTable _symbolTable;

    public JacksonLICORDataEncoder(DataMap dataMap, int bufferSize, boolean encodeBinary) {
        this(dataMap, bufferSize, encodeBinary, null);
    }

    public JacksonLICORDataEncoder(DataList dataList, int bufferSize, boolean encodeBinary) {
        this(dataList, bufferSize, encodeBinary, null);
    }

    public JacksonLICORDataEncoder(DataMap dataMap, int bufferSize, boolean encodeBinary, SymbolTable symbolTable) {
        super(JacksonLICORStreamDataCodec.getFactory(encodeBinary), dataMap, bufferSize);
        this._symbolTable = symbolTable;
    }

    public JacksonLICORDataEncoder(DataList dataList, int bufferSize, boolean encodeBinary, SymbolTable symbolTable) {
        super(JacksonLICORStreamDataCodec.getFactory(encodeBinary), dataList, bufferSize);
        this._symbolTable = symbolTable;
    }

    @Override
    @Deprecated
    protected void writeStartObject() throws IOException {
        this._generator.writeStartArray();
        this._generator.writeNumber((short)0);
    }

    @Override
    @Deprecated
    protected void writeStartArray() throws IOException {
        this._generator.writeStartArray();
        this._generator.writeNumber((short)1);
    }

    @Override
    @Deprecated
    protected void writeFieldName(String name) throws IOException {
        int fieldId;
        if (this._symbolTable != null && (fieldId = this._symbolTable.getSymbolId(name)) != -1) {
            this._generator.writeNumber(fieldId);
        } else {
            this._generator.writeString(name);
        }
    }

    @Override
    @Deprecated
    protected void writeEndObject() throws IOException {
        this.writeEndArray();
    }
}

