/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.data.template.DataTemplateUtil;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TupleKey {
    public static final char START_TUPLE = '(';
    public static final char END_TUPLE = ')';
    public static final char DELIMITER = ',';
    private List<String> _tuple;

    public TupleKey(String ... tuple) {
        this._tuple = Arrays.asList(TupleKey.checkStringsNotNull(tuple));
    }

    public TupleKey(List<String> tuple) {
        this(tuple, true);
    }

    private TupleKey(List<String> tuple, boolean calledFromExternal) {
        this._tuple = calledFromExternal ? Collections.unmodifiableList(TupleKey.checkStringsNotNull(tuple)) : tuple;
    }

    private TupleKey(String oneElement) {
        if (oneElement == null) {
            throw new NullPointerException("Cannot create URN with null part.");
        }
        this._tuple = Collections.singletonList(oneElement);
    }

    public static TupleKey createWithOneKeyPart(String input) {
        return new TupleKey(input);
    }

    public static TupleKey create(Object ... tuple) {
        ArrayList<String> parts = new ArrayList<String>(tuple.length);
        for (Object o : tuple) {
            if (o == null) {
                throw new NullPointerException("Cannot create a Urn from tuple with null parameter.");
            }
            String objString = o.toString();
            if (objString.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a Urn from tuple with an empty value.");
            }
            parts.add(objString);
        }
        return new TupleKey(Collections.unmodifiableList(parts), false);
    }

    public static TupleKey create(Collection<?> tuple) {
        ArrayList<String> parts = new ArrayList<String>(tuple.size());
        for (Object o : tuple) {
            if (o == null) {
                throw new NullPointerException("Cannot create a Urn from tuple with null parameter.");
            }
            parts.add(o.toString());
        }
        return new TupleKey(Collections.unmodifiableList(parts), false);
    }

    public String getFirst() {
        return this._tuple.get(0);
    }

    public String get(int index) {
        return this._tuple.get(index);
    }

    public <T> T getAs(int index, Class<T> clazz) {
        Enum result;
        String value = this.get(index);
        if (value == null) {
            return null;
        }
        if (String.class.equals(clazz)) {
            result = value;
        } else if (Short.TYPE.equals(clazz) || Short.class.equals(clazz)) {
            result = Short.valueOf(value);
        } else if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                throw new IllegalArgumentException("Invalid boolean value: " + value);
            }
            result = Boolean.valueOf(value);
        } else if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            result = Integer.valueOf(value);
        } else if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            result = Long.valueOf(value);
        } else if (Enum.class.isAssignableFrom(clazz)) {
            result = this.getEnumValue(clazz, value);
        } else if (DataTemplateUtil.hasCoercer(clazz)) {
            result = DataTemplateUtil.coerceOutput(value, clazz);
        } else {
            throw new IllegalArgumentException("Cannot coerce String to type: " + clazz.getName());
        }
        String rv = result;
        return (T)rv;
    }

    private <E extends Enum<E>> Enum<E> getEnumValue(Class<?> clazz, String value) {
        Class<Enum> enumClazz = clazz.asSubclass(Enum.class);
        return Enum.valueOf(enumClazz, value);
    }

    public int size() {
        return this._tuple.size();
    }

    public List<String> getParts() {
        return this._tuple;
    }

    public String toString() {
        if (this._tuple.size() == 1) {
            return this._tuple.get(0);
        }
        StringBuilder result = new StringBuilder();
        result.append('(');
        boolean delimit = false;
        for (String value : this._tuple) {
            if (delimit) {
                result.append(',');
            }
            result.append(value);
            delimit = true;
        }
        result.append(')');
        return result.toString();
    }

    public int hashCode() {
        return this._tuple.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this._tuple.equals(((TupleKey)obj)._tuple);
    }

    public static TupleKey fromString(String s2) throws URISyntaxException {
        return new TupleKey(TupleKey.parseKeyParts(s2, 0), false);
    }

    public static TupleKey fromString(String s2, int startIndex) throws URISyntaxException {
        return new TupleKey(TupleKey.parseKeyParts(s2, startIndex), false);
    }

    private static List<String> parseKeyParts(String input, int startIndex) throws URISyntaxException {
        int lastPartEnd;
        if (startIndex >= input.length()) {
            return Collections.emptyList();
        }
        if (input.charAt(startIndex) != '(') {
            if (!TupleKey.hasBalancedParens(input, startIndex)) {
                throw new URISyntaxException(input, "mismatched paren nesting");
            }
            return Collections.singletonList(input.substring(startIndex));
        }
        ArrayList<String> parts = new ArrayList<String>(3);
        int numStartedParenPairs = 1;
        int partStart = startIndex + 1;
        for (int i = startIndex + 1; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '(') {
                ++numStartedParenPairs;
                continue;
            }
            if (c == ')') {
                if (--numStartedParenPairs >= 0) continue;
                throw new URISyntaxException(input, "mismatched paren nesting");
            }
            if (c != ',' || numStartedParenPairs != 1) continue;
            if (i - partStart <= 0) {
                throw new URISyntaxException(input, "empty part disallowed");
            }
            parts.add(input.substring(partStart, i));
            partStart = i + 1;
        }
        if (numStartedParenPairs != 0) {
            throw new URISyntaxException(input, "mismatched paren nesting");
        }
        int n = lastPartEnd = input.charAt(input.length() - 1) == ')' ? input.length() - 1 : input.length();
        if (lastPartEnd - partStart <= 0) {
            throw new URISyntaxException(input, "empty part disallowed");
        }
        parts.add(input.substring(partStart, lastPartEnd));
        return Collections.unmodifiableList(parts);
    }

    private static boolean hasBalancedParens(String input, int startIndex) {
        int numStartedParenPairs = 0;
        for (int i = startIndex; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '(') {
                ++numStartedParenPairs;
                continue;
            }
            if (c != ')' || --numStartedParenPairs >= 0) continue;
            return false;
        }
        return numStartedParenPairs == 0;
    }

    private static String[] checkStringsNotNull(String ... array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new NullPointerException("at index " + i);
        }
        return array;
    }

    private static List<String> checkStringsNotNull(List<String> list) {
        int i = 0;
        for (String str : list) {
            if (str == null) {
                throw new NullPointerException("at index " + i);
            }
            ++i;
        }
        return list;
    }
}

