/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.VersionTag;
import com.linkedin.common.VersionTagArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.versionset.VersioningScheme;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VersionProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Properties about a versioned asset i.e. dataset, ML Model, etc.*/@Aspect.name=\"versionProperties\"record VersionProperties{/**The linked Version Set entity that ties multiple versioned assets together*/@Relationship={\"entityTypes\":[\"versionSet\"],\"name\":\"VersionOf\"}@Searchable.queryByDefault=false,versionSet:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**Label for this versioned asset, is unique within a version set*/@Searchable.`/versionTag`={\"fieldName\":\"version\",\"queryByDefault\":false}version:/**A resource-defined string representing the resource state for the purpose of concurrency control*/record VersionTag{versionTag:optional string,metadataAttribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}/**Associated aliases for this versioned asset*/@Searchable.`/*/versionTag`={\"fieldName\":\"aliases\",\"queryByDefault\":false}aliases:array[VersionTag]=[]/**Comment documenting what this version was created for, changes, or represents*/comment:optional string/**Sort identifier that determines where a version lives in the order of the Version Set.\nWhat this looks like depends on the Version Scheme. For sort ids generated by DataHub we use an 8 character string representation.*/@Searchable={\"fieldName\":\"versionSortId\",\"queryByDefault\":false}sortId:string/**What versioning scheme `sortId` belongs to.\nDefaults to a plain string that is lexicographically sorted.*/versioningScheme:{namespace com.linkedin.versionset,enum VersioningScheme{/**String sorted lexicographically.*/LEXICOGRAPHIC_STRING/**String managed by DataHub. Currently, an 8 character alphabetical string.*/ALPHANUMERIC_GENERATED_BY_DATAHUB}}=\"LEXICOGRAPHIC_STRING\"/**Timestamp reflecting when this asset version was created in the source system.*/sourceCreatedTimestamp:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:Time/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Timestamp reflecting when the metadata for this version was created in DataHub*/metadataCreatedTimestamp:optional AuditStamp/**Marks whether this version is currently the latest. Set by a side effect and should not be modified by API.*/@Searchable={\"fieldType\":\"BOOLEAN\",\"queryByDefault\":false}isLatest:optional boolean}", SchemaFormatType.PDL);
    private Urn _versionSetField = null;
    private VersionTag _versionField = null;
    private VersionTagArray _aliasesField = null;
    private String _commentField = null;
    private String _sortIdField = null;
    private VersioningScheme _versioningSchemeField = null;
    private AuditStamp _sourceCreatedTimestampField = null;
    private AuditStamp _metadataCreatedTimestampField = null;
    private Boolean _isLatestField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_VersionSet = SCHEMA.getField("versionSet");
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");
    private static final RecordDataSchema.Field FIELD_Aliases = SCHEMA.getField("aliases");
    private static final VersionTagArray DEFAULT_Aliases;
    private static final RecordDataSchema.Field FIELD_Comment;
    private static final RecordDataSchema.Field FIELD_SortId;
    private static final RecordDataSchema.Field FIELD_VersioningScheme;
    private static final VersioningScheme DEFAULT_VersioningScheme;
    private static final RecordDataSchema.Field FIELD_SourceCreatedTimestamp;
    private static final RecordDataSchema.Field FIELD_MetadataCreatedTimestamp;
    private static final RecordDataSchema.Field FIELD_IsLatest;

    public VersionProperties() {
        super(new DataMap(12, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public VersionProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasVersionSet() {
        if (this._versionSetField != null) {
            return true;
        }
        return this._map.containsKey("versionSet");
    }

    public void removeVersionSet() {
        this._map.remove("versionSet");
    }

    @Nullable
    public Urn getVersionSet(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVersionSet();
            }
            case DEFAULT: 
            case NULL: {
                if (this._versionSetField != null) {
                    return this._versionSetField;
                }
                Object __rawValue = this._map.get("versionSet");
                this._versionSetField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._versionSetField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getVersionSet() {
        if (this._versionSetField != null) {
            return this._versionSetField;
        }
        Object __rawValue = this._map.get("versionSet");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("versionSet");
        }
        this._versionSetField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._versionSetField;
    }

    public VersionProperties setVersionSet(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersionSet(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field versionSet of com.linkedin.common.VersionProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "versionSet", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._versionSetField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersionSet();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "versionSet", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._versionSetField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "versionSet", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._versionSetField = value;
            }
        }
        return this;
    }

    public VersionProperties setVersionSet(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field versionSet of com.linkedin.common.VersionProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "versionSet", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._versionSetField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public VersionTag getVersion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVersion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._versionField != null) {
                    return this._versionField;
                }
                Object __rawValue = this._map.get("version");
                this._versionField = __rawValue == null ? null : new VersionTag(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._versionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public VersionTag getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("version");
        }
        this._versionField = __rawValue == null ? null : new VersionTag(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._versionField;
    }

    public VersionProperties setVersion(@Nullable VersionTag value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field version of com.linkedin.common.VersionProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
            }
        }
        return this;
    }

    public VersionProperties setVersion(@Nonnull VersionTag value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.common.VersionProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value.data());
        this._versionField = value;
        return this;
    }

    public boolean hasAliases() {
        if (this._aliasesField != null) {
            return true;
        }
        return this._map.containsKey("aliases");
    }

    public void removeAliases() {
        this._map.remove("aliases");
    }

    @Nullable
    public VersionTagArray getAliases(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getAliases();
            }
            case NULL: {
                if (this._aliasesField != null) {
                    return this._aliasesField;
                }
                Object __rawValue = this._map.get("aliases");
                this._aliasesField = __rawValue == null ? null : new VersionTagArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._aliasesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public VersionTagArray getAliases() {
        if (this._aliasesField != null) {
            return this._aliasesField;
        }
        Object __rawValue = this._map.get("aliases");
        if (__rawValue == null) {
            return DEFAULT_Aliases;
        }
        this._aliasesField = __rawValue == null ? null : new VersionTagArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._aliasesField;
    }

    public VersionProperties setAliases(@Nullable VersionTagArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAliases(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aliases of com.linkedin.common.VersionProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "aliases", value.data());
                this._aliasesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAliases();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aliases", value.data());
                this._aliasesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aliases", value.data());
                this._aliasesField = value;
            }
        }
        return this;
    }

    public VersionProperties setAliases(@Nonnull VersionTagArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aliases of com.linkedin.common.VersionProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aliases", value.data());
        this._aliasesField = value;
        return this;
    }

    public boolean hasComment() {
        if (this._commentField != null) {
            return true;
        }
        return this._map.containsKey("comment");
    }

    public void removeComment() {
        this._map.remove("comment");
    }

    @Nullable
    public String getComment(GetMode mode) {
        return this.getComment();
    }

    @Nullable
    public String getComment() {
        if (this._commentField != null) {
            return this._commentField;
        }
        Object __rawValue = this._map.get("comment");
        this._commentField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._commentField;
    }

    public VersionProperties setComment(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setComment(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeComment();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "comment", value);
                this._commentField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "comment", value);
                this._commentField = value;
            }
        }
        return this;
    }

    public VersionProperties setComment(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field comment of com.linkedin.common.VersionProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "comment", value);
        this._commentField = value;
        return this;
    }

    public boolean hasSortId() {
        if (this._sortIdField != null) {
            return true;
        }
        return this._map.containsKey("sortId");
    }

    public void removeSortId() {
        this._map.remove("sortId");
    }

    @Nullable
    public String getSortId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSortId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._sortIdField != null) {
                    return this._sortIdField;
                }
                Object __rawValue = this._map.get("sortId");
                this._sortIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._sortIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getSortId() {
        if (this._sortIdField != null) {
            return this._sortIdField;
        }
        Object __rawValue = this._map.get("sortId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("sortId");
        }
        this._sortIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._sortIdField;
    }

    public VersionProperties setSortId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSortId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field sortId of com.linkedin.common.VersionProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "sortId", value);
                this._sortIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSortId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sortId", value);
                this._sortIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sortId", value);
                this._sortIdField = value;
            }
        }
        return this;
    }

    public VersionProperties setSortId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sortId of com.linkedin.common.VersionProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sortId", value);
        this._sortIdField = value;
        return this;
    }

    public boolean hasVersioningScheme() {
        if (this._versioningSchemeField != null) {
            return true;
        }
        return this._map.containsKey("versioningScheme");
    }

    public void removeVersioningScheme() {
        this._map.remove("versioningScheme");
    }

    @Nullable
    public VersioningScheme getVersioningScheme(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getVersioningScheme();
            }
            case NULL: {
                if (this._versioningSchemeField != null) {
                    return this._versioningSchemeField;
                }
                Object __rawValue = this._map.get("versioningScheme");
                this._versioningSchemeField = DataTemplateUtil.coerceEnumOutput(__rawValue, VersioningScheme.class, VersioningScheme.$UNKNOWN);
                return this._versioningSchemeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public VersioningScheme getVersioningScheme() {
        if (this._versioningSchemeField != null) {
            return this._versioningSchemeField;
        }
        Object __rawValue = this._map.get("versioningScheme");
        if (__rawValue == null) {
            return DEFAULT_VersioningScheme;
        }
        this._versioningSchemeField = DataTemplateUtil.coerceEnumOutput(__rawValue, VersioningScheme.class, VersioningScheme.$UNKNOWN);
        return this._versioningSchemeField;
    }

    public VersionProperties setVersioningScheme(@Nullable VersioningScheme value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersioningScheme(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field versioningScheme of com.linkedin.common.VersionProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "versioningScheme", value.name());
                this._versioningSchemeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersioningScheme();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "versioningScheme", value.name());
                this._versioningSchemeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "versioningScheme", value.name());
                this._versioningSchemeField = value;
            }
        }
        return this;
    }

    public VersionProperties setVersioningScheme(@Nonnull VersioningScheme value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field versioningScheme of com.linkedin.common.VersionProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "versioningScheme", value.name());
        this._versioningSchemeField = value;
        return this;
    }

    public boolean hasSourceCreatedTimestamp() {
        if (this._sourceCreatedTimestampField != null) {
            return true;
        }
        return this._map.containsKey("sourceCreatedTimestamp");
    }

    public void removeSourceCreatedTimestamp() {
        this._map.remove("sourceCreatedTimestamp");
    }

    @Nullable
    public AuditStamp getSourceCreatedTimestamp(GetMode mode) {
        return this.getSourceCreatedTimestamp();
    }

    @Nullable
    public AuditStamp getSourceCreatedTimestamp() {
        if (this._sourceCreatedTimestampField != null) {
            return this._sourceCreatedTimestampField;
        }
        Object __rawValue = this._map.get("sourceCreatedTimestamp");
        this._sourceCreatedTimestampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._sourceCreatedTimestampField;
    }

    public VersionProperties setSourceCreatedTimestamp(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSourceCreatedTimestamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSourceCreatedTimestamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceCreatedTimestamp", value.data());
                this._sourceCreatedTimestampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sourceCreatedTimestamp", value.data());
                this._sourceCreatedTimestampField = value;
            }
        }
        return this;
    }

    public VersionProperties setSourceCreatedTimestamp(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sourceCreatedTimestamp of com.linkedin.common.VersionProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sourceCreatedTimestamp", value.data());
        this._sourceCreatedTimestampField = value;
        return this;
    }

    public boolean hasMetadataCreatedTimestamp() {
        if (this._metadataCreatedTimestampField != null) {
            return true;
        }
        return this._map.containsKey("metadataCreatedTimestamp");
    }

    public void removeMetadataCreatedTimestamp() {
        this._map.remove("metadataCreatedTimestamp");
    }

    @Nullable
    public AuditStamp getMetadataCreatedTimestamp(GetMode mode) {
        return this.getMetadataCreatedTimestamp();
    }

    @Nullable
    public AuditStamp getMetadataCreatedTimestamp() {
        if (this._metadataCreatedTimestampField != null) {
            return this._metadataCreatedTimestampField;
        }
        Object __rawValue = this._map.get("metadataCreatedTimestamp");
        this._metadataCreatedTimestampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._metadataCreatedTimestampField;
    }

    public VersionProperties setMetadataCreatedTimestamp(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMetadataCreatedTimestamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMetadataCreatedTimestamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "metadataCreatedTimestamp", value.data());
                this._metadataCreatedTimestampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "metadataCreatedTimestamp", value.data());
                this._metadataCreatedTimestampField = value;
            }
        }
        return this;
    }

    public VersionProperties setMetadataCreatedTimestamp(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field metadataCreatedTimestamp of com.linkedin.common.VersionProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "metadataCreatedTimestamp", value.data());
        this._metadataCreatedTimestampField = value;
        return this;
    }

    public boolean hasIsLatest() {
        if (this._isLatestField != null) {
            return true;
        }
        return this._map.containsKey("isLatest");
    }

    public void removeIsLatest() {
        this._map.remove("isLatest");
    }

    @Nullable
    public Boolean isIsLatest(GetMode mode) {
        return this.isIsLatest();
    }

    @Nullable
    public Boolean isIsLatest() {
        if (this._isLatestField != null) {
            return this._isLatestField;
        }
        Object __rawValue = this._map.get("isLatest");
        this._isLatestField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isLatestField;
    }

    public VersionProperties setIsLatest(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsLatest(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsLatest();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isLatest", value);
                this._isLatestField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isLatest", value);
                this._isLatestField = value;
            }
        }
        return this;
    }

    public VersionProperties setIsLatest(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isLatest of com.linkedin.common.VersionProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isLatest", value);
        this._isLatestField = value;
        return this;
    }

    public VersionProperties setIsLatest(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isLatest", value);
        this._isLatestField = value;
        return this;
    }

    @Override
    public VersionProperties clone() throws CloneNotSupportedException {
        VersionProperties __clone = (VersionProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public VersionProperties copy() throws CloneNotSupportedException {
        VersionProperties __copy = (VersionProperties)super.copy();
        __copy._sourceCreatedTimestampField = null;
        __copy._versionSetField = null;
        __copy._aliasesField = null;
        __copy._versioningSchemeField = null;
        __copy._isLatestField = null;
        __copy._sortIdField = null;
        __copy._metadataCreatedTimestampField = null;
        __copy._commentField = null;
        __copy._versionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Comment = SCHEMA.getField("comment");
        FIELD_SortId = SCHEMA.getField("sortId");
        FIELD_VersioningScheme = SCHEMA.getField("versioningScheme");
        FIELD_SourceCreatedTimestamp = SCHEMA.getField("sourceCreatedTimestamp");
        FIELD_MetadataCreatedTimestamp = SCHEMA.getField("metadataCreatedTimestamp");
        FIELD_IsLatest = SCHEMA.getField("isLatest");
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_Aliases = FIELD_Aliases.getDefault() == null ? null : new VersionTagArray(DataTemplateUtil.castOrThrow(FIELD_Aliases.getDefault(), DataList.class));
        DEFAULT_VersioningScheme = DataTemplateUtil.coerceEnumOutput(FIELD_VersioningScheme.getDefault(), VersioningScheme.class, VersioningScheme.$UNKNOWN);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final VersionProperties __objectRef;

        private ChangeListener(VersionProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "sourceCreatedTimestamp": {
                    this.__objectRef._sourceCreatedTimestampField = null;
                    break;
                }
                case "versionSet": {
                    this.__objectRef._versionSetField = null;
                    break;
                }
                case "aliases": {
                    this.__objectRef._aliasesField = null;
                    break;
                }
                case "versioningScheme": {
                    this.__objectRef._versioningSchemeField = null;
                    break;
                }
                case "isLatest": {
                    this.__objectRef._isLatestField = null;
                    break;
                }
                case "sortId": {
                    this.__objectRef._sortIdField = null;
                    break;
                }
                case "metadataCreatedTimestamp": {
                    this.__objectRef._metadataCreatedTimestampField = null;
                    break;
                }
                case "comment": {
                    this.__objectRef._commentField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec versionSet() {
            return new PathSpec(this.getPathComponents(), "versionSet");
        }

        public VersionTag.Fields version() {
            return new VersionTag.Fields(this.getPathComponents(), "version");
        }

        public VersionTagArray.Fields aliases() {
            return new VersionTagArray.Fields(this.getPathComponents(), "aliases");
        }

        public PathSpec aliases(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "aliases");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec comment() {
            return new PathSpec(this.getPathComponents(), "comment");
        }

        public PathSpec sortId() {
            return new PathSpec(this.getPathComponents(), "sortId");
        }

        public PathSpec versioningScheme() {
            return new PathSpec(this.getPathComponents(), "versioningScheme");
        }

        public AuditStamp.Fields sourceCreatedTimestamp() {
            return new AuditStamp.Fields(this.getPathComponents(), "sourceCreatedTimestamp");
        }

        public AuditStamp.Fields metadataCreatedTimestamp() {
            return new AuditStamp.Fields(this.getPathComponents(), "metadataCreatedTimestamp");
        }

        public PathSpec isLatest() {
            return new PathSpec(this.getPathComponents(), "isLatest");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private VersionTag.ProjectionMask _versionMask;
        private VersionTagArray.ProjectionMask _aliasesMask;
        private AuditStamp.ProjectionMask _sourceCreatedTimestampMask;
        private AuditStamp.ProjectionMask _metadataCreatedTimestampMask;

        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withVersionSet() {
            this.getDataMap().put("versionSet", 1);
            return this;
        }

        public ProjectionMask withVersion(Function<VersionTag.ProjectionMask, VersionTag.ProjectionMask> nestedMask) {
            this._versionMask = nestedMask.apply(this._versionMask == null ? VersionTag.createMask() : this._versionMask);
            this.getDataMap().put("version", this._versionMask.getDataMap());
            return this;
        }

        public ProjectionMask withVersion() {
            this._versionMask = null;
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withAliases(Function<VersionTagArray.ProjectionMask, VersionTagArray.ProjectionMask> nestedMask) {
            this._aliasesMask = nestedMask.apply(this._aliasesMask == null ? VersionTagArray.createMask() : this._aliasesMask);
            this.getDataMap().put("aliases", this._aliasesMask.getDataMap());
            return this;
        }

        public ProjectionMask withAliases() {
            this._aliasesMask = null;
            this.getDataMap().put("aliases", 1);
            return this;
        }

        public ProjectionMask withAliases(Function<VersionTagArray.ProjectionMask, VersionTagArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._aliasesMask = nestedMask.apply(this._aliasesMask == null ? VersionTagArray.createMask() : this._aliasesMask);
            this.getDataMap().put("aliases", this._aliasesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("aliases").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("aliases").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAliases(Integer start, Integer count) {
            this._aliasesMask = null;
            this.getDataMap().put("aliases", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("aliases").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("aliases").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withComment() {
            this.getDataMap().put("comment", 1);
            return this;
        }

        public ProjectionMask withSortId() {
            this.getDataMap().put("sortId", 1);
            return this;
        }

        public ProjectionMask withVersioningScheme() {
            this.getDataMap().put("versioningScheme", 1);
            return this;
        }

        public ProjectionMask withSourceCreatedTimestamp(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._sourceCreatedTimestampMask = nestedMask.apply(this._sourceCreatedTimestampMask == null ? AuditStamp.createMask() : this._sourceCreatedTimestampMask);
            this.getDataMap().put("sourceCreatedTimestamp", this._sourceCreatedTimestampMask.getDataMap());
            return this;
        }

        public ProjectionMask withSourceCreatedTimestamp(MaskMap nestedMask) {
            this.getDataMap().put("sourceCreatedTimestamp", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withSourceCreatedTimestamp() {
            this._sourceCreatedTimestampMask = null;
            this.getDataMap().put("sourceCreatedTimestamp", 1);
            return this;
        }

        public ProjectionMask withMetadataCreatedTimestamp(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._metadataCreatedTimestampMask = nestedMask.apply(this._metadataCreatedTimestampMask == null ? AuditStamp.createMask() : this._metadataCreatedTimestampMask);
            this.getDataMap().put("metadataCreatedTimestamp", this._metadataCreatedTimestampMask.getDataMap());
            return this;
        }

        public ProjectionMask withMetadataCreatedTimestamp(MaskMap nestedMask) {
            this.getDataMap().put("metadataCreatedTimestamp", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withMetadataCreatedTimestamp() {
            this._metadataCreatedTimestampMask = null;
            this.getDataMap().put("metadataCreatedTimestamp", 1);
            return this;
        }

        public ProjectionMask withIsLatest() {
            this.getDataMap().put("isLatest", 1);
            return this;
        }
    }
}

