/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.GlossaryTermAssociation;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class GlossaryTermAssociationArray
extends WrappingArrayTemplate<GlossaryTermAssociation> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.common/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}}]", SchemaFormatType.PDL);

    public GlossaryTermAssociationArray() {
        this(new DataList());
    }

    public GlossaryTermAssociationArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public GlossaryTermAssociationArray(Collection<GlossaryTermAssociation> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public GlossaryTermAssociationArray(DataList data) {
        super(data, SCHEMA, GlossaryTermAssociation.class);
    }

    public GlossaryTermAssociationArray(GlossaryTermAssociation first, GlossaryTermAssociation ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public GlossaryTermAssociationArray clone() throws CloneNotSupportedException {
        GlossaryTermAssociationArray __clone = (GlossaryTermAssociationArray)super.clone();
        return __clone;
    }

    @Override
    public GlossaryTermAssociationArray copy() throws CloneNotSupportedException {
        GlossaryTermAssociationArray __copy = (GlossaryTermAssociationArray)super.copy();
        return __copy;
    }

    @Override
    protected GlossaryTermAssociation coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new GlossaryTermAssociation(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private GlossaryTermAssociation.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<GlossaryTermAssociation.ProjectionMask, GlossaryTermAssociation.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? GlossaryTermAssociation.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public GlossaryTermAssociation.Fields items() {
            return new GlossaryTermAssociation.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

