/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.TagAssociationArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlobalTags
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Tag aspect used for applying tags to an entity*/@Aspect.name=\"globalTags\"record GlobalTags{/**Tags associated with a given entity*/@Relationship.`/*/tag`={\"entityTypes\":[\"tag\"],\"name\":\"TaggedWith\"}@Searchable.`/*/tag`={\"addToFilters\":true,\"boostScore\":0.5,\"fieldName\":\"tags\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Tagged With\",\"hasValuesFieldName\":\"hasTags\",\"queryByDefault\":true,\"searchTier\":2}tags:array[/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}", SchemaFormatType.PDL);
    private TagAssociationArray _tagsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Tags = SCHEMA.getField("tags");

    public GlobalTags() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public GlobalTags(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTags() {
        if (this._tagsField != null) {
            return true;
        }
        return this._map.containsKey("tags");
    }

    public void removeTags() {
        this._map.remove("tags");
    }

    @Nullable
    public TagAssociationArray getTags(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTags();
            }
            case DEFAULT: 
            case NULL: {
                if (this._tagsField != null) {
                    return this._tagsField;
                }
                Object __rawValue = this._map.get("tags");
                this._tagsField = __rawValue == null ? null : new TagAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._tagsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public TagAssociationArray getTags() {
        if (this._tagsField != null) {
            return this._tagsField;
        }
        Object __rawValue = this._map.get("tags");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("tags");
        }
        this._tagsField = __rawValue == null ? null : new TagAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._tagsField;
    }

    public GlobalTags setTags(@Nullable TagAssociationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTags(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field tags of com.linkedin.common.GlobalTags");
                }
                CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
                this._tagsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTags();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
                this._tagsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
                this._tagsField = value;
            }
        }
        return this;
    }

    public GlobalTags setTags(@Nonnull TagAssociationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field tags of com.linkedin.common.GlobalTags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
        this._tagsField = value;
        return this;
    }

    @Override
    public GlobalTags clone() throws CloneNotSupportedException {
        GlobalTags __clone = (GlobalTags)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public GlobalTags copy() throws CloneNotSupportedException {
        GlobalTags __copy = (GlobalTags)super.copy();
        __copy._tagsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final GlobalTags __objectRef;

        private ChangeListener(GlobalTags reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "tags": {
                    this.__objectRef._tagsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public TagAssociationArray.Fields tags() {
            return new TagAssociationArray.Fields(this.getPathComponents(), "tags");
        }

        public PathSpec tags(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "tags");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TagAssociationArray.ProjectionMask _tagsMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withTags(Function<TagAssociationArray.ProjectionMask, TagAssociationArray.ProjectionMask> nestedMask) {
            this._tagsMask = nestedMask.apply(this._tagsMask == null ? TagAssociationArray.createMask() : this._tagsMask);
            this.getDataMap().put("tags", this._tagsMask.getDataMap());
            return this;
        }

        public ProjectionMask withTags() {
            this._tagsMask = null;
            this.getDataMap().put("tags", 1);
            return this;
        }

        public ProjectionMask withTags(Function<TagAssociationArray.ProjectionMask, TagAssociationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._tagsMask = nestedMask.apply(this._tagsMask == null ? TagAssociationArray.createMask() : this._tagsMask);
            this.getDataMap().put("tags", this._tagsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("tags").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("tags").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTags(Integer start, Integer count) {
            this._tagsMask = null;
            this.getDataMap().put("tags", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("tags").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("tags").put("$count", count);
            }
            return this;
        }
    }
}

