/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.FormVerificationAssociation;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class FormVerificationAssociationArray
extends WrappingArrayTemplate<FormVerificationAssociation> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.common/**An association between a verification and an entity that has been granted\nvia completion of one or more forms of type 'VERIFICATION'.*/record FormVerificationAssociation{/**The urn of the form that granted this verification.*/form:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**An audit stamp capturing who and when verification was applied for this form.*/lastModified:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}]", SchemaFormatType.PDL);

    public FormVerificationAssociationArray() {
        this(new DataList());
    }

    public FormVerificationAssociationArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public FormVerificationAssociationArray(Collection<FormVerificationAssociation> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public FormVerificationAssociationArray(DataList data) {
        super(data, SCHEMA, FormVerificationAssociation.class);
    }

    public FormVerificationAssociationArray(FormVerificationAssociation first, FormVerificationAssociation ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public FormVerificationAssociationArray clone() throws CloneNotSupportedException {
        FormVerificationAssociationArray __clone = (FormVerificationAssociationArray)super.clone();
        return __clone;
    }

    @Override
    public FormVerificationAssociationArray copy() throws CloneNotSupportedException {
        FormVerificationAssociationArray __copy = (FormVerificationAssociationArray)super.copy();
        return __copy;
    }

    @Override
    protected FormVerificationAssociation coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new FormVerificationAssociation(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private FormVerificationAssociation.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<FormVerificationAssociation.ProjectionMask, FormVerificationAssociation.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? FormVerificationAssociation.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public FormVerificationAssociation.Fields items() {
            return new FormVerificationAssociation.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

