/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityRelationship
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Downstream lineage information about a dataset including the source reporting the lineage*/record EntityRelationship{/**Audit stamp containing who reported the lineage and when*/created:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**The downstream dataset the lineage points to*/entity:Urn/**The type of the relationship*/type:string}", SchemaFormatType.PDL);
    private AuditStamp _createdField = null;
    private Urn _entityField = null;
    private String _typeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");

    public EntityRelationship() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public EntityRelationship(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public EntityRelationship setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public EntityRelationship setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.common.EntityRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public EntityRelationship setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.common.EntityRelationship");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public EntityRelationship setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.common.EntityRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public String getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._typeField;
    }

    public EntityRelationship setType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.common.EntityRelationship");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
            }
        }
        return this;
    }

    public EntityRelationship setType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.common.EntityRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value);
        this._typeField = value;
        return this;
    }

    @Override
    public EntityRelationship clone() throws CloneNotSupportedException {
        EntityRelationship __clone = (EntityRelationship)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EntityRelationship copy() throws CloneNotSupportedException {
        EntityRelationship __copy = (EntityRelationship)super.copy();
        __copy._createdField = null;
        __copy._typeField = null;
        __copy._entityField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EntityRelationship __objectRef;

        private ChangeListener(EntityRelationship reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createdMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }
    }
}

