/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.DocumentationAssociationArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Documentation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Aspect used for storing all applicable documentations on assets.\nThis aspect supports multiple documentations from different sources.\nThere is an implicit assumption that there is only one documentation per\n   source.\nFor example, if there are two documentations from the same source, the\n   latest one will overwrite the previous one.\nIf there are two documentations from different sources, both will be\n   stored.\nFuture evolution considerations:\nThe first entity that uses this aspect is Schema Field. We will expand this\n    aspect to other entities eventually.\nThe values of the documentation are not currently searchable. This will be\n    changed once this aspect develops opinion on which documentation entry is\n    the authoritative one.\nEnsuring that there is only one documentation per source is a business\n    rule that is not enforced by the aspect yet. This will currently be enforced by the\n    application that uses this aspect. We will eventually enforce this rule in\n    the aspect using AspectMutators.*/@Aspect.name=\"documentation\"record Documentation{/**Documentations associated with this asset. We could be receiving docs from different sources*/documentations:array[/**Properties of applied documentation including the attribution of the doc*/record DocumentationAssociation{/**Description of this asset*/documentation:string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"documentationAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"documentationAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"documentationAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}]}", SchemaFormatType.PDL);
    private DocumentationAssociationArray _documentationsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Documentations = SCHEMA.getField("documentations");

    public Documentation() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public Documentation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDocumentations() {
        if (this._documentationsField != null) {
            return true;
        }
        return this._map.containsKey("documentations");
    }

    public void removeDocumentations() {
        this._map.remove("documentations");
    }

    @Nullable
    public DocumentationAssociationArray getDocumentations(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDocumentations();
            }
            case DEFAULT: 
            case NULL: {
                if (this._documentationsField != null) {
                    return this._documentationsField;
                }
                Object __rawValue = this._map.get("documentations");
                this._documentationsField = __rawValue == null ? null : new DocumentationAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._documentationsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DocumentationAssociationArray getDocumentations() {
        if (this._documentationsField != null) {
            return this._documentationsField;
        }
        Object __rawValue = this._map.get("documentations");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("documentations");
        }
        this._documentationsField = __rawValue == null ? null : new DocumentationAssociationArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._documentationsField;
    }

    public Documentation setDocumentations(@Nullable DocumentationAssociationArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDocumentations(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field documentations of com.linkedin.common.Documentation");
                }
                CheckedUtil.putWithoutChecking(this._map, "documentations", value.data());
                this._documentationsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDocumentations();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "documentations", value.data());
                this._documentationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "documentations", value.data());
                this._documentationsField = value;
            }
        }
        return this;
    }

    public Documentation setDocumentations(@Nonnull DocumentationAssociationArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field documentations of com.linkedin.common.Documentation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "documentations", value.data());
        this._documentationsField = value;
        return this;
    }

    @Override
    public Documentation clone() throws CloneNotSupportedException {
        Documentation __clone = (Documentation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Documentation copy() throws CloneNotSupportedException {
        Documentation __copy = (Documentation)super.copy();
        __copy._documentationsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Documentation __objectRef;

        private ChangeListener(Documentation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "documentations": {
                    this.__objectRef._documentationsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DocumentationAssociationArray.Fields documentations() {
            return new DocumentationAssociationArray.Fields(this.getPathComponents(), "documentations");
        }

        public PathSpec documentations(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "documentations");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DocumentationAssociationArray.ProjectionMask _documentationsMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withDocumentations(Function<DocumentationAssociationArray.ProjectionMask, DocumentationAssociationArray.ProjectionMask> nestedMask) {
            this._documentationsMask = nestedMask.apply(this._documentationsMask == null ? DocumentationAssociationArray.createMask() : this._documentationsMask);
            this.getDataMap().put("documentations", this._documentationsMask.getDataMap());
            return this;
        }

        public ProjectionMask withDocumentations() {
            this._documentationsMask = null;
            this.getDataMap().put("documentations", 1);
            return this;
        }

        public ProjectionMask withDocumentations(Function<DocumentationAssociationArray.ProjectionMask, DocumentationAssociationArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._documentationsMask = nestedMask.apply(this._documentationsMask == null ? DocumentationAssociationArray.createMask() : this._documentationsMask);
            this.getDataMap().put("documentations", this._documentationsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("documentations").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("documentations").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDocumentations(Integer start, Integer count) {
            this._documentationsMask = null;
            this.getDataMap().put("documentations", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("documentations").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("documentations").put("$count", count);
            }
            return this;
        }
    }
}

