/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.IncrementingSegmentRowCountChange;
import com.linkedin.assertion.IncrementingSegmentRowCountTotal;
import com.linkedin.assertion.RowCountChange;
import com.linkedin.assertion.RowCountTotal;
import com.linkedin.assertion.VolumeAssertionType;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.DatasetFilter;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VolumeAssertionInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes defining a dataset Volume Assertion*/record VolumeAssertionInfo{/**The type of the volume assertion being monitored.*/@Searchable={}type:enum VolumeAssertionType{/**A volume assertion that is evaluated against the total row count of a dataset.*/ROW_COUNT_TOTAL/**A volume assertion that is evaluated against an incremental row count of a dataset,\nor a row count change.*/ROW_COUNT_CHANGE/**A volume assertion that checks the latest \"segment\" in a table based on an incrementing\ncolumn to check whether it's row count falls into a particular range.\n\nThis can be used to monitor the row count of an incrementing date-partition column segment.*/INCREMENTING_SEGMENT_ROW_COUNT_TOTAL/**A volume assertion that compares the row counts in neighboring \"segments\" or \"partitions\"\nof an incrementing column.\nThis can be used to track changes between subsequent date partition\nin a table, for example.*/INCREMENTING_SEGMENT_ROW_COUNT_CHANGE}/**The entity targeted by this Volume check.*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"Asserts\"}@Searchable.fieldType=\"URN\"entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Produce FAILURE Assertion Result if the row count of the asset does not meet specific requirements.\nRequired if type is 'ROW_COUNT_TOTAL'*/rowCountTotal:optional/**Attributes defining a ROW_COUNT_TOTAL volume assertion.*/record RowCountTotal{/**The operator you'd like to apply.\n\nNote that only numeric operators are valid inputs:\nGREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,\nBETWEEN.*/operator:/**A boolean operator that is applied on the input to an assertion, after an aggregation function has been applied.*/enum AssertionStdOperator{/**Value being asserted is between min_value and max_value.  Requires 'minValue' & 'maxValue' parameters.*/BETWEEN/**Value being asserted is less than a max value. Requires 'value' parameter.*/LESS_THAN/**Value being asserted is less than or equal to some value. Requires 'value' parameter.*/LESS_THAN_OR_EQUAL_TO/**Value being asserted is greater than some value. Requires 'value' parameter.*/GREATER_THAN/**Value being asserted is greater than or equal to some value. Requires 'value' parameter.*/GREATER_THAN_OR_EQUAL_TO/**Value being asserted is equal to value. Requires 'value' parameter.*/EQUAL_TO/**Value being asserted is not equal to value. Requires 'value' parameter.*/NOT_EQUAL_TO/**Value being asserted is null. Requires no parameters.*/NULL/**Value being asserted is not null. Requires no parameters.*/NOT_NULL/**Value being asserted contains value. Requires 'value' parameter.*/CONTAIN/**Value being asserted ends with value. Requires 'value' parameter.*/END_WITH/**Value being asserted starts with value. Requires 'value' parameter.*/START_WITH/**Value being asserted matches the regex value. Requires 'value' parameter.*/REGEX_MATCH/**Value being asserted is one of the array values. Requires 'value' parameter.*/IN/**Value being asserted is not in one of the array values. Requires 'value' parameter.*/NOT_IN/**Value being asserted is true. Requires no parameters.*/IS_TRUE/**Value being asserted is false. Requires no parameters.*/IS_FALSE/**Other*/_NATIVE_}/**The parameters you'd like to provide as input to the operator.\n\nNote that only numeric parameter types are valid inputs: NUMBER.*/parameters:/**Parameters for AssertionStdOperators.*/record AssertionStdParameters{/**The value parameter of an assertion*/value:optional/**Single parameter for AssertionStdOperators.*/record AssertionStdParameter{/**The parameter value*/value:string/**The type of the parameter*/type:enum AssertionStdParameterType{/**A string value*/STRING/**A numeric value*/NUMBER/**A list of values. When used, value should be formatted as a serialized JSON array.*/LIST/**A set of values. When used, value should be formatted as a serialized JSON array.*/SET/**A value of unknown type*/UNKNOWN}}/**The maxValue parameter of an assertion*/maxValue:optional AssertionStdParameter/**The minValue parameter of an assertion*/minValue:optional AssertionStdParameter}}/**Produce FAILURE Assertion Result if the delta row count of the asset does not meet specific requirements\nwithin a given period of time.\nRequired if type is 'ROW_COUNT_CHANGE'*/rowCountChange:optional/**Attributes defining a ROW_COUNT_CHANGE volume assertion.*/record RowCountChange{/**The type of the value used to evaluate the assertion: a fixed absolute value or a relative percentage.*/type:/**An enum to represent a type of change in an assertion value, metric, or measurement.*/enum AssertionValueChangeType{/**A change that is defined in absolute terms.*/ABSOLUTE/**A change that is defined in relative terms using percentage change\nfrom the original value.*/PERCENTAGE}/**The operator you'd like to apply.\n\nNote that only numeric operators are valid inputs:\nGREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,\nBETWEEN.*/operator:AssertionStdOperator/**The parameters you'd like to provide as input to the operator.\n\nNote that only numeric parameter types are valid inputs: NUMBER.*/parameters:AssertionStdParameters}/**Produce FAILURE Assertion Result if the asset's latest incrementing segment row count total\ndoes not meet specific requirements. Required if type is 'INCREMENTING_SEGMENT_ROW_COUNT_TOTAL'*/incrementingSegmentRowCountTotal:optional/**Attributes defining an INCREMENTING_SEGMENT_ROW_COUNT_TOTAL volume assertion.*/record IncrementingSegmentRowCountTotal{/**A specification of how the 'segment' can be derived using a column and an optional transformer function.*/segment:/**Core attributes required to identify an incrementing segment in a table. This type is mainly useful\nfor tables that constantly increase with new rows being added on a particular cadence (e.g. fact or event tables)\n\nAn incrementing segment represents a logical chunk of data which is INSERTED\ninto a dataset on a regular interval, along with the presence of a constantly-incrementing column\nvalue such as an event time, date partition, or last modified column.\n\nAn incrementing segment is principally identified by 2 key attributes combined:\n\n 1. A field or column that represents the incrementing value. New rows that are inserted will be identified using this column.\n    Note that the value of this column may not by itself represent the \"bucket\" or the \"segment\" in which the row falls.\n\n 2. [Optional] An transformer function that may be applied to the selected column value in order\n    to obtain the final \"segment identifier\" or \"bucket identifier\". Rows that have the same value after applying the transformation\n    will be grouped into the same segment, using which the final value (e.g. row count) will be determined.*/record IncrementingSegmentSpec{/**The field to use to generate segments. It must be constantly incrementing as new rows are inserted.*/field:{namespace com.linkedin.schema/**Lightweight spec used for referencing a particular schema field.\n*/record SchemaFieldSpec{/**The field path*/path:string/**The DataHub standard schema field type.*/type:string/**The native field type*/nativeType:string}}/**Optional transformer function to apply to the field in order to obtain the final segment or bucket identifier.\nIf not provided, then no operator will be applied to the field. (identity function)*/transformer:optional/**The definition of the transformer function  that should be applied to a given field / column value in a dataset\nin order to determine the segment or bucket that it belongs to, which in turn is used to evaluate\nvolume assertions.*/record IncrementingSegmentFieldTransformer{/**A 'standard' transformer type. Note that not all source systems will support all operators.*/type:enum IncrementingSegmentFieldTransformerType{/**Rounds a timestamp (in seconds) down to the start of the month.*/TIMESTAMP_MS_TO_MINUTE/**Rounds a timestamp (in milliseconds) down to the nearest hour.*/TIMESTAMP_MS_TO_HOUR/**Rounds a timestamp (in milliseconds) down to the start of the day.*/TIMESTAMP_MS_TO_DATE/**Rounds a timestamp (in milliseconds) down to the start of the month*/TIMESTAMP_MS_TO_MONTH/**Rounds a timestamp (in milliseconds) down to the start of the year*/TIMESTAMP_MS_TO_YEAR/**Rounds a numeric value down to the nearest integer.*/FLOOR/**Rounds a numeric value up to the nearest integer.*/CEILING/**A backdoor to provide a native operator type specific to a given source system like\nSnowflake, Redshift, BQ, etc.*/NATIVE}/**The 'native' transformer type, useful as a back door if a custom operator is required.\nThis field is required if the type is NATIVE.*/nativeType:optional string}}/**The operator you'd like to apply.\n\nNote that only numeric operators are valid inputs:\nGREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,\nBETWEEN.*/operator:AssertionStdOperator/**The parameters you'd like to provide as input to the operator.\n\nNote that only numeric parameter types are valid inputs: NUMBER.*/parameters:AssertionStdParameters}/**Produce FAILURE Assertion Result if the asset's incrementing segment row count delta\ndoes not meet specific requirements. Required if type is 'INCREMENTING_SEGMENT_ROW_COUNT_CHANGE'*/incrementingSegmentRowCountChange:optional/**Attributes defining an INCREMENTING_SEGMENT_ROW_COUNT_CHANGE volume assertion.*/record IncrementingSegmentRowCountChange{/**A specification of how the 'segment' can be derived using a column and an optional transformer function.*/segment:IncrementingSegmentSpec/**The type of the value used to evaluate the assertion: a fixed absolute value or a relative percentage.*/type:AssertionValueChangeType/**The operator you'd like to apply to the row count value\n\nNote that only numeric operators are valid inputs:\nGREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,\nBETWEEN.*/operator:AssertionStdOperator/**The parameters you'd like to provide as input to the operator.\n\nNote that only numeric parameter types are valid inputs: NUMBER.*/parameters:AssertionStdParameters}/**A definition of the specific filters that should be applied, when performing monitoring.\nIf not provided, there is no filter, and the full table is under consideration.*/filter:optional{namespace com.linkedin.dataset/**A definition of filters that should be used when\nquerying an external Dataset or Table.\n\nNote that this models should NOT be used for working with\nsearch / filter on DataHub Platform itself.*/record DatasetFilter{/**How the partition will be represented in this model.\n\nIn the future, we'll likely add support for more structured\npredicates.*/type:enum DatasetFilterType{/**The partition is represented as a an opaque, raw SQL\nclause.*/SQL}/**The raw where clause string which will be used for monitoring.\nRequired if the type is SQL.*/sql:optional string}}}", SchemaFormatType.PDL);
    private VolumeAssertionType _typeField = null;
    private Urn _entityField = null;
    private RowCountTotal _rowCountTotalField = null;
    private RowCountChange _rowCountChangeField = null;
    private IncrementingSegmentRowCountTotal _incrementingSegmentRowCountTotalField = null;
    private IncrementingSegmentRowCountChange _incrementingSegmentRowCountChangeField = null;
    private DatasetFilter _filterField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_RowCountTotal = SCHEMA.getField("rowCountTotal");
    private static final RecordDataSchema.Field FIELD_RowCountChange = SCHEMA.getField("rowCountChange");
    private static final RecordDataSchema.Field FIELD_IncrementingSegmentRowCountTotal = SCHEMA.getField("incrementingSegmentRowCountTotal");
    private static final RecordDataSchema.Field FIELD_IncrementingSegmentRowCountChange = SCHEMA.getField("incrementingSegmentRowCountChange");
    private static final RecordDataSchema.Field FIELD_Filter = SCHEMA.getField("filter");

    public VolumeAssertionInfo() {
        super(new DataMap(10, 0.75f), SCHEMA, 7);
        this.addChangeListener(this.__changeListener);
    }

    public VolumeAssertionInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public VolumeAssertionType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, VolumeAssertionType.class, VolumeAssertionType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public VolumeAssertionType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, VolumeAssertionType.class, VolumeAssertionType.$UNKNOWN);
        return this._typeField;
    }

    public VolumeAssertionInfo setType(@Nullable VolumeAssertionType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.assertion.VolumeAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public VolumeAssertionInfo setType(@Nonnull VolumeAssertionType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.assertion.VolumeAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public VolumeAssertionInfo setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.assertion.VolumeAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public VolumeAssertionInfo setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.assertion.VolumeAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasRowCountTotal() {
        if (this._rowCountTotalField != null) {
            return true;
        }
        return this._map.containsKey("rowCountTotal");
    }

    public void removeRowCountTotal() {
        this._map.remove("rowCountTotal");
    }

    @Nullable
    public RowCountTotal getRowCountTotal(GetMode mode) {
        return this.getRowCountTotal();
    }

    @Nullable
    public RowCountTotal getRowCountTotal() {
        if (this._rowCountTotalField != null) {
            return this._rowCountTotalField;
        }
        Object __rawValue = this._map.get("rowCountTotal");
        this._rowCountTotalField = __rawValue == null ? null : new RowCountTotal(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._rowCountTotalField;
    }

    public VolumeAssertionInfo setRowCountTotal(@Nullable RowCountTotal value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRowCountTotal(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRowCountTotal();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "rowCountTotal", value.data());
                this._rowCountTotalField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "rowCountTotal", value.data());
                this._rowCountTotalField = value;
            }
        }
        return this;
    }

    public VolumeAssertionInfo setRowCountTotal(@Nonnull RowCountTotal value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field rowCountTotal of com.linkedin.assertion.VolumeAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "rowCountTotal", value.data());
        this._rowCountTotalField = value;
        return this;
    }

    public boolean hasRowCountChange() {
        if (this._rowCountChangeField != null) {
            return true;
        }
        return this._map.containsKey("rowCountChange");
    }

    public void removeRowCountChange() {
        this._map.remove("rowCountChange");
    }

    @Nullable
    public RowCountChange getRowCountChange(GetMode mode) {
        return this.getRowCountChange();
    }

    @Nullable
    public RowCountChange getRowCountChange() {
        if (this._rowCountChangeField != null) {
            return this._rowCountChangeField;
        }
        Object __rawValue = this._map.get("rowCountChange");
        this._rowCountChangeField = __rawValue == null ? null : new RowCountChange(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._rowCountChangeField;
    }

    public VolumeAssertionInfo setRowCountChange(@Nullable RowCountChange value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRowCountChange(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRowCountChange();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "rowCountChange", value.data());
                this._rowCountChangeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "rowCountChange", value.data());
                this._rowCountChangeField = value;
            }
        }
        return this;
    }

    public VolumeAssertionInfo setRowCountChange(@Nonnull RowCountChange value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field rowCountChange of com.linkedin.assertion.VolumeAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "rowCountChange", value.data());
        this._rowCountChangeField = value;
        return this;
    }

    public boolean hasIncrementingSegmentRowCountTotal() {
        if (this._incrementingSegmentRowCountTotalField != null) {
            return true;
        }
        return this._map.containsKey("incrementingSegmentRowCountTotal");
    }

    public void removeIncrementingSegmentRowCountTotal() {
        this._map.remove("incrementingSegmentRowCountTotal");
    }

    @Nullable
    public IncrementingSegmentRowCountTotal getIncrementingSegmentRowCountTotal(GetMode mode) {
        return this.getIncrementingSegmentRowCountTotal();
    }

    @Nullable
    public IncrementingSegmentRowCountTotal getIncrementingSegmentRowCountTotal() {
        if (this._incrementingSegmentRowCountTotalField != null) {
            return this._incrementingSegmentRowCountTotalField;
        }
        Object __rawValue = this._map.get("incrementingSegmentRowCountTotal");
        this._incrementingSegmentRowCountTotalField = __rawValue == null ? null : new IncrementingSegmentRowCountTotal(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._incrementingSegmentRowCountTotalField;
    }

    public VolumeAssertionInfo setIncrementingSegmentRowCountTotal(@Nullable IncrementingSegmentRowCountTotal value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIncrementingSegmentRowCountTotal(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIncrementingSegmentRowCountTotal();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "incrementingSegmentRowCountTotal", value.data());
                this._incrementingSegmentRowCountTotalField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "incrementingSegmentRowCountTotal", value.data());
                this._incrementingSegmentRowCountTotalField = value;
            }
        }
        return this;
    }

    public VolumeAssertionInfo setIncrementingSegmentRowCountTotal(@Nonnull IncrementingSegmentRowCountTotal value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field incrementingSegmentRowCountTotal of com.linkedin.assertion.VolumeAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "incrementingSegmentRowCountTotal", value.data());
        this._incrementingSegmentRowCountTotalField = value;
        return this;
    }

    public boolean hasIncrementingSegmentRowCountChange() {
        if (this._incrementingSegmentRowCountChangeField != null) {
            return true;
        }
        return this._map.containsKey("incrementingSegmentRowCountChange");
    }

    public void removeIncrementingSegmentRowCountChange() {
        this._map.remove("incrementingSegmentRowCountChange");
    }

    @Nullable
    public IncrementingSegmentRowCountChange getIncrementingSegmentRowCountChange(GetMode mode) {
        return this.getIncrementingSegmentRowCountChange();
    }

    @Nullable
    public IncrementingSegmentRowCountChange getIncrementingSegmentRowCountChange() {
        if (this._incrementingSegmentRowCountChangeField != null) {
            return this._incrementingSegmentRowCountChangeField;
        }
        Object __rawValue = this._map.get("incrementingSegmentRowCountChange");
        this._incrementingSegmentRowCountChangeField = __rawValue == null ? null : new IncrementingSegmentRowCountChange(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._incrementingSegmentRowCountChangeField;
    }

    public VolumeAssertionInfo setIncrementingSegmentRowCountChange(@Nullable IncrementingSegmentRowCountChange value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIncrementingSegmentRowCountChange(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIncrementingSegmentRowCountChange();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "incrementingSegmentRowCountChange", value.data());
                this._incrementingSegmentRowCountChangeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "incrementingSegmentRowCountChange", value.data());
                this._incrementingSegmentRowCountChangeField = value;
            }
        }
        return this;
    }

    public VolumeAssertionInfo setIncrementingSegmentRowCountChange(@Nonnull IncrementingSegmentRowCountChange value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field incrementingSegmentRowCountChange of com.linkedin.assertion.VolumeAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "incrementingSegmentRowCountChange", value.data());
        this._incrementingSegmentRowCountChangeField = value;
        return this;
    }

    public boolean hasFilter() {
        if (this._filterField != null) {
            return true;
        }
        return this._map.containsKey("filter");
    }

    public void removeFilter() {
        this._map.remove("filter");
    }

    @Nullable
    public DatasetFilter getFilter(GetMode mode) {
        return this.getFilter();
    }

    @Nullable
    public DatasetFilter getFilter() {
        if (this._filterField != null) {
            return this._filterField;
        }
        Object __rawValue = this._map.get("filter");
        this._filterField = __rawValue == null ? null : new DatasetFilter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._filterField;
    }

    public VolumeAssertionInfo setFilter(@Nullable DatasetFilter value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFilter(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFilter();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
                this._filterField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
                this._filterField = value;
            }
        }
        return this;
    }

    public VolumeAssertionInfo setFilter(@Nonnull DatasetFilter value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field filter of com.linkedin.assertion.VolumeAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
        this._filterField = value;
        return this;
    }

    @Override
    public VolumeAssertionInfo clone() throws CloneNotSupportedException {
        VolumeAssertionInfo __clone = (VolumeAssertionInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public VolumeAssertionInfo copy() throws CloneNotSupportedException {
        VolumeAssertionInfo __copy = (VolumeAssertionInfo)super.copy();
        __copy._filterField = null;
        __copy._incrementingSegmentRowCountTotalField = null;
        __copy._rowCountChangeField = null;
        __copy._typeField = null;
        __copy._entityField = null;
        __copy._rowCountTotalField = null;
        __copy._incrementingSegmentRowCountChangeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final VolumeAssertionInfo __objectRef;

        private ChangeListener(VolumeAssertionInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "filter": {
                    this.__objectRef._filterField = null;
                    break;
                }
                case "incrementingSegmentRowCountTotal": {
                    this.__objectRef._incrementingSegmentRowCountTotalField = null;
                    break;
                }
                case "rowCountChange": {
                    this.__objectRef._rowCountChangeField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                    break;
                }
                case "rowCountTotal": {
                    this.__objectRef._rowCountTotalField = null;
                    break;
                }
                case "incrementingSegmentRowCountChange": {
                    this.__objectRef._incrementingSegmentRowCountChangeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public RowCountTotal.Fields rowCountTotal() {
            return new RowCountTotal.Fields(this.getPathComponents(), "rowCountTotal");
        }

        public RowCountChange.Fields rowCountChange() {
            return new RowCountChange.Fields(this.getPathComponents(), "rowCountChange");
        }

        public IncrementingSegmentRowCountTotal.Fields incrementingSegmentRowCountTotal() {
            return new IncrementingSegmentRowCountTotal.Fields(this.getPathComponents(), "incrementingSegmentRowCountTotal");
        }

        public IncrementingSegmentRowCountChange.Fields incrementingSegmentRowCountChange() {
            return new IncrementingSegmentRowCountChange.Fields(this.getPathComponents(), "incrementingSegmentRowCountChange");
        }

        public DatasetFilter.Fields filter() {
            return new DatasetFilter.Fields(this.getPathComponents(), "filter");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private RowCountTotal.ProjectionMask _rowCountTotalMask;
        private RowCountChange.ProjectionMask _rowCountChangeMask;
        private IncrementingSegmentRowCountTotal.ProjectionMask _incrementingSegmentRowCountTotalMask;
        private IncrementingSegmentRowCountChange.ProjectionMask _incrementingSegmentRowCountChangeMask;
        private DatasetFilter.ProjectionMask _filterMask;

        ProjectionMask() {
            super(10);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withRowCountTotal(Function<RowCountTotal.ProjectionMask, RowCountTotal.ProjectionMask> nestedMask) {
            this._rowCountTotalMask = nestedMask.apply(this._rowCountTotalMask == null ? RowCountTotal.createMask() : this._rowCountTotalMask);
            this.getDataMap().put("rowCountTotal", this._rowCountTotalMask.getDataMap());
            return this;
        }

        public ProjectionMask withRowCountTotal() {
            this._rowCountTotalMask = null;
            this.getDataMap().put("rowCountTotal", 1);
            return this;
        }

        public ProjectionMask withRowCountChange(Function<RowCountChange.ProjectionMask, RowCountChange.ProjectionMask> nestedMask) {
            this._rowCountChangeMask = nestedMask.apply(this._rowCountChangeMask == null ? RowCountChange.createMask() : this._rowCountChangeMask);
            this.getDataMap().put("rowCountChange", this._rowCountChangeMask.getDataMap());
            return this;
        }

        public ProjectionMask withRowCountChange() {
            this._rowCountChangeMask = null;
            this.getDataMap().put("rowCountChange", 1);
            return this;
        }

        public ProjectionMask withIncrementingSegmentRowCountTotal(Function<IncrementingSegmentRowCountTotal.ProjectionMask, IncrementingSegmentRowCountTotal.ProjectionMask> nestedMask) {
            this._incrementingSegmentRowCountTotalMask = nestedMask.apply(this._incrementingSegmentRowCountTotalMask == null ? IncrementingSegmentRowCountTotal.createMask() : this._incrementingSegmentRowCountTotalMask);
            this.getDataMap().put("incrementingSegmentRowCountTotal", this._incrementingSegmentRowCountTotalMask.getDataMap());
            return this;
        }

        public ProjectionMask withIncrementingSegmentRowCountTotal() {
            this._incrementingSegmentRowCountTotalMask = null;
            this.getDataMap().put("incrementingSegmentRowCountTotal", 1);
            return this;
        }

        public ProjectionMask withIncrementingSegmentRowCountChange(Function<IncrementingSegmentRowCountChange.ProjectionMask, IncrementingSegmentRowCountChange.ProjectionMask> nestedMask) {
            this._incrementingSegmentRowCountChangeMask = nestedMask.apply(this._incrementingSegmentRowCountChangeMask == null ? IncrementingSegmentRowCountChange.createMask() : this._incrementingSegmentRowCountChangeMask);
            this.getDataMap().put("incrementingSegmentRowCountChange", this._incrementingSegmentRowCountChangeMask.getDataMap());
            return this;
        }

        public ProjectionMask withIncrementingSegmentRowCountChange() {
            this._incrementingSegmentRowCountChangeMask = null;
            this.getDataMap().put("incrementingSegmentRowCountChange", 1);
            return this;
        }

        public ProjectionMask withFilter(Function<DatasetFilter.ProjectionMask, DatasetFilter.ProjectionMask> nestedMask) {
            this._filterMask = nestedMask.apply(this._filterMask == null ? DatasetFilter.createMask() : this._filterMask);
            this.getDataMap().put("filter", this._filterMask.getDataMap());
            return this;
        }

        public ProjectionMask withFilter() {
            this._filterMask = null;
            this.getDataMap().put("filter", 1);
            return this;
        }
    }
}

