/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomAssertionInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes that are applicable to Custom Assertions\n*/record CustomAssertionInfo{/**The type of custom assertion.\nThis is how your assertion will appear categorized in DataHub UI. */@Searchable.fieldName=\"customType\"type:string/**The entity targeted by this assertion.\nThis can have support more entityTypes (e.g. dataJob) in future*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"Asserts\"}entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**dataset schema field targeted by this assertion.\n\nThis field is expected to be provided if the assertion is on dataset field*/@Relationship={\"entityTypes\":[\"schemaField\"],\"name\":\"Asserts\"}field:optional com.linkedin.common.Urn,logic:optional string}", SchemaFormatType.PDL);
    private String _typeField = null;
    private Urn _entityField = null;
    private Urn _fieldField = null;
    private String _logicField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_Field = SCHEMA.getField("field");
    private static final RecordDataSchema.Field FIELD_Logic = SCHEMA.getField("logic");

    public CustomAssertionInfo() {
        super(new DataMap(6, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public CustomAssertionInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public String getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._typeField;
    }

    public CustomAssertionInfo setType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.assertion.CustomAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
            }
        }
        return this;
    }

    public CustomAssertionInfo setType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.assertion.CustomAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value);
        this._typeField = value;
        return this;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public CustomAssertionInfo setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.assertion.CustomAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public CustomAssertionInfo setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.assertion.CustomAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasField() {
        if (this._fieldField != null) {
            return true;
        }
        return this._map.containsKey("field");
    }

    public void removeField() {
        this._map.remove("field");
    }

    @Nullable
    public Urn getField(GetMode mode) {
        return this.getField();
    }

    @Nullable
    public Urn getField() {
        if (this._fieldField != null) {
            return this._fieldField;
        }
        Object __rawValue = this._map.get("field");
        this._fieldField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._fieldField;
    }

    public CustomAssertionInfo setField(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setField(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeField();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "field", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._fieldField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "field", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._fieldField = value;
            }
        }
        return this;
    }

    public CustomAssertionInfo setField(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field field of com.linkedin.assertion.CustomAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "field", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._fieldField = value;
        return this;
    }

    public boolean hasLogic() {
        if (this._logicField != null) {
            return true;
        }
        return this._map.containsKey("logic");
    }

    public void removeLogic() {
        this._map.remove("logic");
    }

    @Nullable
    public String getLogic(GetMode mode) {
        return this.getLogic();
    }

    @Nullable
    public String getLogic() {
        if (this._logicField != null) {
            return this._logicField;
        }
        Object __rawValue = this._map.get("logic");
        this._logicField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._logicField;
    }

    public CustomAssertionInfo setLogic(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLogic(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLogic();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "logic", value);
                this._logicField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "logic", value);
                this._logicField = value;
            }
        }
        return this;
    }

    public CustomAssertionInfo setLogic(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field logic of com.linkedin.assertion.CustomAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "logic", value);
        this._logicField = value;
        return this;
    }

    @Override
    public CustomAssertionInfo clone() throws CloneNotSupportedException {
        CustomAssertionInfo __clone = (CustomAssertionInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CustomAssertionInfo copy() throws CloneNotSupportedException {
        CustomAssertionInfo __copy = (CustomAssertionInfo)super.copy();
        __copy._fieldField = null;
        __copy._logicField = null;
        __copy._typeField = null;
        __copy._entityField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CustomAssertionInfo __objectRef;

        private ChangeListener(CustomAssertionInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "field": {
                    this.__objectRef._fieldField = null;
                    break;
                }
                case "logic": {
                    this.__objectRef._logicField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public PathSpec field() {
            return new PathSpec(this.getPathComponents(), "field");
        }

        public PathSpec logic() {
            return new PathSpec(this.getPathComponents(), "logic");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withField() {
            this.getDataMap().put("field", 1);
            return this;
        }

        public ProjectionMask withLogic() {
            this.getDataMap().put("logic", 1);
            return this;
        }
    }
}

