/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.settings.global;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OAuthProvider
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.settings.global/**An OAuth Provider. This provides information required to validate inbound\nrequests with OAuth 2.0 bearer tokens.*/record OAuthProvider{/**Whether this OAuth provider is enabled.*/enabled:boolean/**The name of this OAuth provider. This is used for display purposes only.*/name:string/**The URI of the JSON Web Key Set (JWKS) endpoint for this OAuth provider.*/jwksUri:optional string/**The expected issuer (iss) claim in the JWTs issued by this OAuth provider.*/issuer:string/**The expected audience (aud) claim in the JWTs issued by this OAuth provider.*/audience:string/**The JWT signing algorithm required for this provider.\nPrevents algorithm confusion attacks. Common values: RS256, RS384, RS512, PS256, ES256*/algorithm:string=\"RS256\"/**The JWT claim to use as the user identifier for this provider.\nDifferent providers use different claims (sub, email, preferred_username, etc.)*/userIdClaim:string=\"sub\"}", SchemaFormatType.PDL);
    private Boolean _enabledField = null;
    private String _nameField = null;
    private String _jwksUriField = null;
    private String _issuerField = null;
    private String _audienceField = null;
    private String _algorithmField = null;
    private String _userIdClaimField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Enabled = SCHEMA.getField("enabled");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_JwksUri = SCHEMA.getField("jwksUri");
    private static final RecordDataSchema.Field FIELD_Issuer = SCHEMA.getField("issuer");
    private static final RecordDataSchema.Field FIELD_Audience = SCHEMA.getField("audience");
    private static final RecordDataSchema.Field FIELD_Algorithm = SCHEMA.getField("algorithm");
    private static final String DEFAULT_Algorithm;
    private static final RecordDataSchema.Field FIELD_UserIdClaim;
    private static final String DEFAULT_UserIdClaim;

    public OAuthProvider() {
        super(new DataMap(10, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public OAuthProvider(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEnabled() {
        if (this._enabledField != null) {
            return true;
        }
        return this._map.containsKey("enabled");
    }

    public void removeEnabled() {
        this._map.remove("enabled");
    }

    @Nullable
    public Boolean isEnabled(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isEnabled();
            }
            case DEFAULT: 
            case NULL: {
                if (this._enabledField != null) {
                    return this._enabledField;
                }
                Object __rawValue = this._map.get("enabled");
                this._enabledField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._enabledField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isEnabled() {
        if (this._enabledField != null) {
            return this._enabledField;
        }
        Object __rawValue = this._map.get("enabled");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("enabled");
        }
        this._enabledField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._enabledField;
    }

    public OAuthProvider setEnabled(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEnabled(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field enabled of com.linkedin.settings.global.OAuthProvider");
                }
                CheckedUtil.putWithoutChecking(this._map, "enabled", value);
                this._enabledField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEnabled();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "enabled", value);
                this._enabledField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "enabled", value);
                this._enabledField = value;
            }
        }
        return this;
    }

    public OAuthProvider setEnabled(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field enabled of com.linkedin.settings.global.OAuthProvider to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "enabled", value);
        this._enabledField = value;
        return this;
    }

    public OAuthProvider setEnabled(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "enabled", value);
        this._enabledField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public OAuthProvider setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.settings.global.OAuthProvider");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public OAuthProvider setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.settings.global.OAuthProvider to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasJwksUri() {
        if (this._jwksUriField != null) {
            return true;
        }
        return this._map.containsKey("jwksUri");
    }

    public void removeJwksUri() {
        this._map.remove("jwksUri");
    }

    @Nullable
    public String getJwksUri(GetMode mode) {
        return this.getJwksUri();
    }

    @Nullable
    public String getJwksUri() {
        if (this._jwksUriField != null) {
            return this._jwksUriField;
        }
        Object __rawValue = this._map.get("jwksUri");
        this._jwksUriField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._jwksUriField;
    }

    public OAuthProvider setJwksUri(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setJwksUri(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeJwksUri();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "jwksUri", value);
                this._jwksUriField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "jwksUri", value);
                this._jwksUriField = value;
            }
        }
        return this;
    }

    public OAuthProvider setJwksUri(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field jwksUri of com.linkedin.settings.global.OAuthProvider to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "jwksUri", value);
        this._jwksUriField = value;
        return this;
    }

    public boolean hasIssuer() {
        if (this._issuerField != null) {
            return true;
        }
        return this._map.containsKey("issuer");
    }

    public void removeIssuer() {
        this._map.remove("issuer");
    }

    @Nullable
    public String getIssuer(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getIssuer();
            }
            case DEFAULT: 
            case NULL: {
                if (this._issuerField != null) {
                    return this._issuerField;
                }
                Object __rawValue = this._map.get("issuer");
                this._issuerField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._issuerField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getIssuer() {
        if (this._issuerField != null) {
            return this._issuerField;
        }
        Object __rawValue = this._map.get("issuer");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("issuer");
        }
        this._issuerField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._issuerField;
    }

    public OAuthProvider setIssuer(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIssuer(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field issuer of com.linkedin.settings.global.OAuthProvider");
                }
                CheckedUtil.putWithoutChecking(this._map, "issuer", value);
                this._issuerField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIssuer();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "issuer", value);
                this._issuerField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "issuer", value);
                this._issuerField = value;
            }
        }
        return this;
    }

    public OAuthProvider setIssuer(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field issuer of com.linkedin.settings.global.OAuthProvider to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "issuer", value);
        this._issuerField = value;
        return this;
    }

    public boolean hasAudience() {
        if (this._audienceField != null) {
            return true;
        }
        return this._map.containsKey("audience");
    }

    public void removeAudience() {
        this._map.remove("audience");
    }

    @Nullable
    public String getAudience(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAudience();
            }
            case DEFAULT: 
            case NULL: {
                if (this._audienceField != null) {
                    return this._audienceField;
                }
                Object __rawValue = this._map.get("audience");
                this._audienceField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._audienceField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getAudience() {
        if (this._audienceField != null) {
            return this._audienceField;
        }
        Object __rawValue = this._map.get("audience");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("audience");
        }
        this._audienceField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._audienceField;
    }

    public OAuthProvider setAudience(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAudience(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field audience of com.linkedin.settings.global.OAuthProvider");
                }
                CheckedUtil.putWithoutChecking(this._map, "audience", value);
                this._audienceField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAudience();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "audience", value);
                this._audienceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "audience", value);
                this._audienceField = value;
            }
        }
        return this;
    }

    public OAuthProvider setAudience(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field audience of com.linkedin.settings.global.OAuthProvider to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "audience", value);
        this._audienceField = value;
        return this;
    }

    public boolean hasAlgorithm() {
        if (this._algorithmField != null) {
            return true;
        }
        return this._map.containsKey("algorithm");
    }

    public void removeAlgorithm() {
        this._map.remove("algorithm");
    }

    @Nullable
    public String getAlgorithm(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getAlgorithm();
            }
            case NULL: {
                if (this._algorithmField != null) {
                    return this._algorithmField;
                }
                Object __rawValue = this._map.get("algorithm");
                this._algorithmField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._algorithmField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getAlgorithm() {
        if (this._algorithmField != null) {
            return this._algorithmField;
        }
        Object __rawValue = this._map.get("algorithm");
        if (__rawValue == null) {
            return DEFAULT_Algorithm;
        }
        this._algorithmField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._algorithmField;
    }

    public OAuthProvider setAlgorithm(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAlgorithm(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field algorithm of com.linkedin.settings.global.OAuthProvider");
                }
                CheckedUtil.putWithoutChecking(this._map, "algorithm", value);
                this._algorithmField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAlgorithm();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "algorithm", value);
                this._algorithmField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "algorithm", value);
                this._algorithmField = value;
            }
        }
        return this;
    }

    public OAuthProvider setAlgorithm(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field algorithm of com.linkedin.settings.global.OAuthProvider to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "algorithm", value);
        this._algorithmField = value;
        return this;
    }

    public boolean hasUserIdClaim() {
        if (this._userIdClaimField != null) {
            return true;
        }
        return this._map.containsKey("userIdClaim");
    }

    public void removeUserIdClaim() {
        this._map.remove("userIdClaim");
    }

    @Nullable
    public String getUserIdClaim(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getUserIdClaim();
            }
            case NULL: {
                if (this._userIdClaimField != null) {
                    return this._userIdClaimField;
                }
                Object __rawValue = this._map.get("userIdClaim");
                this._userIdClaimField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._userIdClaimField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getUserIdClaim() {
        if (this._userIdClaimField != null) {
            return this._userIdClaimField;
        }
        Object __rawValue = this._map.get("userIdClaim");
        if (__rawValue == null) {
            return DEFAULT_UserIdClaim;
        }
        this._userIdClaimField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._userIdClaimField;
    }

    public OAuthProvider setUserIdClaim(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUserIdClaim(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field userIdClaim of com.linkedin.settings.global.OAuthProvider");
                }
                CheckedUtil.putWithoutChecking(this._map, "userIdClaim", value);
                this._userIdClaimField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUserIdClaim();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "userIdClaim", value);
                this._userIdClaimField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "userIdClaim", value);
                this._userIdClaimField = value;
            }
        }
        return this;
    }

    public OAuthProvider setUserIdClaim(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field userIdClaim of com.linkedin.settings.global.OAuthProvider to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "userIdClaim", value);
        this._userIdClaimField = value;
        return this;
    }

    @Override
    public OAuthProvider clone() throws CloneNotSupportedException {
        OAuthProvider __clone = (OAuthProvider)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public OAuthProvider copy() throws CloneNotSupportedException {
        OAuthProvider __copy = (OAuthProvider)super.copy();
        __copy._userIdClaimField = null;
        __copy._audienceField = null;
        __copy._nameField = null;
        __copy._jwksUriField = null;
        __copy._enabledField = null;
        __copy._issuerField = null;
        __copy._algorithmField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_UserIdClaim = SCHEMA.getField("userIdClaim");
        DEFAULT_Algorithm = DataTemplateUtil.coerceStringOutput(FIELD_Algorithm.getDefault());
        DEFAULT_UserIdClaim = DataTemplateUtil.coerceStringOutput(FIELD_UserIdClaim.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final OAuthProvider __objectRef;

        private ChangeListener(OAuthProvider reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "userIdClaim": {
                    this.__objectRef._userIdClaimField = null;
                    break;
                }
                case "audience": {
                    this.__objectRef._audienceField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "jwksUri": {
                    this.__objectRef._jwksUriField = null;
                    break;
                }
                case "enabled": {
                    this.__objectRef._enabledField = null;
                    break;
                }
                case "issuer": {
                    this.__objectRef._issuerField = null;
                    break;
                }
                case "algorithm": {
                    this.__objectRef._algorithmField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec enabled() {
            return new PathSpec(this.getPathComponents(), "enabled");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec jwksUri() {
            return new PathSpec(this.getPathComponents(), "jwksUri");
        }

        public PathSpec issuer() {
            return new PathSpec(this.getPathComponents(), "issuer");
        }

        public PathSpec audience() {
            return new PathSpec(this.getPathComponents(), "audience");
        }

        public PathSpec algorithm() {
            return new PathSpec(this.getPathComponents(), "algorithm");
        }

        public PathSpec userIdClaim() {
            return new PathSpec(this.getPathComponents(), "userIdClaim");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(10);
        }

        public ProjectionMask withEnabled() {
            this.getDataMap().put("enabled", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withJwksUri() {
            this.getDataMap().put("jwksUri", 1);
            return this;
        }

        public ProjectionMask withIssuer() {
            this.getDataMap().put("issuer", 1);
            return this;
        }

        public ProjectionMask withAudience() {
            this.getDataMap().put("audience", 1);
            return this;
        }

        public ProjectionMask withAlgorithm() {
            this.getDataMap().put("algorithm", 1);
            return this;
        }

        public ProjectionMask withUserIdClaim() {
            this.getDataMap().put("userIdClaim", 1);
            return this;
        }
    }
}

