/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.settings.global;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocPropagationFeatureSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.settings.global,record DocPropagationFeatureSettings includes/**A standardized settings template for a feature.*/record FeatureSettings{enabled:boolean/**The configuration for the feature, in JSON format.*/config:optional string/**The version of the configuration schema that has been used to serialize\n       the config.\nIf not provided, the version is assumed to be the latest version.*/configVersion:optional string}{columnPropagationEnabled:boolean=true}", SchemaFormatType.PDL);
    private Boolean _enabledField = null;
    private String _configField = null;
    private String _configVersionField = null;
    private Boolean _columnPropagationEnabledField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Enabled = SCHEMA.getField("enabled");
    private static final RecordDataSchema.Field FIELD_Config = SCHEMA.getField("config");
    private static final RecordDataSchema.Field FIELD_ConfigVersion = SCHEMA.getField("configVersion");
    private static final RecordDataSchema.Field FIELD_ColumnPropagationEnabled = SCHEMA.getField("columnPropagationEnabled");
    private static final Boolean DEFAULT_ColumnPropagationEnabled = DataTemplateUtil.coerceBooleanOutput(FIELD_ColumnPropagationEnabled.getDefault());

    public DocPropagationFeatureSettings() {
        super(new DataMap(6, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DocPropagationFeatureSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEnabled() {
        if (this._enabledField != null) {
            return true;
        }
        return this._map.containsKey("enabled");
    }

    public void removeEnabled() {
        this._map.remove("enabled");
    }

    @Nullable
    public Boolean isEnabled(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.isEnabled();
            }
            case DEFAULT: 
            case NULL: {
                if (this._enabledField != null) {
                    return this._enabledField;
                }
                Object __rawValue = this._map.get("enabled");
                this._enabledField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._enabledField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isEnabled() {
        if (this._enabledField != null) {
            return this._enabledField;
        }
        Object __rawValue = this._map.get("enabled");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("enabled");
        }
        this._enabledField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._enabledField;
    }

    public DocPropagationFeatureSettings setEnabled(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEnabled(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field enabled of com.linkedin.settings.global.DocPropagationFeatureSettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "enabled", value);
                this._enabledField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEnabled();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "enabled", value);
                this._enabledField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "enabled", value);
                this._enabledField = value;
            }
        }
        return this;
    }

    public DocPropagationFeatureSettings setEnabled(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field enabled of com.linkedin.settings.global.DocPropagationFeatureSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "enabled", value);
        this._enabledField = value;
        return this;
    }

    public DocPropagationFeatureSettings setEnabled(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "enabled", value);
        this._enabledField = value;
        return this;
    }

    public boolean hasConfig() {
        if (this._configField != null) {
            return true;
        }
        return this._map.containsKey("config");
    }

    public void removeConfig() {
        this._map.remove("config");
    }

    @Nullable
    public String getConfig(GetMode mode) {
        return this.getConfig();
    }

    @Nullable
    public String getConfig() {
        if (this._configField != null) {
            return this._configField;
        }
        Object __rawValue = this._map.get("config");
        this._configField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._configField;
    }

    public DocPropagationFeatureSettings setConfig(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setConfig(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeConfig();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "config", value);
                this._configField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "config", value);
                this._configField = value;
            }
        }
        return this;
    }

    public DocPropagationFeatureSettings setConfig(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field config of com.linkedin.settings.global.DocPropagationFeatureSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "config", value);
        this._configField = value;
        return this;
    }

    public boolean hasConfigVersion() {
        if (this._configVersionField != null) {
            return true;
        }
        return this._map.containsKey("configVersion");
    }

    public void removeConfigVersion() {
        this._map.remove("configVersion");
    }

    @Nullable
    public String getConfigVersion(GetMode mode) {
        return this.getConfigVersion();
    }

    @Nullable
    public String getConfigVersion() {
        if (this._configVersionField != null) {
            return this._configVersionField;
        }
        Object __rawValue = this._map.get("configVersion");
        this._configVersionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._configVersionField;
    }

    public DocPropagationFeatureSettings setConfigVersion(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setConfigVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeConfigVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "configVersion", value);
                this._configVersionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "configVersion", value);
                this._configVersionField = value;
            }
        }
        return this;
    }

    public DocPropagationFeatureSettings setConfigVersion(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field configVersion of com.linkedin.settings.global.DocPropagationFeatureSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "configVersion", value);
        this._configVersionField = value;
        return this;
    }

    public boolean hasColumnPropagationEnabled() {
        if (this._columnPropagationEnabledField != null) {
            return true;
        }
        return this._map.containsKey("columnPropagationEnabled");
    }

    public void removeColumnPropagationEnabled() {
        this._map.remove("columnPropagationEnabled");
    }

    @Nullable
    public Boolean isColumnPropagationEnabled(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isColumnPropagationEnabled();
            }
            case NULL: {
                if (this._columnPropagationEnabledField != null) {
                    return this._columnPropagationEnabledField;
                }
                Object __rawValue = this._map.get("columnPropagationEnabled");
                this._columnPropagationEnabledField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._columnPropagationEnabledField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isColumnPropagationEnabled() {
        if (this._columnPropagationEnabledField != null) {
            return this._columnPropagationEnabledField;
        }
        Object __rawValue = this._map.get("columnPropagationEnabled");
        if (__rawValue == null) {
            return DEFAULT_ColumnPropagationEnabled;
        }
        this._columnPropagationEnabledField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._columnPropagationEnabledField;
    }

    public DocPropagationFeatureSettings setColumnPropagationEnabled(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setColumnPropagationEnabled(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field columnPropagationEnabled of com.linkedin.settings.global.DocPropagationFeatureSettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "columnPropagationEnabled", value);
                this._columnPropagationEnabledField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeColumnPropagationEnabled();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "columnPropagationEnabled", value);
                this._columnPropagationEnabledField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "columnPropagationEnabled", value);
                this._columnPropagationEnabledField = value;
            }
        }
        return this;
    }

    public DocPropagationFeatureSettings setColumnPropagationEnabled(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field columnPropagationEnabled of com.linkedin.settings.global.DocPropagationFeatureSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "columnPropagationEnabled", value);
        this._columnPropagationEnabledField = value;
        return this;
    }

    public DocPropagationFeatureSettings setColumnPropagationEnabled(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "columnPropagationEnabled", value);
        this._columnPropagationEnabledField = value;
        return this;
    }

    @Override
    public DocPropagationFeatureSettings clone() throws CloneNotSupportedException {
        DocPropagationFeatureSettings __clone = (DocPropagationFeatureSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DocPropagationFeatureSettings copy() throws CloneNotSupportedException {
        DocPropagationFeatureSettings __copy = (DocPropagationFeatureSettings)super.copy();
        __copy._configVersionField = null;
        __copy._columnPropagationEnabledField = null;
        __copy._configField = null;
        __copy._enabledField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DocPropagationFeatureSettings __objectRef;

        private ChangeListener(DocPropagationFeatureSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "configVersion": {
                    this.__objectRef._configVersionField = null;
                    break;
                }
                case "columnPropagationEnabled": {
                    this.__objectRef._columnPropagationEnabledField = null;
                    break;
                }
                case "config": {
                    this.__objectRef._configField = null;
                    break;
                }
                case "enabled": {
                    this.__objectRef._enabledField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec enabled() {
            return new PathSpec(this.getPathComponents(), "enabled");
        }

        public PathSpec config() {
            return new PathSpec(this.getPathComponents(), "config");
        }

        public PathSpec configVersion() {
            return new PathSpec(this.getPathComponents(), "configVersion");
        }

        public PathSpec columnPropagationEnabled() {
            return new PathSpec(this.getPathComponents(), "columnPropagationEnabled");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withEnabled() {
            this.getDataMap().put("enabled", 1);
            return this;
        }

        public ProjectionMask withConfig() {
            this.getDataMap().put("config", 1);
            return this;
        }

        public ProjectionMask withConfigVersion() {
            this.getDataMap().put("configVersion", 1);
            return this;
        }

        public ProjectionMask withColumnPropagationEnabled() {
            this.getDataMap().put("columnPropagationEnabled", 1);
            return this;
        }
    }
}

