/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.operations;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.IntegerMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OperationsAggregationsResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.operations/**Aggregation results for operations query*/record OperationsAggregationsResult{/** Total number of operations in the bucket */totalOperations:optional int/** Total number of inserts in the bucket */totalInserts:optional int/** Total number of updates in the bucket */totalUpdates:optional int/** Total number of deletes in the bucket */totalDeletes:optional int/** Total number of creates in the bucket */totalCreates:optional int/** Total number of alters in the bucket */totalAlters:optional int/** Total number of drops in the bucket */totalDrops:optional int/** Total number of custom types in the bucket */totalCustoms:optional int/** A map from each custom operation type to the total count for that type*/customOperationsMap:optional map[string,int]}", SchemaFormatType.PDL);
    private Integer _totalOperationsField = null;
    private Integer _totalInsertsField = null;
    private Integer _totalUpdatesField = null;
    private Integer _totalDeletesField = null;
    private Integer _totalCreatesField = null;
    private Integer _totalAltersField = null;
    private Integer _totalDropsField = null;
    private Integer _totalCustomsField = null;
    private IntegerMap _customOperationsMapField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TotalOperations = SCHEMA.getField("totalOperations");
    private static final RecordDataSchema.Field FIELD_TotalInserts = SCHEMA.getField("totalInserts");
    private static final RecordDataSchema.Field FIELD_TotalUpdates = SCHEMA.getField("totalUpdates");
    private static final RecordDataSchema.Field FIELD_TotalDeletes = SCHEMA.getField("totalDeletes");
    private static final RecordDataSchema.Field FIELD_TotalCreates = SCHEMA.getField("totalCreates");
    private static final RecordDataSchema.Field FIELD_TotalAlters = SCHEMA.getField("totalAlters");
    private static final RecordDataSchema.Field FIELD_TotalDrops = SCHEMA.getField("totalDrops");
    private static final RecordDataSchema.Field FIELD_TotalCustoms = SCHEMA.getField("totalCustoms");
    private static final RecordDataSchema.Field FIELD_CustomOperationsMap = SCHEMA.getField("customOperationsMap");

    public OperationsAggregationsResult() {
        super(new DataMap(12, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public OperationsAggregationsResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTotalOperations() {
        if (this._totalOperationsField != null) {
            return true;
        }
        return this._map.containsKey("totalOperations");
    }

    public void removeTotalOperations() {
        this._map.remove("totalOperations");
    }

    @Nullable
    public Integer getTotalOperations(GetMode mode) {
        return this.getTotalOperations();
    }

    @Nullable
    public Integer getTotalOperations() {
        if (this._totalOperationsField != null) {
            return this._totalOperationsField;
        }
        Object __rawValue = this._map.get("totalOperations");
        this._totalOperationsField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalOperationsField;
    }

    public OperationsAggregationsResult setTotalOperations(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalOperations(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalOperations();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalOperations", DataTemplateUtil.coerceIntInput(value));
                this._totalOperationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalOperations", DataTemplateUtil.coerceIntInput(value));
                this._totalOperationsField = value;
            }
        }
        return this;
    }

    public OperationsAggregationsResult setTotalOperations(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalOperations of com.linkedin.operations.OperationsAggregationsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalOperations", DataTemplateUtil.coerceIntInput(value));
        this._totalOperationsField = value;
        return this;
    }

    public OperationsAggregationsResult setTotalOperations(int value) {
        CheckedUtil.putWithoutChecking(this._map, "totalOperations", DataTemplateUtil.coerceIntInput(value));
        this._totalOperationsField = value;
        return this;
    }

    public boolean hasTotalInserts() {
        if (this._totalInsertsField != null) {
            return true;
        }
        return this._map.containsKey("totalInserts");
    }

    public void removeTotalInserts() {
        this._map.remove("totalInserts");
    }

    @Nullable
    public Integer getTotalInserts(GetMode mode) {
        return this.getTotalInserts();
    }

    @Nullable
    public Integer getTotalInserts() {
        if (this._totalInsertsField != null) {
            return this._totalInsertsField;
        }
        Object __rawValue = this._map.get("totalInserts");
        this._totalInsertsField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalInsertsField;
    }

    public OperationsAggregationsResult setTotalInserts(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalInserts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalInserts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalInserts", DataTemplateUtil.coerceIntInput(value));
                this._totalInsertsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalInserts", DataTemplateUtil.coerceIntInput(value));
                this._totalInsertsField = value;
            }
        }
        return this;
    }

    public OperationsAggregationsResult setTotalInserts(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalInserts of com.linkedin.operations.OperationsAggregationsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalInserts", DataTemplateUtil.coerceIntInput(value));
        this._totalInsertsField = value;
        return this;
    }

    public OperationsAggregationsResult setTotalInserts(int value) {
        CheckedUtil.putWithoutChecking(this._map, "totalInserts", DataTemplateUtil.coerceIntInput(value));
        this._totalInsertsField = value;
        return this;
    }

    public boolean hasTotalUpdates() {
        if (this._totalUpdatesField != null) {
            return true;
        }
        return this._map.containsKey("totalUpdates");
    }

    public void removeTotalUpdates() {
        this._map.remove("totalUpdates");
    }

    @Nullable
    public Integer getTotalUpdates(GetMode mode) {
        return this.getTotalUpdates();
    }

    @Nullable
    public Integer getTotalUpdates() {
        if (this._totalUpdatesField != null) {
            return this._totalUpdatesField;
        }
        Object __rawValue = this._map.get("totalUpdates");
        this._totalUpdatesField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalUpdatesField;
    }

    public OperationsAggregationsResult setTotalUpdates(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalUpdates(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalUpdates();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalUpdates", DataTemplateUtil.coerceIntInput(value));
                this._totalUpdatesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalUpdates", DataTemplateUtil.coerceIntInput(value));
                this._totalUpdatesField = value;
            }
        }
        return this;
    }

    public OperationsAggregationsResult setTotalUpdates(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalUpdates of com.linkedin.operations.OperationsAggregationsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalUpdates", DataTemplateUtil.coerceIntInput(value));
        this._totalUpdatesField = value;
        return this;
    }

    public OperationsAggregationsResult setTotalUpdates(int value) {
        CheckedUtil.putWithoutChecking(this._map, "totalUpdates", DataTemplateUtil.coerceIntInput(value));
        this._totalUpdatesField = value;
        return this;
    }

    public boolean hasTotalDeletes() {
        if (this._totalDeletesField != null) {
            return true;
        }
        return this._map.containsKey("totalDeletes");
    }

    public void removeTotalDeletes() {
        this._map.remove("totalDeletes");
    }

    @Nullable
    public Integer getTotalDeletes(GetMode mode) {
        return this.getTotalDeletes();
    }

    @Nullable
    public Integer getTotalDeletes() {
        if (this._totalDeletesField != null) {
            return this._totalDeletesField;
        }
        Object __rawValue = this._map.get("totalDeletes");
        this._totalDeletesField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalDeletesField;
    }

    public OperationsAggregationsResult setTotalDeletes(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalDeletes(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalDeletes();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalDeletes", DataTemplateUtil.coerceIntInput(value));
                this._totalDeletesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalDeletes", DataTemplateUtil.coerceIntInput(value));
                this._totalDeletesField = value;
            }
        }
        return this;
    }

    public OperationsAggregationsResult setTotalDeletes(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalDeletes of com.linkedin.operations.OperationsAggregationsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalDeletes", DataTemplateUtil.coerceIntInput(value));
        this._totalDeletesField = value;
        return this;
    }

    public OperationsAggregationsResult setTotalDeletes(int value) {
        CheckedUtil.putWithoutChecking(this._map, "totalDeletes", DataTemplateUtil.coerceIntInput(value));
        this._totalDeletesField = value;
        return this;
    }

    public boolean hasTotalCreates() {
        if (this._totalCreatesField != null) {
            return true;
        }
        return this._map.containsKey("totalCreates");
    }

    public void removeTotalCreates() {
        this._map.remove("totalCreates");
    }

    @Nullable
    public Integer getTotalCreates(GetMode mode) {
        return this.getTotalCreates();
    }

    @Nullable
    public Integer getTotalCreates() {
        if (this._totalCreatesField != null) {
            return this._totalCreatesField;
        }
        Object __rawValue = this._map.get("totalCreates");
        this._totalCreatesField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalCreatesField;
    }

    public OperationsAggregationsResult setTotalCreates(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalCreates(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalCreates();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalCreates", DataTemplateUtil.coerceIntInput(value));
                this._totalCreatesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalCreates", DataTemplateUtil.coerceIntInput(value));
                this._totalCreatesField = value;
            }
        }
        return this;
    }

    public OperationsAggregationsResult setTotalCreates(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalCreates of com.linkedin.operations.OperationsAggregationsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalCreates", DataTemplateUtil.coerceIntInput(value));
        this._totalCreatesField = value;
        return this;
    }

    public OperationsAggregationsResult setTotalCreates(int value) {
        CheckedUtil.putWithoutChecking(this._map, "totalCreates", DataTemplateUtil.coerceIntInput(value));
        this._totalCreatesField = value;
        return this;
    }

    public boolean hasTotalAlters() {
        if (this._totalAltersField != null) {
            return true;
        }
        return this._map.containsKey("totalAlters");
    }

    public void removeTotalAlters() {
        this._map.remove("totalAlters");
    }

    @Nullable
    public Integer getTotalAlters(GetMode mode) {
        return this.getTotalAlters();
    }

    @Nullable
    public Integer getTotalAlters() {
        if (this._totalAltersField != null) {
            return this._totalAltersField;
        }
        Object __rawValue = this._map.get("totalAlters");
        this._totalAltersField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalAltersField;
    }

    public OperationsAggregationsResult setTotalAlters(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalAlters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalAlters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalAlters", DataTemplateUtil.coerceIntInput(value));
                this._totalAltersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalAlters", DataTemplateUtil.coerceIntInput(value));
                this._totalAltersField = value;
            }
        }
        return this;
    }

    public OperationsAggregationsResult setTotalAlters(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalAlters of com.linkedin.operations.OperationsAggregationsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalAlters", DataTemplateUtil.coerceIntInput(value));
        this._totalAltersField = value;
        return this;
    }

    public OperationsAggregationsResult setTotalAlters(int value) {
        CheckedUtil.putWithoutChecking(this._map, "totalAlters", DataTemplateUtil.coerceIntInput(value));
        this._totalAltersField = value;
        return this;
    }

    public boolean hasTotalDrops() {
        if (this._totalDropsField != null) {
            return true;
        }
        return this._map.containsKey("totalDrops");
    }

    public void removeTotalDrops() {
        this._map.remove("totalDrops");
    }

    @Nullable
    public Integer getTotalDrops(GetMode mode) {
        return this.getTotalDrops();
    }

    @Nullable
    public Integer getTotalDrops() {
        if (this._totalDropsField != null) {
            return this._totalDropsField;
        }
        Object __rawValue = this._map.get("totalDrops");
        this._totalDropsField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalDropsField;
    }

    public OperationsAggregationsResult setTotalDrops(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalDrops(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalDrops();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalDrops", DataTemplateUtil.coerceIntInput(value));
                this._totalDropsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalDrops", DataTemplateUtil.coerceIntInput(value));
                this._totalDropsField = value;
            }
        }
        return this;
    }

    public OperationsAggregationsResult setTotalDrops(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalDrops of com.linkedin.operations.OperationsAggregationsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalDrops", DataTemplateUtil.coerceIntInput(value));
        this._totalDropsField = value;
        return this;
    }

    public OperationsAggregationsResult setTotalDrops(int value) {
        CheckedUtil.putWithoutChecking(this._map, "totalDrops", DataTemplateUtil.coerceIntInput(value));
        this._totalDropsField = value;
        return this;
    }

    public boolean hasTotalCustoms() {
        if (this._totalCustomsField != null) {
            return true;
        }
        return this._map.containsKey("totalCustoms");
    }

    public void removeTotalCustoms() {
        this._map.remove("totalCustoms");
    }

    @Nullable
    public Integer getTotalCustoms(GetMode mode) {
        return this.getTotalCustoms();
    }

    @Nullable
    public Integer getTotalCustoms() {
        if (this._totalCustomsField != null) {
            return this._totalCustomsField;
        }
        Object __rawValue = this._map.get("totalCustoms");
        this._totalCustomsField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalCustomsField;
    }

    public OperationsAggregationsResult setTotalCustoms(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalCustoms(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalCustoms();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalCustoms", DataTemplateUtil.coerceIntInput(value));
                this._totalCustomsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalCustoms", DataTemplateUtil.coerceIntInput(value));
                this._totalCustomsField = value;
            }
        }
        return this;
    }

    public OperationsAggregationsResult setTotalCustoms(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalCustoms of com.linkedin.operations.OperationsAggregationsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalCustoms", DataTemplateUtil.coerceIntInput(value));
        this._totalCustomsField = value;
        return this;
    }

    public OperationsAggregationsResult setTotalCustoms(int value) {
        CheckedUtil.putWithoutChecking(this._map, "totalCustoms", DataTemplateUtil.coerceIntInput(value));
        this._totalCustomsField = value;
        return this;
    }

    public boolean hasCustomOperationsMap() {
        if (this._customOperationsMapField != null) {
            return true;
        }
        return this._map.containsKey("customOperationsMap");
    }

    public void removeCustomOperationsMap() {
        this._map.remove("customOperationsMap");
    }

    @Nullable
    public IntegerMap getCustomOperationsMap(GetMode mode) {
        return this.getCustomOperationsMap();
    }

    @Nullable
    public IntegerMap getCustomOperationsMap() {
        if (this._customOperationsMapField != null) {
            return this._customOperationsMapField;
        }
        Object __rawValue = this._map.get("customOperationsMap");
        this._customOperationsMapField = __rawValue == null ? null : new IntegerMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customOperationsMapField;
    }

    public OperationsAggregationsResult setCustomOperationsMap(@Nullable IntegerMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomOperationsMap(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomOperationsMap();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customOperationsMap", value.data());
                this._customOperationsMapField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customOperationsMap", value.data());
                this._customOperationsMapField = value;
            }
        }
        return this;
    }

    public OperationsAggregationsResult setCustomOperationsMap(@Nonnull IntegerMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customOperationsMap of com.linkedin.operations.OperationsAggregationsResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customOperationsMap", value.data());
        this._customOperationsMapField = value;
        return this;
    }

    @Override
    public OperationsAggregationsResult clone() throws CloneNotSupportedException {
        OperationsAggregationsResult __clone = (OperationsAggregationsResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public OperationsAggregationsResult copy() throws CloneNotSupportedException {
        OperationsAggregationsResult __copy = (OperationsAggregationsResult)super.copy();
        __copy._totalCreatesField = null;
        __copy._totalAltersField = null;
        __copy._totalOperationsField = null;
        __copy._totalDropsField = null;
        __copy._totalInsertsField = null;
        __copy._totalUpdatesField = null;
        __copy._totalDeletesField = null;
        __copy._totalCustomsField = null;
        __copy._customOperationsMapField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final OperationsAggregationsResult __objectRef;

        private ChangeListener(OperationsAggregationsResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "totalCreates": {
                    this.__objectRef._totalCreatesField = null;
                    break;
                }
                case "totalAlters": {
                    this.__objectRef._totalAltersField = null;
                    break;
                }
                case "totalOperations": {
                    this.__objectRef._totalOperationsField = null;
                    break;
                }
                case "totalDrops": {
                    this.__objectRef._totalDropsField = null;
                    break;
                }
                case "totalInserts": {
                    this.__objectRef._totalInsertsField = null;
                    break;
                }
                case "totalUpdates": {
                    this.__objectRef._totalUpdatesField = null;
                    break;
                }
                case "totalDeletes": {
                    this.__objectRef._totalDeletesField = null;
                    break;
                }
                case "totalCustoms": {
                    this.__objectRef._totalCustomsField = null;
                    break;
                }
                case "customOperationsMap": {
                    this.__objectRef._customOperationsMapField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec totalOperations() {
            return new PathSpec(this.getPathComponents(), "totalOperations");
        }

        public PathSpec totalInserts() {
            return new PathSpec(this.getPathComponents(), "totalInserts");
        }

        public PathSpec totalUpdates() {
            return new PathSpec(this.getPathComponents(), "totalUpdates");
        }

        public PathSpec totalDeletes() {
            return new PathSpec(this.getPathComponents(), "totalDeletes");
        }

        public PathSpec totalCreates() {
            return new PathSpec(this.getPathComponents(), "totalCreates");
        }

        public PathSpec totalAlters() {
            return new PathSpec(this.getPathComponents(), "totalAlters");
        }

        public PathSpec totalDrops() {
            return new PathSpec(this.getPathComponents(), "totalDrops");
        }

        public PathSpec totalCustoms() {
            return new PathSpec(this.getPathComponents(), "totalCustoms");
        }

        public PathSpec customOperationsMap() {
            return new PathSpec(this.getPathComponents(), "customOperationsMap");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withTotalOperations() {
            this.getDataMap().put("totalOperations", 1);
            return this;
        }

        public ProjectionMask withTotalInserts() {
            this.getDataMap().put("totalInserts", 1);
            return this;
        }

        public ProjectionMask withTotalUpdates() {
            this.getDataMap().put("totalUpdates", 1);
            return this;
        }

        public ProjectionMask withTotalDeletes() {
            this.getDataMap().put("totalDeletes", 1);
            return this;
        }

        public ProjectionMask withTotalCreates() {
            this.getDataMap().put("totalCreates", 1);
            return this;
        }

        public ProjectionMask withTotalAlters() {
            this.getDataMap().put("totalAlters", 1);
            return this;
        }

        public ProjectionMask withTotalDrops() {
            this.getDataMap().put("totalDrops", 1);
            return this;
        }

        public ProjectionMask withTotalCustoms() {
            this.getDataMap().put("totalCustoms", 1);
            return this;
        }

        public ProjectionMask withCustomOperationsMap() {
            this.getDataMap().put("customOperationsMap", 1);
            return this;
        }
    }
}

