/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.operations;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.operations.OperationsAggregation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class OperationsAggregationArray
extends WrappingArrayTemplate<OperationsAggregation> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.operations/**Operations data for a given resource, rolled up into a bucket.*/record OperationsAggregation{/** Bucket start time in milliseconds */bucket:long/** Bucket duration */duration:{namespace com.linkedin.common/**Enum to define the length of a bucket when doing aggregations*/enum WindowDuration{YEAR,MONTH,WEEK,DAY,HOUR}}/** Resource associated with these usage stats */resource:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/** Aggregations associated with this bucket */aggregations:/**Aggregation results for operations query*/record OperationsAggregationsResult{/** Total number of operations in the bucket */totalOperations:optional int/** Total number of inserts in the bucket */totalInserts:optional int/** Total number of updates in the bucket */totalUpdates:optional int/** Total number of deletes in the bucket */totalDeletes:optional int/** Total number of creates in the bucket */totalCreates:optional int/** Total number of alters in the bucket */totalAlters:optional int/** Total number of drops in the bucket */totalDrops:optional int/** Total number of custom types in the bucket */totalCustoms:optional int/** A map from each custom operation type to the total count for that type*/customOperationsMap:optional map[string,int]}}}]", SchemaFormatType.PDL);

    public OperationsAggregationArray() {
        this(new DataList());
    }

    public OperationsAggregationArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public OperationsAggregationArray(Collection<OperationsAggregation> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public OperationsAggregationArray(DataList data) {
        super(data, SCHEMA, OperationsAggregation.class);
    }

    public OperationsAggregationArray(OperationsAggregation first, OperationsAggregation ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public OperationsAggregationArray clone() throws CloneNotSupportedException {
        OperationsAggregationArray __clone = (OperationsAggregationArray)super.clone();
        return __clone;
    }

    @Override
    public OperationsAggregationArray copy() throws CloneNotSupportedException {
        OperationsAggregationArray __copy = (OperationsAggregationArray)super.copy();
        return __copy;
    }

    @Override
    protected OperationsAggregation coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new OperationsAggregation(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private OperationsAggregation.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<OperationsAggregation.ProjectionMask, OperationsAggregation.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? OperationsAggregation.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public OperationsAggregation.Fields items() {
            return new OperationsAggregation.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

