/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchSuggestion
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.search/**The model for the search result*/record SearchSuggestion{/**The suggestion text for this search query*/text:string/**The score for how close this suggestion is to the original search query.\nThe closer to 1 means it is closer to the original query and 0 is further away.*/score:float/**How many matches there are with the suggested text for the given field*/frequency:long}", SchemaFormatType.PDL);
    private String _textField = null;
    private Float _scoreField = null;
    private Long _frequencyField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Text = SCHEMA.getField("text");
    private static final RecordDataSchema.Field FIELD_Score = SCHEMA.getField("score");
    private static final RecordDataSchema.Field FIELD_Frequency = SCHEMA.getField("frequency");

    public SearchSuggestion() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public SearchSuggestion(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasText() {
        if (this._textField != null) {
            return true;
        }
        return this._map.containsKey("text");
    }

    public void removeText() {
        this._map.remove("text");
    }

    @Nullable
    public String getText(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getText();
            }
            case DEFAULT: 
            case NULL: {
                if (this._textField != null) {
                    return this._textField;
                }
                Object __rawValue = this._map.get("text");
                this._textField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._textField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getText() {
        if (this._textField != null) {
            return this._textField;
        }
        Object __rawValue = this._map.get("text");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("text");
        }
        this._textField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._textField;
    }

    public SearchSuggestion setText(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setText(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field text of com.linkedin.metadata.search.SearchSuggestion");
                }
                CheckedUtil.putWithoutChecking(this._map, "text", value);
                this._textField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeText();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "text", value);
                this._textField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "text", value);
                this._textField = value;
            }
        }
        return this;
    }

    public SearchSuggestion setText(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field text of com.linkedin.metadata.search.SearchSuggestion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "text", value);
        this._textField = value;
        return this;
    }

    public boolean hasScore() {
        if (this._scoreField != null) {
            return true;
        }
        return this._map.containsKey("score");
    }

    public void removeScore() {
        this._map.remove("score");
    }

    @Nullable
    public Float getScore(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getScore();
            }
            case DEFAULT: 
            case NULL: {
                if (this._scoreField != null) {
                    return this._scoreField;
                }
                Object __rawValue = this._map.get("score");
                this._scoreField = DataTemplateUtil.coerceFloatOutput(__rawValue);
                return this._scoreField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Float getScore() {
        if (this._scoreField != null) {
            return this._scoreField;
        }
        Object __rawValue = this._map.get("score");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("score");
        }
        this._scoreField = DataTemplateUtil.coerceFloatOutput(__rawValue);
        return this._scoreField;
    }

    public SearchSuggestion setScore(@Nullable Float value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setScore(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field score of com.linkedin.metadata.search.SearchSuggestion");
                }
                CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceFloatInput(value));
                this._scoreField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeScore();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceFloatInput(value));
                this._scoreField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceFloatInput(value));
                this._scoreField = value;
            }
        }
        return this;
    }

    public SearchSuggestion setScore(@Nonnull Float value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field score of com.linkedin.metadata.search.SearchSuggestion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceFloatInput(value));
        this._scoreField = value;
        return this;
    }

    public SearchSuggestion setScore(float value) {
        CheckedUtil.putWithoutChecking(this._map, "score", DataTemplateUtil.coerceFloatInput(Float.valueOf(value)));
        this._scoreField = Float.valueOf(value);
        return this;
    }

    public boolean hasFrequency() {
        if (this._frequencyField != null) {
            return true;
        }
        return this._map.containsKey("frequency");
    }

    public void removeFrequency() {
        this._map.remove("frequency");
    }

    @Nullable
    public Long getFrequency(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFrequency();
            }
            case DEFAULT: 
            case NULL: {
                if (this._frequencyField != null) {
                    return this._frequencyField;
                }
                Object __rawValue = this._map.get("frequency");
                this._frequencyField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._frequencyField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getFrequency() {
        if (this._frequencyField != null) {
            return this._frequencyField;
        }
        Object __rawValue = this._map.get("frequency");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("frequency");
        }
        this._frequencyField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._frequencyField;
    }

    public SearchSuggestion setFrequency(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFrequency(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field frequency of com.linkedin.metadata.search.SearchSuggestion");
                }
                CheckedUtil.putWithoutChecking(this._map, "frequency", DataTemplateUtil.coerceLongInput(value));
                this._frequencyField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFrequency();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "frequency", DataTemplateUtil.coerceLongInput(value));
                this._frequencyField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "frequency", DataTemplateUtil.coerceLongInput(value));
                this._frequencyField = value;
            }
        }
        return this;
    }

    public SearchSuggestion setFrequency(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field frequency of com.linkedin.metadata.search.SearchSuggestion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "frequency", DataTemplateUtil.coerceLongInput(value));
        this._frequencyField = value;
        return this;
    }

    public SearchSuggestion setFrequency(long value) {
        CheckedUtil.putWithoutChecking(this._map, "frequency", DataTemplateUtil.coerceLongInput(value));
        this._frequencyField = value;
        return this;
    }

    @Override
    public SearchSuggestion clone() throws CloneNotSupportedException {
        SearchSuggestion __clone = (SearchSuggestion)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SearchSuggestion copy() throws CloneNotSupportedException {
        SearchSuggestion __copy = (SearchSuggestion)super.copy();
        __copy._scoreField = null;
        __copy._textField = null;
        __copy._frequencyField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SearchSuggestion __objectRef;

        private ChangeListener(SearchSuggestion reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "score": {
                    this.__objectRef._scoreField = null;
                    break;
                }
                case "text": {
                    this.__objectRef._textField = null;
                    break;
                }
                case "frequency": {
                    this.__objectRef._frequencyField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec text() {
            return new PathSpec(this.getPathComponents(), "text");
        }

        public PathSpec score() {
            return new PathSpec(this.getPathComponents(), "score");
        }

        public PathSpec frequency() {
            return new PathSpec(this.getPathComponents(), "frequency");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withText() {
            this.getDataMap().put("text", 1);
            return this;
        }

        public ProjectionMask withScore() {
            this.getDataMap().put("score", 1);
            return this;
        }

        public ProjectionMask withFrequency() {
            this.getDataMap().put("frequency", 1);
            return this;
        }
    }
}

