/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.restli;

import com.linkedin.common.callback.FutureCallback;
import com.linkedin.d2.balancer.D2Client;
import com.linkedin.d2.balancer.D2ClientBuilder;
import com.linkedin.r2.transport.common.Client;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.client.TransportClientAdapter;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import com.linkedin.restli.client.RestClient;
import java.net.URI;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.commons.lang3.StringUtils;

public class DefaultRestliClientFactory {
    private static final String DEFAULT_REQUEST_TIMEOUT_IN_MS = "10000";

    private DefaultRestliClientFactory() {
    }

    @Nonnull
    public static RestClient getRestLiD2Client(@Nonnull String restLiClientD2ZkHost, @Nonnull String restLiClientD2ZkPath) {
        D2Client d2Client = new D2ClientBuilder().setZkHosts(restLiClientD2ZkHost).setBasePath(restLiClientD2ZkPath).build();
        d2Client.start(new FutureCallback());
        return new RestClient((Client)d2Client, "d2://");
    }

    @Nonnull
    public static RestClient getRestLiClient(@Nonnull String restLiServerHost, int restLiServerPort, boolean useSSL, @Nullable String sslProtocol) {
        return DefaultRestliClientFactory.getRestLiClient(restLiServerHost, restLiServerPort, useSSL, sslProtocol, null);
    }

    @Nonnull
    public static RestClient getRestLiClient(@Nonnull String restLiServerHost, int restLiServerPort, @Nullable String basePath, boolean useSSL, @Nullable String sslProtocol) {
        return DefaultRestliClientFactory.getRestLiClient(restLiServerHost, restLiServerPort, basePath, useSSL, sslProtocol, null);
    }

    @Nonnull
    public static RestClient getRestLiClient(@Nonnull String restLiServerHost, int restLiServerPort, boolean useSSL, @Nullable String sslProtocol, @Nullable Map<String, String> params) {
        return DefaultRestliClientFactory.getRestLiClient(restLiServerHost, restLiServerPort, null, useSSL, sslProtocol, params);
    }

    @Nonnull
    public static RestClient getRestLiClient(@Nonnull String restLiServerHost, int restLiServerPort, @Nullable String basePath, boolean useSSL, @Nullable String sslProtocol, @Nullable Map<String, String> params) {
        Object basePathPart = "";
        if (basePath != null && !basePath.isEmpty()) {
            basePathPart = basePath.startsWith("/") ? basePath : "/" + basePath;
        }
        return DefaultRestliClientFactory.getRestLiClient(URI.create(String.format("%s://%s:%s%s", useSSL ? "https" : "http", restLiServerHost, restLiServerPort, basePathPart)), sslProtocol, params);
    }

    @Nonnull
    public static RestClient getRestLiClient(@Nonnull URI gmsUri, @Nullable String sslProtocol) {
        return DefaultRestliClientFactory.getRestLiClient(gmsUri, sslProtocol, null);
    }

    @Nonnull
    public static RestClient getRestLiClient(@Nonnull URI gmsUri, @Nullable String sslProtocol, @Nullable Map<String, String> inputParams) {
        if (StringUtils.isBlank(gmsUri.getHost()) || gmsUri.getPort() <= 0) {
            throw new InvalidParameterException("Invalid restli server host name or port!");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (inputParams != null) {
            params.putAll(inputParams);
        }
        if ("https".equals(gmsUri.getScheme())) {
            try {
                params.put("http.sslContext", SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException(ex);
            }
            SSLParameters sslParameters = new SSLParameters();
            if (sslProtocol != null) {
                sslParameters.setProtocols(new String[]{sslProtocol});
            }
            params.put("http.sslParams", sslParameters);
        }
        return DefaultRestliClientFactory.getHttpRestClient(gmsUri, params);
    }

    private static RestClient getHttpRestClient(@Nonnull URI gmsUri, @Nonnull Map<String, Object> params) {
        HashMap<String, Object> finalParams = new HashMap<String, Object>();
        finalParams.put("http.requestTimeout", DEFAULT_REQUEST_TIMEOUT_IN_MS);
        finalParams.putAll(params);
        HttpClientFactory http = new HttpClientFactory.Builder().build();
        TransportClient transportClient = http.getClient(Collections.unmodifiableMap(finalParams));
        TransportClientAdapter r2Client = new TransportClientAdapter(transportClient);
        Object uriPrefix = gmsUri.getPath().endsWith("/") ? gmsUri.toString() : String.valueOf(gmsUri) + "/";
        return new RestClient((Client)r2Client, (String)uriPrefix);
    }
}

