/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.recommendation;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.recommendation.RecommendationContentArray;
import com.linkedin.metadata.recommendation.RecommendationRenderType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecommendationModule
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.recommendation,record RecommendationModule{/**Title of the module to display*/title:string/**Unique id of the module being recommended*/moduleId:string/**Type of rendering that defines how the module should be rendered*/renderType:/**Enum that defines how the modules should be rendered.\nThere should be two frontend implementation of large and small modules per type.*/enum RecommendationRenderType{/**Simple list of entities*/ENTITY_NAME_LIST/**List of platforms to search*/PLATFORM_SEARCH_LIST/**Tag search list*/TAG_SEARCH_LIST/**Glossary term search list*/GLOSSARY_TERM_SEARCH_LIST/**A list of recommended searches*/SEARCH_QUERY_LIST/**List of domains to search*/DOMAIN_SEARCH_LIST}/**List of content to display inside the module*/content:array[/**Content to display within each recommendation module*/record RecommendationContent{/**String representation of content*/value:string/**Entity being recommended. Empty if the content being recommended is not an entity*/entity:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Additional context required to generate the the recommendation*/params:optional/**Parameters required to render a recommendation of a given type*/record RecommendationParams{/**Context to define the search recommendations*/searchParams:optional/**Context to define the search recommendations*/record SearchParams{/**Entity types to be searched. If this is not provided, all entities will be searched.*/types:array[string]=[]/**Search query*/query:string/**Filters*/filters:array[{namespace com.linkedin.metadata.query.filter/**A criterion for matching a field with given value*/record Criterion{/**The name of the field that the criterion refers to*/field:string/**The value of the intended field*/value:string/**Values. one of which the intended field should match\nNote, if values is set, the above \"value\" field will be ignored*/values:array[string]=[]/**The condition for the criterion, e.g. EQUAL, START_WITH*/condition:/**The matching condition in a filter criterion*/enum Condition{/**Represent the relation: String field contains value, e.g. name contains Profile*/CONTAIN/**Represent the relation: String field ends with value, e.g. name ends with Event*/END_WITH/**Represent the relation: field = value, e.g. platform = hdfs*/EQUAL/**Represent the relation: field = value and support case insensitive values, e.g. platform = hdfs*/IEQUAL/**Represent the relation: field is null, e.g. platform is null*/IS_NULL/**Represents the relation: field exists and is non-empty, e.g. owners is not null and != [] (empty)*/EXISTS/**Represent the relation greater than, e.g. ownerCount > 5*/GREATER_THAN/**Represent the relation greater than or equal to, e.g. ownerCount >= 5*/GREATER_THAN_OR_EQUAL_TO/**Represent the relation: String field is one of the array values to, e.g. name in [\"Profile\", \"Event\"]*/IN/**Represent the relation less than, e.g. ownerCount < 3*/LESS_THAN/**Represent the relation less than or equal to, e.g. ownerCount <= 3*/LESS_THAN_OR_EQUAL_TO/**Represent the relation: String field starts with value, e.g. name starts with PageView*/START_WITH/**Represent the relation: URN field any nested children in addition to the given URN*/DESCENDANTS_INCL/**Represent the relation: URN field matches any nested parent in addition to the given URN*/ANCESTORS_INCL/**Represent the relation: URN field matches any nested child or parent in addition to the given URN*/RELATED_INCL}=\"EQUAL\"/**Whether the condition should be negated*/negated:boolean=false}}]=[]}/**Context to define the entity profile page*/entityProfileParams:optional/**Context to define the entity profile page*/record EntityProfileParams{/**Urn of the entity being shown*/urn:com.linkedin.common.Urn}/**Context about the recommendation*/contentParams:optional/**Params about the recommended content*/record ContentParams{/**Number of entities corresponding to the recommended content*/count:long}}}]}", SchemaFormatType.PDL);
    private String _titleField = null;
    private String _moduleIdField = null;
    private RecommendationRenderType _renderTypeField = null;
    private RecommendationContentArray _contentField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Title = SCHEMA.getField("title");
    private static final RecordDataSchema.Field FIELD_ModuleId = SCHEMA.getField("moduleId");
    private static final RecordDataSchema.Field FIELD_RenderType = SCHEMA.getField("renderType");
    private static final RecordDataSchema.Field FIELD_Content = SCHEMA.getField("content");

    public RecommendationModule() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public RecommendationModule(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTitle() {
        if (this._titleField != null) {
            return true;
        }
        return this._map.containsKey("title");
    }

    public void removeTitle() {
        this._map.remove("title");
    }

    @Nullable
    public String getTitle(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTitle();
            }
            case DEFAULT: 
            case NULL: {
                if (this._titleField != null) {
                    return this._titleField;
                }
                Object __rawValue = this._map.get("title");
                this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._titleField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTitle() {
        if (this._titleField != null) {
            return this._titleField;
        }
        Object __rawValue = this._map.get("title");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("title");
        }
        this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._titleField;
    }

    public RecommendationModule setTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field title of com.linkedin.metadata.recommendation.RecommendationModule");
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
            }
        }
        return this;
    }

    public RecommendationModule setTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field title of com.linkedin.metadata.recommendation.RecommendationModule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "title", value);
        this._titleField = value;
        return this;
    }

    public boolean hasModuleId() {
        if (this._moduleIdField != null) {
            return true;
        }
        return this._map.containsKey("moduleId");
    }

    public void removeModuleId() {
        this._map.remove("moduleId");
    }

    @Nullable
    public String getModuleId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getModuleId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._moduleIdField != null) {
                    return this._moduleIdField;
                }
                Object __rawValue = this._map.get("moduleId");
                this._moduleIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._moduleIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getModuleId() {
        if (this._moduleIdField != null) {
            return this._moduleIdField;
        }
        Object __rawValue = this._map.get("moduleId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("moduleId");
        }
        this._moduleIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._moduleIdField;
    }

    public RecommendationModule setModuleId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setModuleId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field moduleId of com.linkedin.metadata.recommendation.RecommendationModule");
                }
                CheckedUtil.putWithoutChecking(this._map, "moduleId", value);
                this._moduleIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeModuleId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "moduleId", value);
                this._moduleIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "moduleId", value);
                this._moduleIdField = value;
            }
        }
        return this;
    }

    public RecommendationModule setModuleId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field moduleId of com.linkedin.metadata.recommendation.RecommendationModule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "moduleId", value);
        this._moduleIdField = value;
        return this;
    }

    public boolean hasRenderType() {
        if (this._renderTypeField != null) {
            return true;
        }
        return this._map.containsKey("renderType");
    }

    public void removeRenderType() {
        this._map.remove("renderType");
    }

    @Nullable
    public RecommendationRenderType getRenderType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRenderType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._renderTypeField != null) {
                    return this._renderTypeField;
                }
                Object __rawValue = this._map.get("renderType");
                this._renderTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, RecommendationRenderType.class, RecommendationRenderType.$UNKNOWN);
                return this._renderTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public RecommendationRenderType getRenderType() {
        if (this._renderTypeField != null) {
            return this._renderTypeField;
        }
        Object __rawValue = this._map.get("renderType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("renderType");
        }
        this._renderTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, RecommendationRenderType.class, RecommendationRenderType.$UNKNOWN);
        return this._renderTypeField;
    }

    public RecommendationModule setRenderType(@Nullable RecommendationRenderType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRenderType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field renderType of com.linkedin.metadata.recommendation.RecommendationModule");
                }
                CheckedUtil.putWithoutChecking(this._map, "renderType", value.name());
                this._renderTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRenderType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "renderType", value.name());
                this._renderTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "renderType", value.name());
                this._renderTypeField = value;
            }
        }
        return this;
    }

    public RecommendationModule setRenderType(@Nonnull RecommendationRenderType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field renderType of com.linkedin.metadata.recommendation.RecommendationModule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "renderType", value.name());
        this._renderTypeField = value;
        return this;
    }

    public boolean hasContent() {
        if (this._contentField != null) {
            return true;
        }
        return this._map.containsKey("content");
    }

    public void removeContent() {
        this._map.remove("content");
    }

    @Nullable
    public RecommendationContentArray getContent(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getContent();
            }
            case DEFAULT: 
            case NULL: {
                if (this._contentField != null) {
                    return this._contentField;
                }
                Object __rawValue = this._map.get("content");
                this._contentField = __rawValue == null ? null : new RecommendationContentArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._contentField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public RecommendationContentArray getContent() {
        if (this._contentField != null) {
            return this._contentField;
        }
        Object __rawValue = this._map.get("content");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("content");
        }
        this._contentField = __rawValue == null ? null : new RecommendationContentArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._contentField;
    }

    public RecommendationModule setContent(@Nullable RecommendationContentArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContent(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field content of com.linkedin.metadata.recommendation.RecommendationModule");
                }
                CheckedUtil.putWithoutChecking(this._map, "content", value.data());
                this._contentField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContent();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "content", value.data());
                this._contentField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "content", value.data());
                this._contentField = value;
            }
        }
        return this;
    }

    public RecommendationModule setContent(@Nonnull RecommendationContentArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field content of com.linkedin.metadata.recommendation.RecommendationModule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "content", value.data());
        this._contentField = value;
        return this;
    }

    @Override
    public RecommendationModule clone() throws CloneNotSupportedException {
        RecommendationModule __clone = (RecommendationModule)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public RecommendationModule copy() throws CloneNotSupportedException {
        RecommendationModule __copy = (RecommendationModule)super.copy();
        __copy._titleField = null;
        __copy._moduleIdField = null;
        __copy._renderTypeField = null;
        __copy._contentField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final RecommendationModule __objectRef;

        private ChangeListener(RecommendationModule reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "title": {
                    this.__objectRef._titleField = null;
                    break;
                }
                case "moduleId": {
                    this.__objectRef._moduleIdField = null;
                    break;
                }
                case "renderType": {
                    this.__objectRef._renderTypeField = null;
                    break;
                }
                case "content": {
                    this.__objectRef._contentField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec title() {
            return new PathSpec(this.getPathComponents(), "title");
        }

        public PathSpec moduleId() {
            return new PathSpec(this.getPathComponents(), "moduleId");
        }

        public PathSpec renderType() {
            return new PathSpec(this.getPathComponents(), "renderType");
        }

        public RecommendationContentArray.Fields content() {
            return new RecommendationContentArray.Fields(this.getPathComponents(), "content");
        }

        public PathSpec content(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "content");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private RecommendationContentArray.ProjectionMask _contentMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withTitle() {
            this.getDataMap().put("title", 1);
            return this;
        }

        public ProjectionMask withModuleId() {
            this.getDataMap().put("moduleId", 1);
            return this;
        }

        public ProjectionMask withRenderType() {
            this.getDataMap().put("renderType", 1);
            return this;
        }

        public ProjectionMask withContent(Function<RecommendationContentArray.ProjectionMask, RecommendationContentArray.ProjectionMask> nestedMask) {
            this._contentMask = nestedMask.apply(this._contentMask == null ? RecommendationContentArray.createMask() : this._contentMask);
            this.getDataMap().put("content", this._contentMask.getDataMap());
            return this;
        }

        public ProjectionMask withContent() {
            this._contentMask = null;
            this.getDataMap().put("content", 1);
            return this;
        }

        public ProjectionMask withContent(Function<RecommendationContentArray.ProjectionMask, RecommendationContentArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._contentMask = nestedMask.apply(this._contentMask == null ? RecommendationContentArray.createMask() : this._contentMask);
            this.getDataMap().put("content", this._contentMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("content").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("content").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withContent(Integer start, Integer count) {
            this._contentMask = null;
            this.getDataMap().put("content", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("content").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("content").put("$count", count);
            }
            return this;
        }
    }
}

