/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query;

import com.linkedin.common.UrnArrayMap;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LineageFlags
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query/**Set of flags to control lineage search behavior*/record LineageFlags{/**Limits number of entities explored per hop*/entitiesExploredPerHopLimit:optional int/**Start time for lineage edges to filter*/startTimeMillis:optional long/**End time for lineage edges to filter*/endTimeMillis:optional long/**Map of entity type to list of platform urns to ignore as hops during graph walk. Note: this can potentially cause\na large amount of additional hops to occur and should be used with caution.*/ignoreAsHops:optional map[string,array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]]}", SchemaFormatType.PDL);
    private Integer _entitiesExploredPerHopLimitField = null;
    private Long _startTimeMillisField = null;
    private Long _endTimeMillisField = null;
    private UrnArrayMap _ignoreAsHopsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_EntitiesExploredPerHopLimit = SCHEMA.getField("entitiesExploredPerHopLimit");
    private static final RecordDataSchema.Field FIELD_StartTimeMillis = SCHEMA.getField("startTimeMillis");
    private static final RecordDataSchema.Field FIELD_EndTimeMillis = SCHEMA.getField("endTimeMillis");
    private static final RecordDataSchema.Field FIELD_IgnoreAsHops = SCHEMA.getField("ignoreAsHops");

    public LineageFlags() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public LineageFlags(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEntitiesExploredPerHopLimit() {
        if (this._entitiesExploredPerHopLimitField != null) {
            return true;
        }
        return this._map.containsKey("entitiesExploredPerHopLimit");
    }

    public void removeEntitiesExploredPerHopLimit() {
        this._map.remove("entitiesExploredPerHopLimit");
    }

    @Nullable
    public Integer getEntitiesExploredPerHopLimit(GetMode mode) {
        return this.getEntitiesExploredPerHopLimit();
    }

    @Nullable
    public Integer getEntitiesExploredPerHopLimit() {
        if (this._entitiesExploredPerHopLimitField != null) {
            return this._entitiesExploredPerHopLimitField;
        }
        Object __rawValue = this._map.get("entitiesExploredPerHopLimit");
        this._entitiesExploredPerHopLimitField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._entitiesExploredPerHopLimitField;
    }

    public LineageFlags setEntitiesExploredPerHopLimit(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntitiesExploredPerHopLimit(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntitiesExploredPerHopLimit();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entitiesExploredPerHopLimit", DataTemplateUtil.coerceIntInput(value));
                this._entitiesExploredPerHopLimitField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entitiesExploredPerHopLimit", DataTemplateUtil.coerceIntInput(value));
                this._entitiesExploredPerHopLimitField = value;
            }
        }
        return this;
    }

    public LineageFlags setEntitiesExploredPerHopLimit(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entitiesExploredPerHopLimit of com.linkedin.metadata.query.LineageFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entitiesExploredPerHopLimit", DataTemplateUtil.coerceIntInput(value));
        this._entitiesExploredPerHopLimitField = value;
        return this;
    }

    public LineageFlags setEntitiesExploredPerHopLimit(int value) {
        CheckedUtil.putWithoutChecking(this._map, "entitiesExploredPerHopLimit", DataTemplateUtil.coerceIntInput(value));
        this._entitiesExploredPerHopLimitField = value;
        return this;
    }

    public boolean hasStartTimeMillis() {
        if (this._startTimeMillisField != null) {
            return true;
        }
        return this._map.containsKey("startTimeMillis");
    }

    public void removeStartTimeMillis() {
        this._map.remove("startTimeMillis");
    }

    @Nullable
    public Long getStartTimeMillis(GetMode mode) {
        return this.getStartTimeMillis();
    }

    @Nullable
    public Long getStartTimeMillis() {
        if (this._startTimeMillisField != null) {
            return this._startTimeMillisField;
        }
        Object __rawValue = this._map.get("startTimeMillis");
        this._startTimeMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._startTimeMillisField;
    }

    public LineageFlags setStartTimeMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStartTimeMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStartTimeMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "startTimeMillis", DataTemplateUtil.coerceLongInput(value));
                this._startTimeMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "startTimeMillis", DataTemplateUtil.coerceLongInput(value));
                this._startTimeMillisField = value;
            }
        }
        return this;
    }

    public LineageFlags setStartTimeMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field startTimeMillis of com.linkedin.metadata.query.LineageFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "startTimeMillis", DataTemplateUtil.coerceLongInput(value));
        this._startTimeMillisField = value;
        return this;
    }

    public LineageFlags setStartTimeMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "startTimeMillis", DataTemplateUtil.coerceLongInput(value));
        this._startTimeMillisField = value;
        return this;
    }

    public boolean hasEndTimeMillis() {
        if (this._endTimeMillisField != null) {
            return true;
        }
        return this._map.containsKey("endTimeMillis");
    }

    public void removeEndTimeMillis() {
        this._map.remove("endTimeMillis");
    }

    @Nullable
    public Long getEndTimeMillis(GetMode mode) {
        return this.getEndTimeMillis();
    }

    @Nullable
    public Long getEndTimeMillis() {
        if (this._endTimeMillisField != null) {
            return this._endTimeMillisField;
        }
        Object __rawValue = this._map.get("endTimeMillis");
        this._endTimeMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._endTimeMillisField;
    }

    public LineageFlags setEndTimeMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEndTimeMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEndTimeMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "endTimeMillis", DataTemplateUtil.coerceLongInput(value));
                this._endTimeMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "endTimeMillis", DataTemplateUtil.coerceLongInput(value));
                this._endTimeMillisField = value;
            }
        }
        return this;
    }

    public LineageFlags setEndTimeMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field endTimeMillis of com.linkedin.metadata.query.LineageFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "endTimeMillis", DataTemplateUtil.coerceLongInput(value));
        this._endTimeMillisField = value;
        return this;
    }

    public LineageFlags setEndTimeMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "endTimeMillis", DataTemplateUtil.coerceLongInput(value));
        this._endTimeMillisField = value;
        return this;
    }

    public boolean hasIgnoreAsHops() {
        if (this._ignoreAsHopsField != null) {
            return true;
        }
        return this._map.containsKey("ignoreAsHops");
    }

    public void removeIgnoreAsHops() {
        this._map.remove("ignoreAsHops");
    }

    @Nullable
    public UrnArrayMap getIgnoreAsHops(GetMode mode) {
        return this.getIgnoreAsHops();
    }

    @Nullable
    public UrnArrayMap getIgnoreAsHops() {
        if (this._ignoreAsHopsField != null) {
            return this._ignoreAsHopsField;
        }
        Object __rawValue = this._map.get("ignoreAsHops");
        this._ignoreAsHopsField = __rawValue == null ? null : new UrnArrayMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._ignoreAsHopsField;
    }

    public LineageFlags setIgnoreAsHops(@Nullable UrnArrayMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIgnoreAsHops(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIgnoreAsHops();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "ignoreAsHops", value.data());
                this._ignoreAsHopsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "ignoreAsHops", value.data());
                this._ignoreAsHopsField = value;
            }
        }
        return this;
    }

    public LineageFlags setIgnoreAsHops(@Nonnull UrnArrayMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field ignoreAsHops of com.linkedin.metadata.query.LineageFlags to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "ignoreAsHops", value.data());
        this._ignoreAsHopsField = value;
        return this;
    }

    @Override
    public LineageFlags clone() throws CloneNotSupportedException {
        LineageFlags __clone = (LineageFlags)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public LineageFlags copy() throws CloneNotSupportedException {
        LineageFlags __copy = (LineageFlags)super.copy();
        __copy._endTimeMillisField = null;
        __copy._startTimeMillisField = null;
        __copy._entitiesExploredPerHopLimitField = null;
        __copy._ignoreAsHopsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final LineageFlags __objectRef;

        private ChangeListener(LineageFlags reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "endTimeMillis": {
                    this.__objectRef._endTimeMillisField = null;
                    break;
                }
                case "startTimeMillis": {
                    this.__objectRef._startTimeMillisField = null;
                    break;
                }
                case "entitiesExploredPerHopLimit": {
                    this.__objectRef._entitiesExploredPerHopLimitField = null;
                    break;
                }
                case "ignoreAsHops": {
                    this.__objectRef._ignoreAsHopsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec entitiesExploredPerHopLimit() {
            return new PathSpec(this.getPathComponents(), "entitiesExploredPerHopLimit");
        }

        public PathSpec startTimeMillis() {
            return new PathSpec(this.getPathComponents(), "startTimeMillis");
        }

        public PathSpec endTimeMillis() {
            return new PathSpec(this.getPathComponents(), "endTimeMillis");
        }

        public PathSpec ignoreAsHops() {
            return new PathSpec(this.getPathComponents(), "ignoreAsHops");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withEntitiesExploredPerHopLimit() {
            this.getDataMap().put("entitiesExploredPerHopLimit", 1);
            return this;
        }

        public ProjectionMask withStartTimeMillis() {
            this.getDataMap().put("startTimeMillis", 1);
            return this;
        }

        public ProjectionMask withEndTimeMillis() {
            this.getDataMap().put("endTimeMillis", 1);
            return this;
        }

        public ProjectionMask withIgnoreAsHops() {
            this.getDataMap().put("ignoreAsHops", 1);
            return this;
        }
    }
}

