/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.LongMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FreshnessStats
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query/**Stats that describe the freshness of a dataset or query result.\nUseful to describe consistency and staleness of results when served\nout of a cache or other eventually consistent system.*/record FreshnessStats{cached:optional boolean,systemFreshness:optional map[string,long]}", SchemaFormatType.PDL);
    private Boolean _cachedField = null;
    private LongMap _systemFreshnessField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Cached = SCHEMA.getField("cached");
    private static final RecordDataSchema.Field FIELD_SystemFreshness = SCHEMA.getField("systemFreshness");

    public FreshnessStats() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public FreshnessStats(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCached() {
        if (this._cachedField != null) {
            return true;
        }
        return this._map.containsKey("cached");
    }

    public void removeCached() {
        this._map.remove("cached");
    }

    @Nullable
    public Boolean isCached(GetMode mode) {
        return this.isCached();
    }

    @Nullable
    public Boolean isCached() {
        if (this._cachedField != null) {
            return this._cachedField;
        }
        Object __rawValue = this._map.get("cached");
        this._cachedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._cachedField;
    }

    public FreshnessStats setCached(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCached(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCached();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "cached", value);
                this._cachedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "cached", value);
                this._cachedField = value;
            }
        }
        return this;
    }

    public FreshnessStats setCached(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field cached of com.linkedin.metadata.query.FreshnessStats to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "cached", value);
        this._cachedField = value;
        return this;
    }

    public FreshnessStats setCached(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "cached", value);
        this._cachedField = value;
        return this;
    }

    public boolean hasSystemFreshness() {
        if (this._systemFreshnessField != null) {
            return true;
        }
        return this._map.containsKey("systemFreshness");
    }

    public void removeSystemFreshness() {
        this._map.remove("systemFreshness");
    }

    @Nullable
    public LongMap getSystemFreshness(GetMode mode) {
        return this.getSystemFreshness();
    }

    @Nullable
    public LongMap getSystemFreshness() {
        if (this._systemFreshnessField != null) {
            return this._systemFreshnessField;
        }
        Object __rawValue = this._map.get("systemFreshness");
        this._systemFreshnessField = __rawValue == null ? null : new LongMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._systemFreshnessField;
    }

    public FreshnessStats setSystemFreshness(@Nullable LongMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSystemFreshness(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSystemFreshness();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "systemFreshness", value.data());
                this._systemFreshnessField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "systemFreshness", value.data());
                this._systemFreshnessField = value;
            }
        }
        return this;
    }

    public FreshnessStats setSystemFreshness(@Nonnull LongMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field systemFreshness of com.linkedin.metadata.query.FreshnessStats to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "systemFreshness", value.data());
        this._systemFreshnessField = value;
        return this;
    }

    @Override
    public FreshnessStats clone() throws CloneNotSupportedException {
        FreshnessStats __clone = (FreshnessStats)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FreshnessStats copy() throws CloneNotSupportedException {
        FreshnessStats __copy = (FreshnessStats)super.copy();
        __copy._cachedField = null;
        __copy._systemFreshnessField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FreshnessStats __objectRef;

        private ChangeListener(FreshnessStats reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "cached": {
                    this.__objectRef._cachedField = null;
                    break;
                }
                case "systemFreshness": {
                    this.__objectRef._systemFreshnessField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec cached() {
            return new PathSpec(this.getPathComponents(), "cached");
        }

        public PathSpec systemFreshness() {
            return new PathSpec(this.getPathComponents(), "systemFreshness");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withCached() {
            this.getDataMap().put("cached", 1);
            return this;
        }

        public ProjectionMask withSystemFreshness() {
            this.getDataMap().put("systemFreshness", 1);
            return this;
        }
    }
}

