/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import com.linkedin.data.schema.annotation.TraverserContext;
import com.linkedin.metadata.models.FieldSpecUtils;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.TimeseriesFieldCollectionSpec;
import com.linkedin.metadata.models.TimeseriesFieldSpec;
import com.linkedin.metadata.models.annotation.TimeseriesFieldAnnotation;
import com.linkedin.metadata.models.annotation.TimeseriesFieldCollectionAnnotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class TimeseriesFieldSpecExtractor
implements SchemaVisitor {
    private final List<TimeseriesFieldSpec> timeseriesFieldSpecs = new ArrayList<TimeseriesFieldSpec>();
    private final List<TimeseriesFieldCollectionSpec> timeseriesFieldCollectionSpecs = new ArrayList<TimeseriesFieldCollectionSpec>();
    private final Map<String, String> namesToPath = new HashMap<String, String>();

    @Override
    public void callbackOnContext(TraverserContext context, DataSchemaTraverse.Order order) {
        if (context.getEnclosingField() == null) {
            return;
        }
        if (DataSchemaTraverse.Order.PRE_ORDER.equals((Object)order)) {
            DataSchema currentSchema = context.getCurrentSchema().getDereferencedDataSchema();
            PathSpec path = new PathSpec(context.getSchemaPathSpec());
            Map<String, Object> primaryProperties = context.getEnclosingField().getProperties();
            Object timeseriesFieldAnnotationObj = primaryProperties.get("TimeseriesField");
            Object timeseriesFieldCollectionAnnotationObj = primaryProperties.get("TimeseriesFieldCollection");
            if (currentSchema.getType() == DataSchema.Type.RECORD && timeseriesFieldCollectionAnnotationObj != null) {
                this.validateCollectionAnnotation(currentSchema, timeseriesFieldCollectionAnnotationObj, context.getTraversePath().toString());
                this.addTimeseriesFieldCollectionSpec(currentSchema, path, timeseriesFieldCollectionAnnotationObj);
            } else if (timeseriesFieldAnnotationObj != null && !path.getPathComponents().get(path.getPathComponents().size() - 1).equals("*")) {
                this.addTimeseriesFieldSpec(currentSchema, path, timeseriesFieldAnnotationObj);
            } else {
                this.addTimeseriesFieldCollectionKey(path);
            }
        }
    }

    private void validateCollectionAnnotation(DataSchema currentSchema, Object annotationObj, String pathStr) {
        if (currentSchema.isPrimitive()) {
            return;
        }
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared inside %s: Invalid value type provided (Expected Map)", "TimeseriesFieldCollection", pathStr));
        }
    }

    private void addTimeseriesFieldCollectionSpec(DataSchema currentSchema, PathSpec path, Object annotationObj) {
        if (currentSchema.getType() == DataSchema.Type.RECORD) {
            TimeseriesFieldCollectionAnnotation annotation = TimeseriesFieldCollectionAnnotation.fromPegasusAnnotationObject(annotationObj, FieldSpecUtils.getSchemaFieldName(path), path.toString());
            if (this.namesToPath.containsKey(annotation.getCollectionName()) && !this.namesToPath.get(annotation.getCollectionName()).equals(path.toString())) {
                throw new ModelValidationException(String.format("There are multiple fields with the same name: %s", annotation.getCollectionName()));
            }
            this.namesToPath.put(annotation.getCollectionName(), path.toString());
            this.timeseriesFieldCollectionSpecs.add(new TimeseriesFieldCollectionSpec(path, annotation, new HashMap<String, TimeseriesFieldSpec>(), currentSchema));
        }
    }

    private void addTimeseriesFieldSpec(DataSchema currentSchema, PathSpec path, Object annotationObj) {
        String pathStr = path.toString();
        Optional<TimeseriesFieldCollectionSpec> fieldCollectionSpec = this.timeseriesFieldCollectionSpecs.stream().filter(spec -> pathStr.startsWith(spec.getPath().toString())).findFirst();
        TimeseriesFieldAnnotation annotation = TimeseriesFieldAnnotation.fromPegasusAnnotationObject(annotationObj, FieldSpecUtils.getSchemaFieldName(path), currentSchema.getDereferencedType(), path.toString());
        if (fieldCollectionSpec.isPresent()) {
            fieldCollectionSpec.get().getTimeseriesFieldSpecMap().put(annotation.getStatName(), new TimeseriesFieldSpec(this.getRelativePath(path, fieldCollectionSpec.get().getPath()), annotation, currentSchema));
        } else {
            if (path.getPathComponents().contains("*")) {
                throw new ModelValidationException(String.format("No matching collection found for the given timeseries field %s", pathStr));
            }
            this.timeseriesFieldSpecs.add(new TimeseriesFieldSpec(path, annotation, currentSchema));
        }
    }

    private void addTimeseriesFieldCollectionKey(PathSpec path) {
        for (TimeseriesFieldCollectionSpec spec : this.timeseriesFieldCollectionSpecs) {
            if (!path.toString().equals(spec.getKeyPathFromAnnotation())) continue;
            spec.setKeyPath(this.getRelativePath(path, spec.getPath()));
            return;
        }
    }

    private PathSpec getRelativePath(PathSpec child, PathSpec parent) {
        return new PathSpec(child.getPathComponents().subList(parent.getPathComponents().size(), child.getPathComponents().size()));
    }

    @Override
    public SchemaVisitor.VisitorContext getInitialVisitorContext() {
        return null;
    }

    @Override
    public SchemaVisitorTraversalResult getSchemaVisitorTraversalResult() {
        return new SchemaVisitorTraversalResult();
    }

    @Generated
    public List<TimeseriesFieldSpec> getTimeseriesFieldSpecs() {
        return this.timeseriesFieldSpecs;
    }

    @Generated
    public List<TimeseriesFieldCollectionSpec> getTimeseriesFieldCollectionSpecs() {
        return this.timeseriesFieldCollectionSpecs;
    }

    @Generated
    public Map<String, String> getNamesToPath() {
        return this.namesToPath;
    }
}

