/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.google.common.collect.ImmutableList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.annotation.DataSchemaRichContextTraverser;
import com.linkedin.data.schema.annotation.PegasusSchemaAnnotationHandlerImpl;
import com.linkedin.data.schema.annotation.SchemaAnnotationHandler;
import com.linkedin.data.schema.annotation.SchemaAnnotationProcessor;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.ConfigEntitySpec;
import com.linkedin.metadata.models.DefaultEntitySpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.PartialEntitySpec;
import com.linkedin.metadata.models.RelationshipFieldSpec;
import com.linkedin.metadata.models.RelationshipFieldSpecExtractor;
import com.linkedin.metadata.models.SearchScoreFieldSpecExtractor;
import com.linkedin.metadata.models.SearchableFieldSpecExtractor;
import com.linkedin.metadata.models.SearchableRefFieldSpecExtractor;
import com.linkedin.metadata.models.TimeseriesFieldSpecExtractor;
import com.linkedin.metadata.models.UrnValidationFieldSpecExtractor;
import com.linkedin.metadata.models.annotation.AspectAnnotation;
import com.linkedin.metadata.models.annotation.EntityAnnotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySpecBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntitySpecBuilder.class);
    private static final String URN_FIELD_NAME = "urn";
    private static final String ASPECTS_FIELD_NAME = "aspects";
    private static final String TIMESTAMP_FIELD_NAME = "timestampMillis";
    public static SchemaAnnotationHandler _searchHandler = new PegasusSchemaAnnotationHandlerImpl("Searchable");
    public static SchemaAnnotationHandler _searchScoreHandler = new PegasusSchemaAnnotationHandlerImpl("SearchScore");
    public static SchemaAnnotationHandler _searchRefScoreHandler = new PegasusSchemaAnnotationHandlerImpl("SearchableRef");
    public static SchemaAnnotationHandler _relationshipHandler = new PegasusSchemaAnnotationHandlerImpl("Relationship");
    public static SchemaAnnotationHandler _timeseriesFiledAnnotationHandler = new PegasusSchemaAnnotationHandlerImpl("TimeseriesField");
    public static SchemaAnnotationHandler _timeseriesFieldCollectionHandler = new PegasusSchemaAnnotationHandlerImpl("TimeseriesFieldCollection");
    public static SchemaAnnotationHandler _urnValidationAnnotationHandler = new PegasusSchemaAnnotationHandlerImpl("UrnValidation");
    private final AnnotationExtractionMode _extractionMode;
    private final Set<String> _entityNames = new HashSet<String>();
    private final Set<RelationshipFieldSpec> _relationshipFieldSpecs = new HashSet<RelationshipFieldSpec>();

    public EntitySpecBuilder() {
        this(AnnotationExtractionMode.DEFAULT);
    }

    public EntitySpecBuilder(AnnotationExtractionMode extractionMode) {
        this._extractionMode = extractionMode;
    }

    public List<EntitySpec> buildEntitySpecs(@Nonnull DataSchema snapshotSchema) {
        UnionDataSchema snapshotUnionSchema = (UnionDataSchema)snapshotSchema.getDereferencedDataSchema();
        List<UnionDataSchema.Member> unionMembers = snapshotUnionSchema.getMembers();
        ArrayList<EntitySpec> entitySpecs = new ArrayList<EntitySpec>();
        for (UnionDataSchema.Member member : unionMembers) {
            EntitySpec entitySpec = this.buildEntitySpec(member.getType());
            if (entitySpec == null) continue;
            entitySpecs.add(entitySpec);
        }
        return entitySpecs;
    }

    public EntitySpec buildEntitySpec(@Nonnull DataSchema entitySnapshotSchema) {
        RecordDataSchema entitySnapshotRecordSchema = this.validateSnapshot(entitySnapshotSchema);
        Object entityAnnotationObj = entitySnapshotRecordSchema.getProperties().get("Entity");
        if (entityAnnotationObj != null) {
            EntityAnnotation entityAnnotation = EntityAnnotation.fromSchemaProperty(entityAnnotationObj, entitySnapshotRecordSchema.getFullName());
            ArrayDataSchema aspectArraySchema = (ArrayDataSchema)entitySnapshotRecordSchema.getField(ASPECTS_FIELD_NAME).getType().getDereferencedDataSchema();
            UnionDataSchema aspectUnionSchema = (UnionDataSchema)aspectArraySchema.getItems().getDereferencedDataSchema();
            List<UnionDataSchema.Member> unionMembers = aspectUnionSchema.getMembers();
            ArrayList<AspectSpec> aspectSpecs = new ArrayList<AspectSpec>();
            for (UnionDataSchema.Member member : unionMembers) {
                NamedDataSchema namedDataSchema = (NamedDataSchema)member.getType();
                try {
                    AspectSpec spec = this.buildAspectSpec(member.getType(), Class.forName(namedDataSchema.getFullName()).asSubclass(RecordTemplate.class));
                    aspectSpecs.add(spec);
                }
                catch (ClassNotFoundException ce) {
                    log.warn("Failed to find class for {}", (Object)member.getType(), (Object)ce);
                }
            }
            DefaultEntitySpec entitySpec = new DefaultEntitySpec(aspectSpecs, entityAnnotation, entitySnapshotRecordSchema, (TyperefDataSchema)aspectArraySchema.getItems());
            this.validateEntitySpec(entitySpec);
            return entitySpec;
        }
        this.failValidation(String.format("Could not build entity spec for entity with name %s. Missing @%s annotation.", entitySnapshotRecordSchema.getName(), "Entity"));
        return null;
    }

    public EntitySpec buildEntitySpec(@Nonnull DataSchema entitySnapshotSchema, @Nonnull List<AspectSpec> aspectSpecs) {
        RecordDataSchema entitySnapshotRecordSchema = this.validateSnapshot(entitySnapshotSchema);
        Object entityAnnotationObj = entitySnapshotRecordSchema.getProperties().get("Entity");
        if (entityAnnotationObj != null) {
            EntityAnnotation entityAnnotation = EntityAnnotation.fromSchemaProperty(entityAnnotationObj, entitySnapshotRecordSchema.getFullName());
            DefaultEntitySpec entitySpec = new DefaultEntitySpec(aspectSpecs, entityAnnotation, entitySnapshotRecordSchema);
            this.validateEntitySpec(entitySpec);
            return entitySpec;
        }
        this.failValidation(String.format("Could not build entity spec for entity with name %s. Missing @%s annotation.", entitySnapshotRecordSchema.getName(), "Entity"));
        return null;
    }

    public EntitySpec buildConfigEntitySpec(@Nonnull String entityName, @Nonnull String keyAspect, @Nonnull List<AspectSpec> aspectSpecs) {
        return new ConfigEntitySpec(entityName, keyAspect, aspectSpecs);
    }

    public EntitySpec buildPartialEntitySpec(@Nonnull String entityName, @Nullable String keyAspectName, @Nonnull List<AspectSpec> aspectSpecs) {
        PartialEntitySpec entitySpec = new PartialEntitySpec(aspectSpecs, new EntityAnnotation(entityName, keyAspectName));
        return entitySpec;
    }

    public AspectSpec buildAspectSpec(@Nonnull DataSchema aspectDataSchema, Class<RecordTemplate> aspectClass) {
        RecordDataSchema aspectRecordSchema = this.validateAspect(aspectDataSchema);
        Object aspectAnnotationObj = aspectRecordSchema.getProperties().get("Aspect");
        if (aspectAnnotationObj != null) {
            AspectAnnotation aspectAnnotation = AspectAnnotation.fromSchemaProperty(aspectAnnotationObj, aspectRecordSchema.getFullName());
            if (AnnotationExtractionMode.IGNORE_ASPECT_FIELDS.equals((Object)this._extractionMode)) {
                return new AspectSpec(aspectAnnotation, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), aspectRecordSchema, aspectClass);
            }
            SchemaAnnotationProcessor.SchemaAnnotationProcessResult processedSearchResult = SchemaAnnotationProcessor.process(Collections.singletonList(_searchHandler), aspectRecordSchema, new SchemaAnnotationProcessor.AnnotationProcessOption());
            SearchableFieldSpecExtractor searchableFieldSpecExtractor = new SearchableFieldSpecExtractor();
            DataSchemaRichContextTraverser searchableFieldSpecTraverser = new DataSchemaRichContextTraverser(searchableFieldSpecExtractor);
            searchableFieldSpecTraverser.traverse(processedSearchResult.getResultSchema());
            SchemaAnnotationProcessor.SchemaAnnotationProcessResult processedSearchScoreResult = SchemaAnnotationProcessor.process(Collections.singletonList(_searchScoreHandler), aspectRecordSchema, new SchemaAnnotationProcessor.AnnotationProcessOption());
            SchemaAnnotationProcessor.SchemaAnnotationProcessResult processedSearchRefResult = SchemaAnnotationProcessor.process(Collections.singletonList(_searchRefScoreHandler), aspectRecordSchema, new SchemaAnnotationProcessor.AnnotationProcessOption());
            SearchableRefFieldSpecExtractor searchableRefFieldSpecExtractor = new SearchableRefFieldSpecExtractor();
            DataSchemaRichContextTraverser searchableRefFieldSpecTraverser = new DataSchemaRichContextTraverser(searchableRefFieldSpecExtractor);
            searchableRefFieldSpecTraverser.traverse(processedSearchRefResult.getResultSchema());
            SearchScoreFieldSpecExtractor searchScoreFieldSpecExtractor = new SearchScoreFieldSpecExtractor();
            DataSchemaRichContextTraverser searchScoreFieldSpecTraverser = new DataSchemaRichContextTraverser(searchScoreFieldSpecExtractor);
            searchScoreFieldSpecTraverser.traverse(processedSearchScoreResult.getResultSchema());
            SchemaAnnotationProcessor.SchemaAnnotationProcessResult processedRelationshipResult = SchemaAnnotationProcessor.process(Collections.singletonList(_relationshipHandler), aspectRecordSchema, new SchemaAnnotationProcessor.AnnotationProcessOption());
            RelationshipFieldSpecExtractor relationshipFieldSpecExtractor = new RelationshipFieldSpecExtractor();
            DataSchemaRichContextTraverser relationshipFieldSpecTraverser = new DataSchemaRichContextTraverser(relationshipFieldSpecExtractor);
            relationshipFieldSpecTraverser.traverse(processedRelationshipResult.getResultSchema());
            this._relationshipFieldSpecs.addAll(relationshipFieldSpecExtractor.getSpecs());
            SchemaAnnotationProcessor.SchemaAnnotationProcessResult processedTimeseriesFieldResult = SchemaAnnotationProcessor.process(ImmutableList.of(_timeseriesFiledAnnotationHandler, _timeseriesFieldCollectionHandler), aspectRecordSchema, new SchemaAnnotationProcessor.AnnotationProcessOption());
            TimeseriesFieldSpecExtractor timeseriesFieldSpecExtractor = new TimeseriesFieldSpecExtractor();
            DataSchemaRichContextTraverser timeseriesFieldSpecTraverser = new DataSchemaRichContextTraverser(timeseriesFieldSpecExtractor);
            timeseriesFieldSpecTraverser.traverse(processedTimeseriesFieldResult.getResultSchema());
            SchemaAnnotationProcessor.SchemaAnnotationProcessResult processedTimestampResult = SchemaAnnotationProcessor.process(Collections.singletonList(_urnValidationAnnotationHandler), aspectRecordSchema, new SchemaAnnotationProcessor.AnnotationProcessOption());
            UrnValidationFieldSpecExtractor urnValidationFieldSpecExtractor = new UrnValidationFieldSpecExtractor();
            DataSchemaRichContextTraverser timestampFieldSpecTraverser = new DataSchemaRichContextTraverser(urnValidationFieldSpecExtractor);
            timestampFieldSpecTraverser.traverse(processedTimestampResult.getResultSchema());
            return new AspectSpec(aspectAnnotation, searchableFieldSpecExtractor.getSpecs(), searchScoreFieldSpecExtractor.getSpecs(), relationshipFieldSpecExtractor.getSpecs(), timeseriesFieldSpecExtractor.getTimeseriesFieldSpecs(), timeseriesFieldSpecExtractor.getTimeseriesFieldCollectionSpecs(), searchableRefFieldSpecExtractor.getSpecs(), urnValidationFieldSpecExtractor.getUrnValidationFieldSpecs(), aspectRecordSchema, aspectClass);
        }
        this.failValidation(String.format("Could not build aspect spec for aspect with name %s. Missing @Aspect annotation.", aspectRecordSchema.getName()));
        return null;
    }

    private void validateEntitySpec(EntitySpec entitySpec) {
        if (entitySpec.getKeyAspectSpec() == null) {
            this.failValidation(String.format("Did not find required Key Aspect with name %s in aspects for Entity %s in list of aspects.", entitySpec.getKeyAspectName(), entitySpec.getName()));
        }
        this.validateKeyAspect(entitySpec.getKeyAspectSpec());
        HashSet<String> aspectNames = new HashSet<String>();
        for (AspectSpec aspectSpec : entitySpec.getAspectSpecs()) {
            this.validateAspect(aspectSpec);
            if (aspectNames.contains(aspectSpec.getName())) {
                this.failValidation(String.format("Could not build entity spec for entity with name %s. Found multiple Aspects with the same name %s", entitySpec.getName(), aspectSpec.getName()));
            }
            aspectNames.add(aspectSpec.getName());
        }
        if (this._entityNames.contains(entitySpec.getName().toLowerCase())) {
            this.failValidation(String.format("Could not build entity spec for entity with name %s. Found multiple Entity Snapshots with the same name.", entitySpec.getName()));
        }
        this._entityNames.add(entitySpec.getName().toLowerCase());
    }

    private void validateAspect(AspectSpec aspectSpec) {
        if (aspectSpec.isTimeseries()) {
            DataSchema timestamp;
            if (aspectSpec.getPegasusSchema().contains(TIMESTAMP_FIELD_NAME) && (timestamp = aspectSpec.getPegasusSchema().getField(TIMESTAMP_FIELD_NAME).getType()).getType() == DataSchema.Type.LONG) {
                return;
            }
            this.failValidation(String.format("Aspect %s is of type timeseries but does not include TimeseriesAspectBase", aspectSpec.getName()));
        }
    }

    private RecordDataSchema validateSnapshot(@Nonnull DataSchema entitySnapshotSchema) {
        ArrayDataSchema aspectArray;
        RecordDataSchema entitySnapshotRecordSchema;
        if (entitySnapshotSchema.getType() != DataSchema.Type.RECORD) {
            this.failValidation(String.format("Failed to validate entity snapshot schema of type %s. Schema must be of record type.", entitySnapshotSchema.getType().toString()));
        }
        if ((entitySnapshotRecordSchema = (RecordDataSchema)entitySnapshotSchema).getField(URN_FIELD_NAME) == null || entitySnapshotRecordSchema.getField(URN_FIELD_NAME).getType().getDereferencedType() != DataSchema.Type.STRING) {
            this.failValidation(String.format("Failed to validate entity snapshot schema with name %s. Invalid urn field.", entitySnapshotRecordSchema.getName()));
        }
        if (entitySnapshotRecordSchema.getField(ASPECTS_FIELD_NAME) == null || entitySnapshotRecordSchema.getField(ASPECTS_FIELD_NAME).getType().getDereferencedType() != DataSchema.Type.ARRAY) {
            this.failValidation(String.format("Failed to validate entity snapshot schema with name %s. Invalid aspects field found. 'aspects' should be an array of union type.", entitySnapshotRecordSchema.getName()));
        }
        if ((aspectArray = (ArrayDataSchema)entitySnapshotRecordSchema.getField(ASPECTS_FIELD_NAME).getType().getDereferencedDataSchema()).getItems().getType() != DataSchema.Type.TYPEREF || aspectArray.getItems().getDereferencedType() != DataSchema.Type.UNION) {
            this.failValidation(String.format("Failed to validate entity snapshot schema with name %s. Invalid aspects field field. 'aspects' should be an array of union type.", entitySnapshotRecordSchema.getName()));
        }
        return entitySnapshotRecordSchema;
    }

    private RecordDataSchema validateAspect(@Nonnull DataSchema aspectSchema) {
        if (aspectSchema.getType() != DataSchema.Type.RECORD) {
            this.failValidation(String.format("Failed to validate aspect schema of type %s. Schema must be of record type.", aspectSchema.getType().toString()));
        }
        return (RecordDataSchema)aspectSchema;
    }

    private void validateKeyAspect(@Nonnull AspectSpec keyAspect) {
        RecordDataSchema schema = keyAspect.getPegasusSchema();
        for (RecordDataSchema.Field field : schema.getFields()) {
            if (DataSchema.Type.STRING.equals((Object)field.getType().getDereferencedType()) || DataSchema.Type.ENUM.equals((Object)field.getType().getDereferencedType())) continue;
            this.failValidation(String.format("Failed to validate key aspect nameed %s. Key aspects must only contain fields of STRING or ENUM type. Found %s.", keyAspect.getName(), field.getType().toString()));
        }
    }

    private void failValidation(@Nonnull String message) {
        throw new ModelValidationException(message);
    }

    public static enum AnnotationExtractionMode {
        DEFAULT,
        IGNORE_ASPECT_FIELDS;

    }
}

