/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.Edge;
import com.linkedin.common.urn.DataJobUrn;
import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.common.urn.Urn;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import com.linkedin.metadata.aspect.patch.builder.PatchUtil;
import com.linkedin.metadata.graph.LineageDirection;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import datahub.shaded.jackson.databind.node.TextNode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class DataJobInputOutputPatchBuilder
extends AbstractMultiFieldPatchBuilder<DataJobInputOutputPatchBuilder> {
    private static final String INPUT_DATA_JOB_EDGES_PATH_START = "/inputDatajobEdges/";
    private static final String INPUT_DATASET_EDGES_PATH_START = "/inputDatasetEdges/";
    private static final String OUTPUT_DATASET_EDGES_PATH_START = "/outputDatasetEdges/";
    private static final String INPUT_DATASET_FIELDS_PATH_START = "/inputDatasetFields/";
    private static final String OUTPUT_DATASET_FIELDS_PATH_START = "/outputDatasetFields/";
    private static final String FINE_GRAINED_PATH_START = "/fineGrainedLineages/";

    public DataJobInputOutputPatchBuilder addInputDatajobEdge(@Nonnull DataJobUrn dataJobUrn) {
        ObjectNode value = PatchUtil.createEdgeValue(dataJobUrn);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), INPUT_DATA_JOB_EDGES_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(dataJobUrn.toString()), value));
        return this;
    }

    public DataJobInputOutputPatchBuilder removeInputDatajobEdge(@Nonnull DataJobUrn dataJobUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), INPUT_DATA_JOB_EDGES_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(dataJobUrn.toString()), null));
        return this;
    }

    public DataJobInputOutputPatchBuilder addInputDatasetEdge(@Nonnull DatasetUrn datasetUrn) {
        ObjectNode value = PatchUtil.createEdgeValue(datasetUrn);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), INPUT_DATASET_EDGES_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(datasetUrn.toString()), value));
        return this;
    }

    public DataJobInputOutputPatchBuilder removeInputDatasetEdge(@Nonnull DatasetUrn datasetUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), INPUT_DATASET_EDGES_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(datasetUrn.toString()), null));
        return this;
    }

    public DataJobInputOutputPatchBuilder addOutputDatasetEdge(@Nonnull DatasetUrn datasetUrn) {
        ObjectNode value = PatchUtil.createEdgeValue(datasetUrn);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), OUTPUT_DATASET_EDGES_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(datasetUrn.toString()), value));
        return this;
    }

    public DataJobInputOutputPatchBuilder removeOutputDatasetEdge(@Nonnull DatasetUrn datasetUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), OUTPUT_DATASET_EDGES_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(datasetUrn.toString()), null));
        return this;
    }

    public DataJobInputOutputPatchBuilder addInputDatasetField(@Nonnull Urn urn) {
        TextNode textNode = JsonNodeFactory.instance.textNode(urn.toString());
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), INPUT_DATASET_FIELDS_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(urn.toString()), textNode));
        return this;
    }

    public DataJobInputOutputPatchBuilder removeInputDatasetField(@Nonnull Urn urn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), INPUT_DATASET_FIELDS_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(urn.toString()), null));
        return this;
    }

    public DataJobInputOutputPatchBuilder addOutputDatasetField(@Nonnull Urn urn) {
        TextNode textNode = JsonNodeFactory.instance.textNode(urn.toString());
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), OUTPUT_DATASET_FIELDS_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(urn.toString()), textNode));
        return this;
    }

    public DataJobInputOutputPatchBuilder removeOutputDatasetField(@Nonnull Urn urn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), OUTPUT_DATASET_FIELDS_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(urn.toString()), null));
        return this;
    }

    public DataJobInputOutputPatchBuilder addEdge(@Nonnull Edge edge, @Nonnull LineageDirection direction) {
        ObjectNode value = PatchUtil.createEdgeValue(edge);
        String path = this.getEdgePath(edge, direction);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), path, value));
        return this;
    }

    public DataJobInputOutputPatchBuilder addFineGrainedUpstreamField(@Nonnull Urn upstreamSchemaField, @Nullable Float confidenceScore, @Nonnull String transformationOperation, @Nonnull Urn downstreamSchemaField, @Nullable Urn queryUrn) {
        Float finalConfidenceScore = this.getConfidenceScoreOrDefault(confidenceScore);
        String finalQueryUrn = queryUrn == null || StringUtils.isBlank(queryUrn.toString()) ? "NONE" : queryUrn.toString();
        ObjectNode fineGrainedLineageNode = JsonNodeFactory.instance.objectNode();
        fineGrainedLineageNode.put("confidenceScore", JsonNodeFactory.instance.numberNode(finalConfidenceScore));
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), FINE_GRAINED_PATH_START + transformationOperation + "/" + DataJobInputOutputPatchBuilder.encodeValueUrn(downstreamSchemaField) + "/" + finalQueryUrn + "/" + DataJobInputOutputPatchBuilder.encodeValueUrn(upstreamSchemaField), fineGrainedLineageNode));
        return this;
    }

    private Float getConfidenceScoreOrDefault(@Nullable Float confidenceScore) {
        float finalConfidenceScore = confidenceScore != null && confidenceScore.floatValue() > 0.0f && confidenceScore.floatValue() <= 1.0f ? confidenceScore.floatValue() : 1.0f;
        return Float.valueOf(finalConfidenceScore);
    }

    public DataJobInputOutputPatchBuilder removeFineGrainedUpstreamField(@Nonnull Urn upstreamSchemaField, @Nonnull String transformationOperation, @Nonnull Urn downstreamSchemaField, @Nullable Urn queryUrn) {
        String finalQueryUrn = queryUrn == null || StringUtils.isBlank(queryUrn.toString()) ? "NONE" : queryUrn.toString();
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), FINE_GRAINED_PATH_START + transformationOperation + "/" + DataJobInputOutputPatchBuilder.encodeValueUrn(downstreamSchemaField) + "/" + finalQueryUrn + "/" + DataJobInputOutputPatchBuilder.encodeValueUrn(upstreamSchemaField), null));
        return this;
    }

    public DataJobInputOutputPatchBuilder removeEdge(@Nonnull Edge edge, @Nonnull LineageDirection direction) {
        String path = this.getEdgePath(edge, direction);
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), path, null));
        return this;
    }

    private String getEdgePath(@Nonnull Edge edge, LineageDirection direction) {
        Urn destinationUrn = edge.getDestinationUrn();
        if ("dataset".equals(destinationUrn.getEntityType()) && LineageDirection.UPSTREAM.equals((Object)direction)) {
            return INPUT_DATASET_EDGES_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(destinationUrn.toString());
        }
        if ("dataset".equals(destinationUrn.getEntityType()) && LineageDirection.DOWNSTREAM.equals((Object)direction)) {
            return INPUT_DATASET_EDGES_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(destinationUrn.toString());
        }
        if ("dataJob".equals(destinationUrn.getEntityType()) && LineageDirection.UPSTREAM.equals((Object)direction)) {
            return INPUT_DATA_JOB_EDGES_PATH_START + DataJobInputOutputPatchBuilder.encodeValue(destinationUrn.toString());
        }
        throw new IllegalArgumentException(String.format("Unsupported entity type: %s", destinationUrn.getEntityType()));
    }

    @Override
    protected String getAspectName() {
        return "dataJobInputOutput";
    }

    @Override
    protected String getEntityType() {
        return "dataJob";
    }
}

