/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CorpUserViewsSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Settings related to the 'Views' feature.*/record CorpUserViewsSettings{/**The default View which is selected for the user.\nIf none is chosen, then this value will be left blank.*/defaultView:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}", SchemaFormatType.PDL);
    private Urn _defaultViewField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_DefaultView = SCHEMA.getField("defaultView");

    public CorpUserViewsSettings() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public CorpUserViewsSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDefaultView() {
        if (this._defaultViewField != null) {
            return true;
        }
        return this._map.containsKey("defaultView");
    }

    public void removeDefaultView() {
        this._map.remove("defaultView");
    }

    @Nullable
    public Urn getDefaultView(GetMode mode) {
        return this.getDefaultView();
    }

    @Nullable
    public Urn getDefaultView() {
        if (this._defaultViewField != null) {
            return this._defaultViewField;
        }
        Object __rawValue = this._map.get("defaultView");
        this._defaultViewField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._defaultViewField;
    }

    public CorpUserViewsSettings setDefaultView(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDefaultView(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDefaultView();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "defaultView", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._defaultViewField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "defaultView", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._defaultViewField = value;
            }
        }
        return this;
    }

    public CorpUserViewsSettings setDefaultView(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field defaultView of com.linkedin.identity.CorpUserViewsSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "defaultView", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._defaultViewField = value;
        return this;
    }

    @Override
    public CorpUserViewsSettings clone() throws CloneNotSupportedException {
        CorpUserViewsSettings __clone = (CorpUserViewsSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CorpUserViewsSettings copy() throws CloneNotSupportedException {
        CorpUserViewsSettings __copy = (CorpUserViewsSettings)super.copy();
        __copy._defaultViewField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CorpUserViewsSettings __objectRef;

        private ChangeListener(CorpUserViewsSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "defaultView": {
                    this.__objectRef._defaultViewField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec defaultView() {
            return new PathSpec(this.getPathComponents(), "defaultView");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withDefaultView() {
            this.getDataMap().put("defaultView", 1);
            return this;
        }
    }
}

