/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CorpUserCredentials
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Corp user credentials*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpuserUrn\"],\"name\":\"corpUserCredentials\"}record CorpUserCredentials{/**Salt used to hash password*/salt:string/**Hashed password generated by concatenating salt and password, then hashing*/hashedPassword:string/**Optional token needed to reset a user's password. Can only be set by the admin.*/passwordResetToken:optional string/**When the password reset token expires.*/passwordResetTokenExpirationTimeMillis:optional long}", SchemaFormatType.PDL);
    private String _saltField = null;
    private String _hashedPasswordField = null;
    private String _passwordResetTokenField = null;
    private Long _passwordResetTokenExpirationTimeMillisField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Salt = SCHEMA.getField("salt");
    private static final RecordDataSchema.Field FIELD_HashedPassword = SCHEMA.getField("hashedPassword");
    private static final RecordDataSchema.Field FIELD_PasswordResetToken = SCHEMA.getField("passwordResetToken");
    private static final RecordDataSchema.Field FIELD_PasswordResetTokenExpirationTimeMillis = SCHEMA.getField("passwordResetTokenExpirationTimeMillis");

    public CorpUserCredentials() {
        super(new DataMap(6, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public CorpUserCredentials(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSalt() {
        if (this._saltField != null) {
            return true;
        }
        return this._map.containsKey("salt");
    }

    public void removeSalt() {
        this._map.remove("salt");
    }

    @Nullable
    public String getSalt(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSalt();
            }
            case DEFAULT: 
            case NULL: {
                if (this._saltField != null) {
                    return this._saltField;
                }
                Object __rawValue = this._map.get("salt");
                this._saltField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._saltField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getSalt() {
        if (this._saltField != null) {
            return this._saltField;
        }
        Object __rawValue = this._map.get("salt");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("salt");
        }
        this._saltField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._saltField;
    }

    public CorpUserCredentials setSalt(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSalt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field salt of com.linkedin.identity.CorpUserCredentials");
                }
                CheckedUtil.putWithoutChecking(this._map, "salt", value);
                this._saltField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSalt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "salt", value);
                this._saltField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "salt", value);
                this._saltField = value;
            }
        }
        return this;
    }

    public CorpUserCredentials setSalt(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field salt of com.linkedin.identity.CorpUserCredentials to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "salt", value);
        this._saltField = value;
        return this;
    }

    public boolean hasHashedPassword() {
        if (this._hashedPasswordField != null) {
            return true;
        }
        return this._map.containsKey("hashedPassword");
    }

    public void removeHashedPassword() {
        this._map.remove("hashedPassword");
    }

    @Nullable
    public String getHashedPassword(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getHashedPassword();
            }
            case DEFAULT: 
            case NULL: {
                if (this._hashedPasswordField != null) {
                    return this._hashedPasswordField;
                }
                Object __rawValue = this._map.get("hashedPassword");
                this._hashedPasswordField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._hashedPasswordField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getHashedPassword() {
        if (this._hashedPasswordField != null) {
            return this._hashedPasswordField;
        }
        Object __rawValue = this._map.get("hashedPassword");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("hashedPassword");
        }
        this._hashedPasswordField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._hashedPasswordField;
    }

    public CorpUserCredentials setHashedPassword(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHashedPassword(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field hashedPassword of com.linkedin.identity.CorpUserCredentials");
                }
                CheckedUtil.putWithoutChecking(this._map, "hashedPassword", value);
                this._hashedPasswordField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHashedPassword();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "hashedPassword", value);
                this._hashedPasswordField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "hashedPassword", value);
                this._hashedPasswordField = value;
            }
        }
        return this;
    }

    public CorpUserCredentials setHashedPassword(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field hashedPassword of com.linkedin.identity.CorpUserCredentials to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "hashedPassword", value);
        this._hashedPasswordField = value;
        return this;
    }

    public boolean hasPasswordResetToken() {
        if (this._passwordResetTokenField != null) {
            return true;
        }
        return this._map.containsKey("passwordResetToken");
    }

    public void removePasswordResetToken() {
        this._map.remove("passwordResetToken");
    }

    @Nullable
    public String getPasswordResetToken(GetMode mode) {
        return this.getPasswordResetToken();
    }

    @Nullable
    public String getPasswordResetToken() {
        if (this._passwordResetTokenField != null) {
            return this._passwordResetTokenField;
        }
        Object __rawValue = this._map.get("passwordResetToken");
        this._passwordResetTokenField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._passwordResetTokenField;
    }

    public CorpUserCredentials setPasswordResetToken(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPasswordResetToken(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePasswordResetToken();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "passwordResetToken", value);
                this._passwordResetTokenField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "passwordResetToken", value);
                this._passwordResetTokenField = value;
            }
        }
        return this;
    }

    public CorpUserCredentials setPasswordResetToken(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field passwordResetToken of com.linkedin.identity.CorpUserCredentials to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "passwordResetToken", value);
        this._passwordResetTokenField = value;
        return this;
    }

    public boolean hasPasswordResetTokenExpirationTimeMillis() {
        if (this._passwordResetTokenExpirationTimeMillisField != null) {
            return true;
        }
        return this._map.containsKey("passwordResetTokenExpirationTimeMillis");
    }

    public void removePasswordResetTokenExpirationTimeMillis() {
        this._map.remove("passwordResetTokenExpirationTimeMillis");
    }

    @Nullable
    public Long getPasswordResetTokenExpirationTimeMillis(GetMode mode) {
        return this.getPasswordResetTokenExpirationTimeMillis();
    }

    @Nullable
    public Long getPasswordResetTokenExpirationTimeMillis() {
        if (this._passwordResetTokenExpirationTimeMillisField != null) {
            return this._passwordResetTokenExpirationTimeMillisField;
        }
        Object __rawValue = this._map.get("passwordResetTokenExpirationTimeMillis");
        this._passwordResetTokenExpirationTimeMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._passwordResetTokenExpirationTimeMillisField;
    }

    public CorpUserCredentials setPasswordResetTokenExpirationTimeMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPasswordResetTokenExpirationTimeMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePasswordResetTokenExpirationTimeMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "passwordResetTokenExpirationTimeMillis", DataTemplateUtil.coerceLongInput(value));
                this._passwordResetTokenExpirationTimeMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "passwordResetTokenExpirationTimeMillis", DataTemplateUtil.coerceLongInput(value));
                this._passwordResetTokenExpirationTimeMillisField = value;
            }
        }
        return this;
    }

    public CorpUserCredentials setPasswordResetTokenExpirationTimeMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field passwordResetTokenExpirationTimeMillis of com.linkedin.identity.CorpUserCredentials to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "passwordResetTokenExpirationTimeMillis", DataTemplateUtil.coerceLongInput(value));
        this._passwordResetTokenExpirationTimeMillisField = value;
        return this;
    }

    public CorpUserCredentials setPasswordResetTokenExpirationTimeMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "passwordResetTokenExpirationTimeMillis", DataTemplateUtil.coerceLongInput(value));
        this._passwordResetTokenExpirationTimeMillisField = value;
        return this;
    }

    @Override
    public CorpUserCredentials clone() throws CloneNotSupportedException {
        CorpUserCredentials __clone = (CorpUserCredentials)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CorpUserCredentials copy() throws CloneNotSupportedException {
        CorpUserCredentials __copy = (CorpUserCredentials)super.copy();
        __copy._saltField = null;
        __copy._passwordResetTokenExpirationTimeMillisField = null;
        __copy._hashedPasswordField = null;
        __copy._passwordResetTokenField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CorpUserCredentials __objectRef;

        private ChangeListener(CorpUserCredentials reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "salt": {
                    this.__objectRef._saltField = null;
                    break;
                }
                case "passwordResetTokenExpirationTimeMillis": {
                    this.__objectRef._passwordResetTokenExpirationTimeMillisField = null;
                    break;
                }
                case "hashedPassword": {
                    this.__objectRef._hashedPasswordField = null;
                    break;
                }
                case "passwordResetToken": {
                    this.__objectRef._passwordResetTokenField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec salt() {
            return new PathSpec(this.getPathComponents(), "salt");
        }

        public PathSpec hashedPassword() {
            return new PathSpec(this.getPathComponents(), "hashedPassword");
        }

        public PathSpec passwordResetToken() {
            return new PathSpec(this.getPathComponents(), "passwordResetToken");
        }

        public PathSpec passwordResetTokenExpirationTimeMillis() {
            return new PathSpec(this.getPathComponents(), "passwordResetTokenExpirationTimeMillis");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withSalt() {
            this.getDataMap().put("salt", 1);
            return this;
        }

        public ProjectionMask withHashedPassword() {
            this.getDataMap().put("hashedPassword", 1);
            return this;
        }

        public ProjectionMask withPasswordResetToken() {
            this.getDataMap().put("passwordResetToken", 1);
            return this;
        }

        public ProjectionMask withPasswordResetTokenExpirationTimeMillis() {
            this.getDataMap().put("passwordResetTokenExpirationTimeMillis", 1);
            return this;
        }
    }
}

