/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.execution;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.execution.ExecutionRequestSource;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExecutionRequestInput
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.execution/**An request to execution some remote logic or action.\nTODO: Determine who is responsible for emitting execution request success or failure. Executor?*/@Aspect.name=\"dataHubExecutionRequestInput\"record ExecutionRequestInput{/**The name of the task to execute, for example RUN_INGEST*/task:string/**Arguments provided to the task*/args:map[string,string]/**Advanced: specify a specific executor to route the request to. If none is provided, a \"default\" executor is used.*/@Searchable={\"fieldName\":\"executorId\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false}executorId:string/**Source which created the execution request*/source:record ExecutionRequestSource{/**The type of the execution request source, e.g. INGESTION_SOURCE*/type:string/**The urn of the ingestion source associated with the ingestion request. Present if type is INGESTION_SOURCE*/@Relationship={\"entityTypes\":[\"dataHubIngestionSource\"],\"name\":\"ingestionSource\"}@Searchable={\"fieldName\":\"ingestionSource\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false}ingestionSource:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}/**Time at which the execution request input was created*/@Searchable={\"fieldName\":\"requestTimeMs\",\"fieldType\":\"COUNT\",\"queryByDefault\":false}requestedAt:long/**Urn of the actor who created this execution request.*/@Searchable.fieldType=\"URN\"actorUrn:optional com.linkedin.common.Urn}", SchemaFormatType.PDL);
    private String _taskField = null;
    private StringMap _argsField = null;
    private String _executorIdField = null;
    private ExecutionRequestSource _sourceField = null;
    private Long _requestedAtField = null;
    private Urn _actorUrnField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Task = SCHEMA.getField("task");
    private static final RecordDataSchema.Field FIELD_Args = SCHEMA.getField("args");
    private static final RecordDataSchema.Field FIELD_ExecutorId = SCHEMA.getField("executorId");
    private static final RecordDataSchema.Field FIELD_Source = SCHEMA.getField("source");
    private static final RecordDataSchema.Field FIELD_RequestedAt = SCHEMA.getField("requestedAt");
    private static final RecordDataSchema.Field FIELD_ActorUrn = SCHEMA.getField("actorUrn");

    public ExecutionRequestInput() {
        super(new DataMap(8, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public ExecutionRequestInput(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTask() {
        if (this._taskField != null) {
            return true;
        }
        return this._map.containsKey("task");
    }

    public void removeTask() {
        this._map.remove("task");
    }

    @Nullable
    public String getTask(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTask();
            }
            case DEFAULT: 
            case NULL: {
                if (this._taskField != null) {
                    return this._taskField;
                }
                Object __rawValue = this._map.get("task");
                this._taskField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._taskField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTask() {
        if (this._taskField != null) {
            return this._taskField;
        }
        Object __rawValue = this._map.get("task");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("task");
        }
        this._taskField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._taskField;
    }

    public ExecutionRequestInput setTask(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTask(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field task of com.linkedin.execution.ExecutionRequestInput");
                }
                CheckedUtil.putWithoutChecking(this._map, "task", value);
                this._taskField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTask();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "task", value);
                this._taskField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "task", value);
                this._taskField = value;
            }
        }
        return this;
    }

    public ExecutionRequestInput setTask(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field task of com.linkedin.execution.ExecutionRequestInput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "task", value);
        this._taskField = value;
        return this;
    }

    public boolean hasArgs() {
        if (this._argsField != null) {
            return true;
        }
        return this._map.containsKey("args");
    }

    public void removeArgs() {
        this._map.remove("args");
    }

    @Nullable
    public StringMap getArgs(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getArgs();
            }
            case DEFAULT: 
            case NULL: {
                if (this._argsField != null) {
                    return this._argsField;
                }
                Object __rawValue = this._map.get("args");
                this._argsField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._argsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getArgs() {
        if (this._argsField != null) {
            return this._argsField;
        }
        Object __rawValue = this._map.get("args");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("args");
        }
        this._argsField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._argsField;
    }

    public ExecutionRequestInput setArgs(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setArgs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field args of com.linkedin.execution.ExecutionRequestInput");
                }
                CheckedUtil.putWithoutChecking(this._map, "args", value.data());
                this._argsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeArgs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "args", value.data());
                this._argsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "args", value.data());
                this._argsField = value;
            }
        }
        return this;
    }

    public ExecutionRequestInput setArgs(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field args of com.linkedin.execution.ExecutionRequestInput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "args", value.data());
        this._argsField = value;
        return this;
    }

    public boolean hasExecutorId() {
        if (this._executorIdField != null) {
            return true;
        }
        return this._map.containsKey("executorId");
    }

    public void removeExecutorId() {
        this._map.remove("executorId");
    }

    @Nullable
    public String getExecutorId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getExecutorId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._executorIdField != null) {
                    return this._executorIdField;
                }
                Object __rawValue = this._map.get("executorId");
                this._executorIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._executorIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getExecutorId() {
        if (this._executorIdField != null) {
            return this._executorIdField;
        }
        Object __rawValue = this._map.get("executorId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("executorId");
        }
        this._executorIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._executorIdField;
    }

    public ExecutionRequestInput setExecutorId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExecutorId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field executorId of com.linkedin.execution.ExecutionRequestInput");
                }
                CheckedUtil.putWithoutChecking(this._map, "executorId", value);
                this._executorIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExecutorId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "executorId", value);
                this._executorIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "executorId", value);
                this._executorIdField = value;
            }
        }
        return this;
    }

    public ExecutionRequestInput setExecutorId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field executorId of com.linkedin.execution.ExecutionRequestInput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "executorId", value);
        this._executorIdField = value;
        return this;
    }

    public boolean hasSource() {
        if (this._sourceField != null) {
            return true;
        }
        return this._map.containsKey("source");
    }

    public void removeSource() {
        this._map.remove("source");
    }

    @Nullable
    public ExecutionRequestSource getSource(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSource();
            }
            case DEFAULT: 
            case NULL: {
                if (this._sourceField != null) {
                    return this._sourceField;
                }
                Object __rawValue = this._map.get("source");
                this._sourceField = __rawValue == null ? null : new ExecutionRequestSource(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._sourceField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ExecutionRequestSource getSource() {
        if (this._sourceField != null) {
            return this._sourceField;
        }
        Object __rawValue = this._map.get("source");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("source");
        }
        this._sourceField = __rawValue == null ? null : new ExecutionRequestSource(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._sourceField;
    }

    public ExecutionRequestInput setSource(@Nullable ExecutionRequestSource value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSource(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field source of com.linkedin.execution.ExecutionRequestInput");
                }
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSource();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
            }
        }
        return this;
    }

    public ExecutionRequestInput setSource(@Nonnull ExecutionRequestSource value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field source of com.linkedin.execution.ExecutionRequestInput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "source", value.data());
        this._sourceField = value;
        return this;
    }

    public boolean hasRequestedAt() {
        if (this._requestedAtField != null) {
            return true;
        }
        return this._map.containsKey("requestedAt");
    }

    public void removeRequestedAt() {
        this._map.remove("requestedAt");
    }

    @Nullable
    public Long getRequestedAt(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRequestedAt();
            }
            case DEFAULT: 
            case NULL: {
                if (this._requestedAtField != null) {
                    return this._requestedAtField;
                }
                Object __rawValue = this._map.get("requestedAt");
                this._requestedAtField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._requestedAtField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getRequestedAt() {
        if (this._requestedAtField != null) {
            return this._requestedAtField;
        }
        Object __rawValue = this._map.get("requestedAt");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("requestedAt");
        }
        this._requestedAtField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._requestedAtField;
    }

    public ExecutionRequestInput setRequestedAt(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRequestedAt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field requestedAt of com.linkedin.execution.ExecutionRequestInput");
                }
                CheckedUtil.putWithoutChecking(this._map, "requestedAt", DataTemplateUtil.coerceLongInput(value));
                this._requestedAtField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRequestedAt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "requestedAt", DataTemplateUtil.coerceLongInput(value));
                this._requestedAtField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "requestedAt", DataTemplateUtil.coerceLongInput(value));
                this._requestedAtField = value;
            }
        }
        return this;
    }

    public ExecutionRequestInput setRequestedAt(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field requestedAt of com.linkedin.execution.ExecutionRequestInput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "requestedAt", DataTemplateUtil.coerceLongInput(value));
        this._requestedAtField = value;
        return this;
    }

    public ExecutionRequestInput setRequestedAt(long value) {
        CheckedUtil.putWithoutChecking(this._map, "requestedAt", DataTemplateUtil.coerceLongInput(value));
        this._requestedAtField = value;
        return this;
    }

    public boolean hasActorUrn() {
        if (this._actorUrnField != null) {
            return true;
        }
        return this._map.containsKey("actorUrn");
    }

    public void removeActorUrn() {
        this._map.remove("actorUrn");
    }

    @Nullable
    public Urn getActorUrn(GetMode mode) {
        return this.getActorUrn();
    }

    @Nullable
    public Urn getActorUrn() {
        if (this._actorUrnField != null) {
            return this._actorUrnField;
        }
        Object __rawValue = this._map.get("actorUrn");
        this._actorUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._actorUrnField;
    }

    public ExecutionRequestInput setActorUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActorUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActorUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "actorUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "actorUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorUrnField = value;
            }
        }
        return this;
    }

    public ExecutionRequestInput setActorUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field actorUrn of com.linkedin.execution.ExecutionRequestInput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "actorUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._actorUrnField = value;
        return this;
    }

    @Override
    public ExecutionRequestInput clone() throws CloneNotSupportedException {
        ExecutionRequestInput __clone = (ExecutionRequestInput)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ExecutionRequestInput copy() throws CloneNotSupportedException {
        ExecutionRequestInput __copy = (ExecutionRequestInput)super.copy();
        __copy._argsField = null;
        __copy._actorUrnField = null;
        __copy._taskField = null;
        __copy._executorIdField = null;
        __copy._requestedAtField = null;
        __copy._sourceField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ExecutionRequestInput __objectRef;

        private ChangeListener(ExecutionRequestInput reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "args": {
                    this.__objectRef._argsField = null;
                    break;
                }
                case "actorUrn": {
                    this.__objectRef._actorUrnField = null;
                    break;
                }
                case "task": {
                    this.__objectRef._taskField = null;
                    break;
                }
                case "executorId": {
                    this.__objectRef._executorIdField = null;
                    break;
                }
                case "requestedAt": {
                    this.__objectRef._requestedAtField = null;
                    break;
                }
                case "source": {
                    this.__objectRef._sourceField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec task() {
            return new PathSpec(this.getPathComponents(), "task");
        }

        public PathSpec args() {
            return new PathSpec(this.getPathComponents(), "args");
        }

        public PathSpec executorId() {
            return new PathSpec(this.getPathComponents(), "executorId");
        }

        public ExecutionRequestSource.Fields source() {
            return new ExecutionRequestSource.Fields(this.getPathComponents(), "source");
        }

        public PathSpec requestedAt() {
            return new PathSpec(this.getPathComponents(), "requestedAt");
        }

        public PathSpec actorUrn() {
            return new PathSpec(this.getPathComponents(), "actorUrn");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private ExecutionRequestSource.ProjectionMask _sourceMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withTask() {
            this.getDataMap().put("task", 1);
            return this;
        }

        public ProjectionMask withArgs() {
            this.getDataMap().put("args", 1);
            return this;
        }

        public ProjectionMask withExecutorId() {
            this.getDataMap().put("executorId", 1);
            return this;
        }

        public ProjectionMask withSource(Function<ExecutionRequestSource.ProjectionMask, ExecutionRequestSource.ProjectionMask> nestedMask) {
            this._sourceMask = nestedMask.apply(this._sourceMask == null ? ExecutionRequestSource.createMask() : this._sourceMask);
            this.getDataMap().put("source", this._sourceMask.getDataMap());
            return this;
        }

        public ProjectionMask withSource() {
            this._sourceMask = null;
            this.getDataMap().put("source", 1);
            return this;
        }

        public ProjectionMask withRequestedAt() {
            this.getDataMap().put("requestedAt", 1);
            return this;
        }

        public ProjectionMask withActorUrn() {
            this.getDataMap().put("actorUrn", 1);
            return this;
        }
    }
}

