/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.common.urn.DatasetFieldUrn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import java.util.List;

public class DatasetFieldUpstream
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.common/**Standardized dataset field information identifier.*/@deprecated=\"use SchemaFieldPath and represent as generic Urn instead\"@java.class=\"com.linkedin.common.urn.DatasetFieldUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset field information identifier\",\"entityType\":\"datasetField\",\"fields\":[{\"doc\":\"Dataset that this dataset field belongs to.\",\"name\":\"dataset\",\"type\":\"com.linkedin.common.urn.DatasetUrn\"},{\"doc\":\"Dataset field path\",\"maxLength\":500,\"name\":\"fieldPath\",\"type\":\"string\"}],\"maxLength\":807,\"name\":\"DatasetField\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetFieldUrn=string}]", SchemaFormatType.PDL);
    private DatasetFieldUrn _datasetFieldUrnMember = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_DatasetFieldUrn = SCHEMA.getTypeByMemberKey("string");
    public static final String MEMBERKEY_DatasetFieldUrn = "string";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public DatasetFieldUpstream() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DatasetFieldUpstream(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static DatasetFieldUpstream create(DatasetFieldUrn value) {
        DatasetFieldUpstream newUnion = new DatasetFieldUpstream();
        newUnion.setDatasetFieldUrn(value);
        return newUnion;
    }

    public boolean isDatasetFieldUrn() {
        return this.memberIs(MEMBERKEY_DatasetFieldUrn);
    }

    public DatasetFieldUrn getDatasetFieldUrn() {
        this.checkNotNull();
        if (this._datasetFieldUrnMember != null) {
            return this._datasetFieldUrnMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_DatasetFieldUrn);
        this._datasetFieldUrnMember = DataTemplateUtil.coerceCustomOutput(__rawValue, DatasetFieldUrn.class);
        return this._datasetFieldUrnMember;
    }

    public void setDatasetFieldUrn(DatasetFieldUrn value) {
        this.checkNotNull();
        this._map.clear();
        this._datasetFieldUrnMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DatasetFieldUrn, DataTemplateUtil.coerceCustomInput(value, DatasetFieldUrn.class));
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public DatasetFieldUpstream clone() throws CloneNotSupportedException {
        DatasetFieldUpstream __clone = (DatasetFieldUpstream)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatasetFieldUpstream copy() throws CloneNotSupportedException {
        DatasetFieldUpstream __copy = (DatasetFieldUpstream)super.copy();
        __copy._datasetFieldUrnMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    static {
        Custom.initializeCustomClass(DatasetFieldUrn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatasetFieldUpstream __objectRef;

        private ChangeListener(DatasetFieldUpstream reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "string": {
                    this.__objectRef._datasetFieldUrnMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withDatasetFieldUrn() {
            this.getDataMap().put(DatasetFieldUpstream.MEMBERKEY_DatasetFieldUrn, 1);
            return this;
        }
    }

    @Deprecated
    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Upstreams of a dataset field.*/@deprecated=\"refer FineGrainedLineage for alternative representation\"typeref DatasetFieldUpstream=union[{namespace com.linkedin.common/**Standardized dataset field information identifier.*/@deprecated=\"use SchemaFieldPath and represent as generic Urn instead\"@java.class=\"com.linkedin.common.urn.DatasetFieldUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset field information identifier\",\"entityType\":\"datasetField\",\"fields\":[{\"doc\":\"Dataset that this dataset field belongs to.\",\"name\":\"dataset\",\"type\":\"com.linkedin.common.urn.DatasetUrn\"},{\"doc\":\"Dataset field path\",\"maxLength\":500,\"name\":\"fieldPath\",\"type\":\"string\"}],\"maxLength\":807,\"name\":\"DatasetField\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetFieldUrn=string}]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec DatasetFieldUrn() {
            return new PathSpec(this.getPathComponents(), DatasetFieldUpstream.MEMBERKEY_DatasetFieldUrn);
        }
    }
}

