/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.datacontract;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.datacontract.DataQualityContract;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class DataQualityContractArray
extends WrappingArrayTemplate<DataQualityContract> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.datacontract/**A data quality contract pertaining to a physical data asset\nData Quality contracts are used to make assertions about data quality metrics for a physical data asset*/record DataQualityContract{/**The assertion representing the Data Quality contract.\nE.g. a table or column-level assertion.*/@Relationship={\"entityTypes\":[\"assertion\"],\"name\":\"IncludesDataQualityAssertion\"}assertion:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}}]", SchemaFormatType.PDL);

    public DataQualityContractArray() {
        this(new DataList());
    }

    public DataQualityContractArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public DataQualityContractArray(Collection<DataQualityContract> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public DataQualityContractArray(DataList data) {
        super(data, SCHEMA, DataQualityContract.class);
    }

    public DataQualityContractArray(DataQualityContract first, DataQualityContract ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public DataQualityContractArray clone() throws CloneNotSupportedException {
        DataQualityContractArray __clone = (DataQualityContractArray)super.clone();
        return __clone;
    }

    @Override
    public DataQualityContractArray copy() throws CloneNotSupportedException {
        DataQualityContractArray __copy = (DataQualityContractArray)super.copy();
        return __copy;
    }

    @Override
    protected DataQualityContract coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new DataQualityContract(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataQualityContract.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<DataQualityContract.ProjectionMask, DataQualityContract.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? DataQualityContract.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DataQualityContract.Fields items() {
            return new DataQualityContract.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

