/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;

public class FieldDef<T> {
    private final String _name;
    private final Class<T> _type;
    private final DataSchema _dataSchema;
    private final Class<?> _dataClass;
    private final RecordDataSchema.Field _field;
    private Integer _hashCode;

    public FieldDef(String name, Class<T> type) {
        this(name, type, DataTemplateUtil.getSchema(type));
    }

    public FieldDef(String name, Class<T> type, DataSchema dataSchema) {
        this._name = name;
        this._type = type;
        this._dataSchema = dataSchema;
        this._dataClass = DataSchemaUtil.getDataClassFromSchema(this._dataSchema);
        StringBuilder errorMessageBuilder = new StringBuilder();
        this._field = new RecordDataSchema.Field(this._dataSchema);
        this._field.setName(this._name, errorMessageBuilder);
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    public Class<?> getDataClass() {
        return this._dataClass;
    }

    public RecordDataSchema.Field getField() {
        return this._field;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FieldDef{_name='");
        stringBuilder.append(this._name);
        stringBuilder.append("', _type=");
        stringBuilder.append(this._type.getName());
        if (this._dataSchema != null) {
            stringBuilder.append(", _dataSchema=");
            stringBuilder.append(this._dataSchema.toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof FieldDef) {
            FieldDef other = (FieldDef)object;
            boolean dataSchemaEquals = this._dataSchema == null ? other._dataSchema == null : this._dataSchema.equals(other._dataSchema);
            return this._name.equals(other._name) && this._type.equals(other._type) && dataSchemaEquals;
        }
        return false;
    }

    public int hashCode() {
        if (this._hashCode == null) {
            this._hashCode = this.computeHashCode();
        }
        return this._hashCode;
    }

    private int computeHashCode() {
        return 13 * this._name.hashCode() + 17 * this._type.hashCode() + 23 * (this._dataSchema == null ? 1 : this._dataSchema.hashCode());
    }
}

