/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectMapTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.util.Map;

public final class DoubleMap
extends DirectMapTemplate<Double> {
    private static final MapDataSchema SCHEMA = (MapDataSchema)DataTemplateUtil.parseSchema("{ \"type\" : \"map\", \"values\" : \"double\" }");

    public DoubleMap() {
        this(new DataMap());
    }

    public DoubleMap(int initialCapacity) {
        this(new DataMap(initialCapacity));
    }

    public DoubleMap(int initialCapacity, float loadFactor) {
        this(new DataMap(initialCapacity, loadFactor));
    }

    public DoubleMap(Map<String, Double> m4) {
        this(DoubleMap.newDataMapOfSize(m4.size()));
        this.putAll(m4);
    }

    public DoubleMap(DataMap map) {
        super(map, SCHEMA, Double.class, Double.class);
    }

    @Override
    public DoubleMap clone() throws CloneNotSupportedException {
        return (DoubleMap)super.clone();
    }

    @Override
    public DoubleMap copy() throws CloneNotSupportedException {
        return (DoubleMap)super.copy();
    }

    @Override
    protected Object coerceInput(Double object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return DataTemplateUtil.coerceDoubleInput(object);
    }

    @Override
    protected Double coerceOutput(Object object) throws TemplateOutputCastException {
        return DataTemplateUtil.coerceDoubleOutput(object);
    }
}

