/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.annotation.SchemaAnnotationHandler;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import com.linkedin.data.schema.annotation.TraverserContext;
import java.util.ArrayDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaAnnotationValidationVisitor
implements SchemaVisitor {
    private final SchemaVisitorTraversalResult _schemaVisitorTraversalResult = new SchemaVisitorTraversalResult();
    private final SchemaAnnotationHandler _schemaAnnotationHandler;
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaAnnotationValidationVisitor.class);

    public SchemaAnnotationValidationVisitor(SchemaAnnotationHandler schemaAnnotationHandler) {
        this._schemaAnnotationHandler = schemaAnnotationHandler;
    }

    @Override
    public void callbackOnContext(TraverserContext context, DataSchemaTraverse.Order order) {
        if (order == DataSchemaTraverse.Order.POST_ORDER) {
            return;
        }
        DataSchema schema = context.getCurrentSchema();
        SchemaAnnotationHandler.ValidationMetaData metaData = new SchemaAnnotationHandler.ValidationMetaData();
        metaData.setDataSchema(context.getCurrentSchema());
        metaData.setPathToSchema(new ArrayDeque<String>(context.getTraversePath()));
        SchemaAnnotationHandler.AnnotationValidationResult annotationValidationResult = this._schemaAnnotationHandler.validate(schema.getResolvedProperties(), metaData);
        if (!annotationValidationResult.isValid()) {
            this.getSchemaVisitorTraversalResult().addMessages(context.getSchemaPathSpec(), annotationValidationResult.getMessages());
        }
    }

    @Override
    public SchemaVisitor.VisitorContext getInitialVisitorContext() {
        return new SchemaVisitor.VisitorContext(){};
    }

    @Override
    public SchemaVisitorTraversalResult getSchemaVisitorTraversalResult() {
        return this._schemaVisitorTraversalResult;
    }

    public SchemaAnnotationHandler getSchemaAnnotationHandler() {
        return this._schemaAnnotationHandler;
    }
}

