/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.connection;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubJsonConnection
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.connection/**A set of connection details consisting of an encrypted JSON blob.*/record DataHubJsonConnection{/**The encrypted JSON connection details.*/encryptedBlob:string}", SchemaFormatType.PDL);
    private String _encryptedBlobField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_EncryptedBlob = SCHEMA.getField("encryptedBlob");

    public DataHubJsonConnection() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubJsonConnection(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEncryptedBlob() {
        if (this._encryptedBlobField != null) {
            return true;
        }
        return this._map.containsKey("encryptedBlob");
    }

    public void removeEncryptedBlob() {
        this._map.remove("encryptedBlob");
    }

    @Nullable
    public String getEncryptedBlob(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEncryptedBlob();
            }
            case DEFAULT: 
            case NULL: {
                if (this._encryptedBlobField != null) {
                    return this._encryptedBlobField;
                }
                Object __rawValue = this._map.get("encryptedBlob");
                this._encryptedBlobField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._encryptedBlobField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getEncryptedBlob() {
        if (this._encryptedBlobField != null) {
            return this._encryptedBlobField;
        }
        Object __rawValue = this._map.get("encryptedBlob");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("encryptedBlob");
        }
        this._encryptedBlobField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._encryptedBlobField;
    }

    public DataHubJsonConnection setEncryptedBlob(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEncryptedBlob(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field encryptedBlob of com.linkedin.connection.DataHubJsonConnection");
                }
                CheckedUtil.putWithoutChecking(this._map, "encryptedBlob", value);
                this._encryptedBlobField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEncryptedBlob();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "encryptedBlob", value);
                this._encryptedBlobField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "encryptedBlob", value);
                this._encryptedBlobField = value;
            }
        }
        return this;
    }

    public DataHubJsonConnection setEncryptedBlob(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field encryptedBlob of com.linkedin.connection.DataHubJsonConnection to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "encryptedBlob", value);
        this._encryptedBlobField = value;
        return this;
    }

    @Override
    public DataHubJsonConnection clone() throws CloneNotSupportedException {
        DataHubJsonConnection __clone = (DataHubJsonConnection)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubJsonConnection copy() throws CloneNotSupportedException {
        DataHubJsonConnection __copy = (DataHubJsonConnection)super.copy();
        __copy._encryptedBlobField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubJsonConnection __objectRef;

        private ChangeListener(DataHubJsonConnection reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "encryptedBlob": {
                    this.__objectRef._encryptedBlobField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec encryptedBlob() {
            return new PathSpec(this.getPathComponents(), "encryptedBlob");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withEncryptedBlob() {
            this.getDataMap().put("encryptedBlob", 1);
            return this;
        }
    }
}

