/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.FabricType;
import com.linkedin.common.urn.CorpuserUrn;
import com.linkedin.common.urn.DataPlatformUrn;
import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.common.urn.Urn;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UrnUtils {
    private static final CorpuserUrn UNKNOWN_ACTOR_URN = new CorpuserUrn("unknown");

    private UrnUtils() {
    }

    @Nonnull
    public static DatasetUrn toDatasetUrn(@Nonnull String platformName, @Nonnull String datasetName, @Nonnull String origin) {
        return new DatasetUrn(new DataPlatformUrn(platformName), datasetName, FabricType.valueOf(origin.toUpperCase()));
    }

    public static Urn getUrn(String urnStr) {
        try {
            return Urn.createFromString(urnStr);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("Failed to retrieve entity with urn %s, invalid urn", urnStr));
        }
    }

    @Nonnull
    public static AuditStamp getAuditStamp(@Nullable Urn actor) {
        return new AuditStamp().setActor(UrnUtils.getActorOrDefault(actor));
    }

    @Nonnull
    public static Urn getActorOrDefault(@Nullable Urn actor) {
        return actor != null ? actor : UNKNOWN_ACTOR_URN;
    }
}

