/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.TupleKey;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DirectCoercer;
import com.linkedin.data.template.TemplateOutputCastException;
import java.net.URISyntaxException;

public class NotebookUrn
extends Urn {
    public static final String ENTITY_TYPE = "notebook";
    private final String _notebookTool;
    private final String _notebookId;

    public NotebookUrn(String notebookTool, String notebookId) {
        super(ENTITY_TYPE, TupleKey.create(notebookTool, notebookId));
        this._notebookTool = notebookTool;
        this._notebookId = notebookId;
    }

    public String getNotebookToolEntity() {
        return this._notebookTool;
    }

    public String getNotebookIdEntity() {
        return this._notebookId;
    }

    public static NotebookUrn createFromString(String rawUrn) throws URISyntaxException {
        return NotebookUrn.createFromUrn(Urn.createFromString(rawUrn));
    }

    public static NotebookUrn createFromUrn(Urn urn) throws URISyntaxException {
        if (!"li".equals(urn.getNamespace())) {
            throw new URISyntaxException(urn.toString(), "Urn namespace type should be 'li'.");
        }
        if (!ENTITY_TYPE.equals(urn.getEntityType())) {
            throw new URISyntaxException(urn.toString(), "Urn entity type should be 'notebook'.");
        }
        TupleKey key = urn.getEntityKey();
        if (key.size() != 2) {
            throw new URISyntaxException(urn.toString(), "Invalid number of keys.");
        }
        try {
            return new NotebookUrn(key.getAs(0, String.class), key.getAs(1, String.class));
        }
        catch (Exception e) {
            throw new URISyntaxException(urn.toString(), "Invalid URN Parameter: '" + e.getMessage());
        }
    }

    public static NotebookUrn deserialize(String rawUrn) throws URISyntaxException {
        return NotebookUrn.createFromString(rawUrn);
    }

    static {
        Custom.registerCoercer(new DirectCoercer<NotebookUrn>(){

            @Override
            public Object coerceInput(NotebookUrn object) throws ClassCastException {
                return object.toString();
            }

            @Override
            public NotebookUrn coerceOutput(Object object) throws TemplateOutputCastException {
                try {
                    return NotebookUrn.createFromString((String)object);
                }
                catch (URISyntaxException e) {
                    throw new TemplateOutputCastException("Invalid URN syntax: " + e.getMessage(), e);
                }
            }
        }, NotebookUrn.class);
    }
}

