/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Edge
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**A common structure to represent all edges to entities when used inside aspects as collections\nThis ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically.\n*/record Edge{/**Urn of the source of this relationship edge.\nIf not specified, assumed to be the entity that this aspect belongs to.*/sourceUrn:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**Urn of the destination of this relationship edge.*/destinationUrn:Urn/**Audit stamp containing who created this relationship edge and when*/created:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional AuditStamp/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]}", SchemaFormatType.PDL);
    private Urn _sourceUrnField = null;
    private Urn _destinationUrnField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private StringMap _propertiesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_SourceUrn = SCHEMA.getField("sourceUrn");
    private static final RecordDataSchema.Field FIELD_DestinationUrn = SCHEMA.getField("destinationUrn");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_LastModified = SCHEMA.getField("lastModified");
    private static final RecordDataSchema.Field FIELD_Properties = SCHEMA.getField("properties");

    public Edge() {
        super(new DataMap(7, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public Edge(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSourceUrn() {
        if (this._sourceUrnField != null) {
            return true;
        }
        return this._map.containsKey("sourceUrn");
    }

    public void removeSourceUrn() {
        this._map.remove("sourceUrn");
    }

    @Nullable
    public Urn getSourceUrn(GetMode mode) {
        return this.getSourceUrn();
    }

    @Nullable
    public Urn getSourceUrn() {
        if (this._sourceUrnField != null) {
            return this._sourceUrnField;
        }
        Object __rawValue = this._map.get("sourceUrn");
        this._sourceUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._sourceUrnField;
    }

    public Edge setSourceUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSourceUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSourceUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sourceUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._sourceUrnField = value;
            }
        }
        return this;
    }

    public Edge setSourceUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sourceUrn of com.linkedin.common.Edge to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sourceUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._sourceUrnField = value;
        return this;
    }

    public boolean hasDestinationUrn() {
        if (this._destinationUrnField != null) {
            return true;
        }
        return this._map.containsKey("destinationUrn");
    }

    public void removeDestinationUrn() {
        this._map.remove("destinationUrn");
    }

    @Nullable
    public Urn getDestinationUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDestinationUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._destinationUrnField != null) {
                    return this._destinationUrnField;
                }
                Object __rawValue = this._map.get("destinationUrn");
                this._destinationUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._destinationUrnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getDestinationUrn() {
        if (this._destinationUrnField != null) {
            return this._destinationUrnField;
        }
        Object __rawValue = this._map.get("destinationUrn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("destinationUrn");
        }
        this._destinationUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._destinationUrnField;
    }

    public Edge setDestinationUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDestinationUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field destinationUrn of com.linkedin.common.Edge");
                }
                CheckedUtil.putWithoutChecking(this._map, "destinationUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._destinationUrnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDestinationUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "destinationUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._destinationUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "destinationUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._destinationUrnField = value;
            }
        }
        return this;
    }

    public Edge setDestinationUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field destinationUrn of com.linkedin.common.Edge to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "destinationUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._destinationUrnField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public Edge setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public Edge setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.common.Edge to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public Edge setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public Edge setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.common.Edge to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasProperties() {
        if (this._propertiesField != null) {
            return true;
        }
        return this._map.containsKey("properties");
    }

    public void removeProperties() {
        this._map.remove("properties");
    }

    @Nullable
    public StringMap getProperties(GetMode mode) {
        return this.getProperties();
    }

    @Nullable
    public StringMap getProperties() {
        if (this._propertiesField != null) {
            return this._propertiesField;
        }
        Object __rawValue = this._map.get("properties");
        this._propertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._propertiesField;
    }

    public Edge setProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
            }
        }
        return this;
    }

    public Edge setProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field properties of com.linkedin.common.Edge to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
        this._propertiesField = value;
        return this;
    }

    @Override
    public Edge clone() throws CloneNotSupportedException {
        Edge __clone = (Edge)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Edge copy() throws CloneNotSupportedException {
        Edge __copy = (Edge)super.copy();
        __copy._sourceUrnField = null;
        __copy._createdField = null;
        __copy._destinationUrnField = null;
        __copy._lastModifiedField = null;
        __copy._propertiesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Edge __objectRef;

        private ChangeListener(Edge reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "sourceUrn": {
                    this.__objectRef._sourceUrnField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "destinationUrn": {
                    this.__objectRef._destinationUrnField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "properties": {
                    this.__objectRef._propertiesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec sourceUrn() {
            return new PathSpec(this.getPathComponents(), "sourceUrn");
        }

        public PathSpec destinationUrn() {
            return new PathSpec(this.getPathComponents(), "destinationUrn");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }

        public PathSpec properties() {
            return new PathSpec(this.getPathComponents(), "properties");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withSourceUrn() {
            this.getDataMap().put("sourceUrn", 1);
            return this;
        }

        public ProjectionMask withDestinationUrn() {
            this.getDataMap().put("destinationUrn", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withProperties() {
            this.getDataMap().put("properties", 1);
            return this;
        }
    }
}

