/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.MetadataAttribution;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentationAssociation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Properties of applied documentation including the attribution of the doc*/record DocumentationAssociation{/**Description of this asset*/documentation:string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"documentationAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"documentationAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"documentationAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}", SchemaFormatType.PDL);
    private String _documentationField = null;
    private MetadataAttribution _attributionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Documentation = SCHEMA.getField("documentation");
    private static final RecordDataSchema.Field FIELD_Attribution = SCHEMA.getField("attribution");

    public DocumentationAssociation() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DocumentationAssociation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDocumentation() {
        if (this._documentationField != null) {
            return true;
        }
        return this._map.containsKey("documentation");
    }

    public void removeDocumentation() {
        this._map.remove("documentation");
    }

    @Nullable
    public String getDocumentation(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDocumentation();
            }
            case DEFAULT: 
            case NULL: {
                if (this._documentationField != null) {
                    return this._documentationField;
                }
                Object __rawValue = this._map.get("documentation");
                this._documentationField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._documentationField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDocumentation() {
        if (this._documentationField != null) {
            return this._documentationField;
        }
        Object __rawValue = this._map.get("documentation");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("documentation");
        }
        this._documentationField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._documentationField;
    }

    public DocumentationAssociation setDocumentation(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDocumentation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field documentation of com.linkedin.common.DocumentationAssociation");
                }
                CheckedUtil.putWithoutChecking(this._map, "documentation", value);
                this._documentationField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDocumentation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "documentation", value);
                this._documentationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "documentation", value);
                this._documentationField = value;
            }
        }
        return this;
    }

    public DocumentationAssociation setDocumentation(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field documentation of com.linkedin.common.DocumentationAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "documentation", value);
        this._documentationField = value;
        return this;
    }

    public boolean hasAttribution() {
        if (this._attributionField != null) {
            return true;
        }
        return this._map.containsKey("attribution");
    }

    public void removeAttribution() {
        this._map.remove("attribution");
    }

    @Nullable
    public MetadataAttribution getAttribution(GetMode mode) {
        return this.getAttribution();
    }

    @Nullable
    public MetadataAttribution getAttribution() {
        if (this._attributionField != null) {
            return this._attributionField;
        }
        Object __rawValue = this._map.get("attribution");
        this._attributionField = __rawValue == null ? null : new MetadataAttribution(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._attributionField;
    }

    public DocumentationAssociation setAttribution(@Nullable MetadataAttribution value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAttribution(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAttribution();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
                this._attributionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
                this._attributionField = value;
            }
        }
        return this;
    }

    public DocumentationAssociation setAttribution(@Nonnull MetadataAttribution value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field attribution of com.linkedin.common.DocumentationAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
        this._attributionField = value;
        return this;
    }

    @Override
    public DocumentationAssociation clone() throws CloneNotSupportedException {
        DocumentationAssociation __clone = (DocumentationAssociation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DocumentationAssociation copy() throws CloneNotSupportedException {
        DocumentationAssociation __copy = (DocumentationAssociation)super.copy();
        __copy._documentationField = null;
        __copy._attributionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DocumentationAssociation __objectRef;

        private ChangeListener(DocumentationAssociation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "documentation": {
                    this.__objectRef._documentationField = null;
                    break;
                }
                case "attribution": {
                    this.__objectRef._attributionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec documentation() {
            return new PathSpec(this.getPathComponents(), "documentation");
        }

        public MetadataAttribution.Fields attribution() {
            return new MetadataAttribution.Fields(this.getPathComponents(), "attribution");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private MetadataAttribution.ProjectionMask _attributionMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withDocumentation() {
            this.getDataMap().put("documentation", 1);
            return this;
        }

        public ProjectionMask withAttribution(Function<MetadataAttribution.ProjectionMask, MetadataAttribution.ProjectionMask> nestedMask) {
            this._attributionMask = nestedMask.apply(this._attributionMask == null ? MetadataAttribution.createMask() : this._attributionMask);
            this.getDataMap().put("attribution", this._attributionMask.getDataMap());
            return this;
        }

        public ProjectionMask withAttribution() {
            this._attributionMask = null;
            this.getDataMap().put("attribution", 1);
            return this;
        }
    }
}

