/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.AssertionStdOperator;
import com.linkedin.assertion.AssertionStdParameters;
import com.linkedin.assertion.AssertionValueChangeType;
import com.linkedin.assertion.SqlAssertionType;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SqlAssertionInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes defining a SQL Assertion*/record SqlAssertionInfo{/**The type of the SQL assertion being monitored.*/@Searchable={}type:enum SqlAssertionType{/**A SQL Metric Assertion, e.g. one based on a numeric value returned by an arbitrary SQL query.*/METRIC/**A SQL assertion that is evaluated against the CHANGE in a metric assertion\nover time.*/METRIC_CHANGE}/**The entity targeted by this SQL check.*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"Asserts\"}@Searchable.fieldType=\"URN\"entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The SQL statement to be executed when evaluating the assertion (or computing the metric).\nThis should be a valid and complete statement, executable by itself.\n\nUsually this should be a SELECT query statement.*/statement:string/**The type of the value used to evaluate the assertion: a fixed absolute value or a relative percentage.\nThis value is required if the type is METRIC_CHANGE.*/changeType:optional/**An enum to represent a type of change in an assertion value, metric, or measurement.*/enum AssertionValueChangeType{/**A change that is defined in absolute terms.*/ABSOLUTE/**A change that is defined in relative terms using percentage change\nfrom the original value.*/PERCENTAGE}/**The operator you'd like to apply to the result of the SQL query.\n\nNote that at this time, only numeric operators are valid inputs:\nGREATER_THAN, GREATER_THAN_OR_EQUAL_TO, EQUAL_TO, LESS_THAN, LESS_THAN_OR_EQUAL_TO,\nBETWEEN.*/operator:/**A boolean operator that is applied on the input to an assertion, after an aggregation function has been applied.*/enum AssertionStdOperator{/**Value being asserted is between min_value and max_value.  Requires 'minValue' & 'maxValue' parameters.*/BETWEEN/**Value being asserted is less than a max value. Requires 'value' parameter.*/LESS_THAN/**Value being asserted is less than or equal to some value. Requires 'value' parameter.*/LESS_THAN_OR_EQUAL_TO/**Value being asserted is greater than some value. Requires 'value' parameter.*/GREATER_THAN/**Value being asserted is greater than or equal to some value. Requires 'value' parameter.*/GREATER_THAN_OR_EQUAL_TO/**Value being asserted is equal to value. Requires 'value' parameter.*/EQUAL_TO/**Value being asserted is not equal to value. Requires 'value' parameter.*/NOT_EQUAL_TO/**Value being asserted is null. Requires no parameters.*/NULL/**Value being asserted is not null. Requires no parameters.*/NOT_NULL/**Value being asserted contains value. Requires 'value' parameter.*/CONTAIN/**Value being asserted ends with value. Requires 'value' parameter.*/END_WITH/**Value being asserted starts with value. Requires 'value' parameter.*/START_WITH/**Value being asserted matches the regex value. Requires 'value' parameter.*/REGEX_MATCH/**Value being asserted is one of the array values. Requires 'value' parameter.*/IN/**Value being asserted is not in one of the array values. Requires 'value' parameter.*/NOT_IN/**Value being asserted is true. Requires no parameters.*/IS_TRUE/**Value being asserted is false. Requires no parameters.*/IS_FALSE/**Other*/_NATIVE_}/**The parameters you'd like to provide as input to the operator.\n\nNote that only numeric parameter types are valid inputs: NUMBER.*/parameters:/**Parameters for AssertionStdOperators.*/record AssertionStdParameters{/**The value parameter of an assertion*/value:optional/**Single parameter for AssertionStdOperators.*/record AssertionStdParameter{/**The parameter value*/value:string/**The type of the parameter*/type:enum AssertionStdParameterType{/**A string value*/STRING/**A numeric value*/NUMBER/**A list of values. When used, value should be formatted as a serialized JSON array.*/LIST/**A set of values. When used, value should be formatted as a serialized JSON array.*/SET/**A value of unknown type*/UNKNOWN}}/**The maxValue parameter of an assertion*/maxValue:optional AssertionStdParameter/**The minValue parameter of an assertion*/minValue:optional AssertionStdParameter}}", SchemaFormatType.PDL);
    private SqlAssertionType _typeField = null;
    private Urn _entityField = null;
    private String _statementField = null;
    private AssertionValueChangeType _changeTypeField = null;
    private AssertionStdOperator _operatorField = null;
    private AssertionStdParameters _parametersField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_Statement = SCHEMA.getField("statement");
    private static final RecordDataSchema.Field FIELD_ChangeType = SCHEMA.getField("changeType");
    private static final RecordDataSchema.Field FIELD_Operator = SCHEMA.getField("operator");
    private static final RecordDataSchema.Field FIELD_Parameters = SCHEMA.getField("parameters");

    public SqlAssertionInfo() {
        super(new DataMap(8, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public SqlAssertionInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public SqlAssertionType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, SqlAssertionType.class, SqlAssertionType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SqlAssertionType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, SqlAssertionType.class, SqlAssertionType.$UNKNOWN);
        return this._typeField;
    }

    public SqlAssertionInfo setType(@Nullable SqlAssertionType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.assertion.SqlAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public SqlAssertionInfo setType(@Nonnull SqlAssertionType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.assertion.SqlAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public SqlAssertionInfo setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.assertion.SqlAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public SqlAssertionInfo setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.assertion.SqlAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasStatement() {
        if (this._statementField != null) {
            return true;
        }
        return this._map.containsKey("statement");
    }

    public void removeStatement() {
        this._map.remove("statement");
    }

    @Nullable
    public String getStatement(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStatement();
            }
            case DEFAULT: 
            case NULL: {
                if (this._statementField != null) {
                    return this._statementField;
                }
                Object __rawValue = this._map.get("statement");
                this._statementField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._statementField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getStatement() {
        if (this._statementField != null) {
            return this._statementField;
        }
        Object __rawValue = this._map.get("statement");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("statement");
        }
        this._statementField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._statementField;
    }

    public SqlAssertionInfo setStatement(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStatement(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field statement of com.linkedin.assertion.SqlAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "statement", value);
                this._statementField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStatement();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "statement", value);
                this._statementField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "statement", value);
                this._statementField = value;
            }
        }
        return this;
    }

    public SqlAssertionInfo setStatement(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field statement of com.linkedin.assertion.SqlAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "statement", value);
        this._statementField = value;
        return this;
    }

    public boolean hasChangeType() {
        if (this._changeTypeField != null) {
            return true;
        }
        return this._map.containsKey("changeType");
    }

    public void removeChangeType() {
        this._map.remove("changeType");
    }

    @Nullable
    public AssertionValueChangeType getChangeType(GetMode mode) {
        return this.getChangeType();
    }

    @Nullable
    public AssertionValueChangeType getChangeType() {
        if (this._changeTypeField != null) {
            return this._changeTypeField;
        }
        Object __rawValue = this._map.get("changeType");
        this._changeTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionValueChangeType.class, AssertionValueChangeType.$UNKNOWN);
        return this._changeTypeField;
    }

    public SqlAssertionInfo setChangeType(@Nullable AssertionValueChangeType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setChangeType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeChangeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "changeType", value.name());
                this._changeTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "changeType", value.name());
                this._changeTypeField = value;
            }
        }
        return this;
    }

    public SqlAssertionInfo setChangeType(@Nonnull AssertionValueChangeType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field changeType of com.linkedin.assertion.SqlAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "changeType", value.name());
        this._changeTypeField = value;
        return this;
    }

    public boolean hasOperator() {
        if (this._operatorField != null) {
            return true;
        }
        return this._map.containsKey("operator");
    }

    public void removeOperator() {
        this._map.remove("operator");
    }

    @Nullable
    public AssertionStdOperator getOperator(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOperator();
            }
            case DEFAULT: 
            case NULL: {
                if (this._operatorField != null) {
                    return this._operatorField;
                }
                Object __rawValue = this._map.get("operator");
                this._operatorField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdOperator.class, AssertionStdOperator.$UNKNOWN);
                return this._operatorField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionStdOperator getOperator() {
        if (this._operatorField != null) {
            return this._operatorField;
        }
        Object __rawValue = this._map.get("operator");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("operator");
        }
        this._operatorField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdOperator.class, AssertionStdOperator.$UNKNOWN);
        return this._operatorField;
    }

    public SqlAssertionInfo setOperator(@Nullable AssertionStdOperator value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperator(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field operator of com.linkedin.assertion.SqlAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperator();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
            }
        }
        return this;
    }

    public SqlAssertionInfo setOperator(@Nonnull AssertionStdOperator value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operator of com.linkedin.assertion.SqlAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
        this._operatorField = value;
        return this;
    }

    public boolean hasParameters() {
        if (this._parametersField != null) {
            return true;
        }
        return this._map.containsKey("parameters");
    }

    public void removeParameters() {
        this._map.remove("parameters");
    }

    @Nullable
    public AssertionStdParameters getParameters(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getParameters();
            }
            case DEFAULT: 
            case NULL: {
                if (this._parametersField != null) {
                    return this._parametersField;
                }
                Object __rawValue = this._map.get("parameters");
                this._parametersField = __rawValue == null ? null : new AssertionStdParameters(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._parametersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionStdParameters getParameters() {
        if (this._parametersField != null) {
            return this._parametersField;
        }
        Object __rawValue = this._map.get("parameters");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("parameters");
        }
        this._parametersField = __rawValue == null ? null : new AssertionStdParameters(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._parametersField;
    }

    public SqlAssertionInfo setParameters(@Nullable AssertionStdParameters value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParameters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field parameters of com.linkedin.assertion.SqlAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParameters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
            }
        }
        return this;
    }

    public SqlAssertionInfo setParameters(@Nonnull AssertionStdParameters value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parameters of com.linkedin.assertion.SqlAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
        this._parametersField = value;
        return this;
    }

    @Override
    public SqlAssertionInfo clone() throws CloneNotSupportedException {
        SqlAssertionInfo __clone = (SqlAssertionInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SqlAssertionInfo copy() throws CloneNotSupportedException {
        SqlAssertionInfo __copy = (SqlAssertionInfo)super.copy();
        __copy._changeTypeField = null;
        __copy._statementField = null;
        __copy._typeField = null;
        __copy._parametersField = null;
        __copy._entityField = null;
        __copy._operatorField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SqlAssertionInfo __objectRef;

        private ChangeListener(SqlAssertionInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "changeType": {
                    this.__objectRef._changeTypeField = null;
                    break;
                }
                case "statement": {
                    this.__objectRef._statementField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "parameters": {
                    this.__objectRef._parametersField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                    break;
                }
                case "operator": {
                    this.__objectRef._operatorField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public PathSpec statement() {
            return new PathSpec(this.getPathComponents(), "statement");
        }

        public PathSpec changeType() {
            return new PathSpec(this.getPathComponents(), "changeType");
        }

        public PathSpec operator() {
            return new PathSpec(this.getPathComponents(), "operator");
        }

        public AssertionStdParameters.Fields parameters() {
            return new AssertionStdParameters.Fields(this.getPathComponents(), "parameters");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AssertionStdParameters.ProjectionMask _parametersMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withStatement() {
            this.getDataMap().put("statement", 1);
            return this;
        }

        public ProjectionMask withChangeType() {
            this.getDataMap().put("changeType", 1);
            return this;
        }

        public ProjectionMask withOperator() {
            this.getDataMap().put("operator", 1);
            return this;
        }

        public ProjectionMask withParameters(Function<AssertionStdParameters.ProjectionMask, AssertionStdParameters.ProjectionMask> nestedMask) {
            this._parametersMask = nestedMask.apply(this._parametersMask == null ? AssertionStdParameters.createMask() : this._parametersMask);
            this.getDataMap().put("parameters", this._parametersMask.getDataMap());
            return this;
        }

        public ProjectionMask withParameters() {
            this._parametersMask = null;
            this.getDataMap().put("parameters", 1);
            return this;
        }
    }
}

