/*
 * Decompiled with CFR 0.152.
 */
package com.datahub.util.validator;

import com.datahub.util.exception.InvalidSchemaException;
import com.datahub.util.validator.ValidationUtils;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.UnionTemplate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public final class EntityValidator {
    private static final Set<String> NON_OPTIONAL_FIELDS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("urn");
        }
    });
    private static final Set<Class<? extends RecordTemplate>> VALIDATED = ConcurrentHashMap.newKeySet();
    private static final Set<Class<? extends UnionTemplate>> UNION_VALIDATED = ConcurrentHashMap.newKeySet();

    private EntityValidator() {
    }

    public static void validateEntitySchema(@Nonnull RecordDataSchema schema) {
        String className = schema.getBindingName();
        if (!ValidationUtils.schemaHasExactlyOneSuchField(schema, ValidationUtils::isValidUrnField)) {
            ValidationUtils.invalidSchema("Entity '%s' must contain a non-optional 'urn' field of URN type", className);
        }
        ValidationUtils.fieldsUsingInvalidType(schema, ValidationUtils.PRIMITIVE_TYPES).forEach(field -> ValidationUtils.invalidSchema("Entity '%s' contains a field '%s' that makes use of a disallowed type '%s'.", new Object[]{className, field.getName(), field.getType().getType()}));
        ValidationUtils.nonOptionalFields(schema, NON_OPTIONAL_FIELDS).forEach(field -> ValidationUtils.invalidSchema("Entity '%s' must contain an optional '%s' field", className, field.getName()));
    }

    public static void validateEntitySchema(@Nonnull Class<? extends RecordTemplate> clazz) {
        if (VALIDATED.contains(clazz)) {
            return;
        }
        EntityValidator.validateEntitySchema(ValidationUtils.getRecordSchema(clazz));
        VALIDATED.add(clazz);
    }

    public static void validateEntityUnionSchema(@Nonnull Class<? extends UnionTemplate> clazz) {
        if (UNION_VALIDATED.contains(clazz)) {
            return;
        }
        EntityValidator.validateEntityUnionSchema(ValidationUtils.getUnionSchema(clazz), clazz.getCanonicalName());
        UNION_VALIDATED.add(clazz);
    }

    public static void validateEntityUnionSchema(@Nonnull UnionDataSchema schema, @Nonnull String entityClassName) {
        if (!ValidationUtils.isUnionWithOnlyComplexMembers(schema)) {
            ValidationUtils.invalidSchema("Entity '%s' must be a union containing only record type members", entityClassName);
        }
    }

    public static boolean isValidEntitySchema(@Nonnull Class<? extends RecordTemplate> clazz) {
        if (!VALIDATED.contains(clazz)) {
            try {
                EntityValidator.validateEntitySchema(clazz);
            }
            catch (InvalidSchemaException ex) {
                return false;
            }
        }
        return true;
    }
}

