/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.view;

import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.view.DataHubViewDefinition;
import com.linkedin.view.DataHubViewType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubViewInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.view/**Information about a DataHub View. -- TODO: Understand whether an entity type filter is required.*/@Aspect.name=\"dataHubViewInfo\"record DataHubViewInfo{/**The name of the View*/@Searchable.fieldType=\"TEXT_PARTIAL\"name:string/**Description of the view*/description:optional string/**The type of View*/@Searchable={}type:enum DataHubViewType{/**A view private for a specific person.*/PERSONAL/**A global view, which all users can see and use.*/GLOBAL}/**The view itself*/definition:/**A View definition.*/record DataHubViewDefinition{/**The Entity Types in the scope of the View.*/entityTypes:array[string]/**The filter criteria, which represents the view itself*/filter:{namespace com.linkedin.metadata.query.filter/**The filter for finding a record or a collection of records*/record Filter{/**A list of disjunctive criterion for the filter. (or operation to combine filters)*/or:optional array[/**A list of criterion and'd together.*/record ConjunctiveCriterion{/**A list of and criteria the filter applies to the query*/and:array[/**A criterion for matching a field with given value*/record Criterion{/**The name of the field that the criterion refers to*/field:string/**The value of the intended field*/value:string/**Values. one of which the intended field should match\nNote, if values is set, the above \"value\" field will be ignored*/values:array[string]=[]/**The condition for the criterion, e.g. EQUAL, START_WITH*/condition:/**The matching condition in a filter criterion*/enum Condition{/**Represent the relation: String field contains value, e.g. name contains Profile*/CONTAIN/**Represent the relation: String field ends with value, e.g. name ends with Event*/END_WITH/**Represent the relation: field = value, e.g. platform = hdfs*/EQUAL/**Represent the relation: field = value and support case insensitive values, e.g. platform = hdfs*/IEQUAL/**Represent the relation: field is null, e.g. platform is null*/IS_NULL/**Represents the relation: field exists and is non-empty, e.g. owners is not null and != [] (empty)*/EXISTS/**Represent the relation greater than, e.g. ownerCount > 5*/GREATER_THAN/**Represent the relation greater than or equal to, e.g. ownerCount >= 5*/GREATER_THAN_OR_EQUAL_TO/**Represent the relation: String field is one of the array values to, e.g. name in [\"Profile\", \"Event\"]*/IN/**Represent the relation less than, e.g. ownerCount < 3*/LESS_THAN/**Represent the relation less than or equal to, e.g. ownerCount <= 3*/LESS_THAN_OR_EQUAL_TO/**Represent the relation: String field starts with value, e.g. name starts with PageView*/START_WITH/**Represent the relation: URN field any nested children in addition to the given URN*/DESCENDANTS_INCL/**Represent the relation: URN field matches any nested parent in addition to the given URN*/ANCESTORS_INCL/**Represent the relation: URN field matches any nested child or parent in addition to the given URN*/RELATED_INCL}=\"EQUAL\"/**Whether the condition should be negated*/negated:boolean=false}]}]/**Deprecated! A list of conjunctive criterion for the filter. If \"or\" field is provided, then this field is ignored.*/criteria:optional array[Criterion]}}}/**Audit stamp capturing the time and actor who created the View.*/@Searchable={\"/actor\":{\"fieldName\":\"createdBy\",\"fieldType\":\"URN\"},\"/time\":{\"fieldName\":\"createdAt\",\"fieldType\":\"DATETIME\"}}created:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**Audit stamp capturing the time and actor who last modified the View.*/@Searchable.`/time`={\"fieldName\":\"lastModifiedAt\",\"fieldType\":\"DATETIME\"}lastModified:com.linkedin.common.AuditStamp}", SchemaFormatType.PDL);
    private String _nameField = null;
    private String _descriptionField = null;
    private DataHubViewType _typeField = null;
    private DataHubViewDefinition _definitionField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Definition = SCHEMA.getField("definition");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_LastModified = SCHEMA.getField("lastModified");

    public DataHubViewInfo() {
        super(new DataMap(8, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubViewInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public DataHubViewInfo setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.view.DataHubViewInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public DataHubViewInfo setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.view.DataHubViewInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public DataHubViewInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public DataHubViewInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.view.DataHubViewInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public DataHubViewType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DataHubViewType.class, DataHubViewType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataHubViewType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DataHubViewType.class, DataHubViewType.$UNKNOWN);
        return this._typeField;
    }

    public DataHubViewInfo setType(@Nullable DataHubViewType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.view.DataHubViewInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public DataHubViewInfo setType(@Nonnull DataHubViewType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.view.DataHubViewInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasDefinition() {
        if (this._definitionField != null) {
            return true;
        }
        return this._map.containsKey("definition");
    }

    public void removeDefinition() {
        this._map.remove("definition");
    }

    @Nullable
    public DataHubViewDefinition getDefinition(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDefinition();
            }
            case DEFAULT: 
            case NULL: {
                if (this._definitionField != null) {
                    return this._definitionField;
                }
                Object __rawValue = this._map.get("definition");
                this._definitionField = __rawValue == null ? null : new DataHubViewDefinition(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._definitionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DataHubViewDefinition getDefinition() {
        if (this._definitionField != null) {
            return this._definitionField;
        }
        Object __rawValue = this._map.get("definition");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("definition");
        }
        this._definitionField = __rawValue == null ? null : new DataHubViewDefinition(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._definitionField;
    }

    public DataHubViewInfo setDefinition(@Nullable DataHubViewDefinition value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDefinition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field definition of com.linkedin.view.DataHubViewInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "definition", value.data());
                this._definitionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDefinition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "definition", value.data());
                this._definitionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "definition", value.data());
                this._definitionField = value;
            }
        }
        return this;
    }

    public DataHubViewInfo setDefinition(@Nonnull DataHubViewDefinition value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field definition of com.linkedin.view.DataHubViewInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "definition", value.data());
        this._definitionField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("created");
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public DataHubViewInfo setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.view.DataHubViewInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public DataHubViewInfo setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.view.DataHubViewInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getLastModified();
            }
            case DEFAULT: 
            case NULL: {
                if (this._lastModifiedField != null) {
                    return this._lastModifiedField;
                }
                Object __rawValue = this._map.get("lastModified");
                this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lastModifiedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("lastModified");
        }
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public DataHubViewInfo setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastModified of com.linkedin.view.DataHubViewInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public DataHubViewInfo setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.view.DataHubViewInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    @Override
    public DataHubViewInfo clone() throws CloneNotSupportedException {
        DataHubViewInfo __clone = (DataHubViewInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubViewInfo copy() throws CloneNotSupportedException {
        DataHubViewInfo __copy = (DataHubViewInfo)super.copy();
        __copy._createdField = null;
        __copy._nameField = null;
        __copy._descriptionField = null;
        __copy._definitionField = null;
        __copy._lastModifiedField = null;
        __copy._typeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubViewInfo __objectRef;

        private ChangeListener(DataHubViewInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "definition": {
                    this.__objectRef._definitionField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public DataHubViewDefinition.Fields definition() {
            return new DataHubViewDefinition.Fields(this.getPathComponents(), "definition");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataHubViewDefinition.ProjectionMask _definitionMask;
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withDefinition(Function<DataHubViewDefinition.ProjectionMask, DataHubViewDefinition.ProjectionMask> nestedMask) {
            this._definitionMask = nestedMask.apply(this._definitionMask == null ? DataHubViewDefinition.createMask() : this._definitionMask);
            this.getDataMap().put("definition", this._definitionMask.getDataMap());
            return this;
        }

        public ProjectionMask withDefinition() {
            this._definitionMask = null;
            this.getDataMap().put("definition", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }
    }
}

