/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Predicate;

public final class LineColumnNumberWriter
extends Writer {
    private final Writer _writer;
    private final Stack<CharacterPosition> _savedPositionStack = new Stack();
    private int _column;
    private int _line;
    private int _previousChar;
    private Predicate<Character> _isWhitespaceFunction;
    private final CharacterPosition _lastNonWhitespacePosition;

    public LineColumnNumberWriter(Writer out) {
        this._writer = out;
        this._column = 1;
        this._line = 1;
        this._previousChar = -1;
        this._isWhitespaceFunction = Character::isWhitespace;
        this._lastNonWhitespacePosition = new CharacterPosition(0, 0);
    }

    public CharacterPosition getCurrentPosition() {
        return new CharacterPosition(this._line, this._column);
    }

    public CharacterPosition getLastNonWhitespacePosition() {
        return this._lastNonWhitespacePosition;
    }

    public void saveCurrentPosition() {
        this._savedPositionStack.push(new CharacterPosition(this._line, this._column));
    }

    public CharacterPosition popSavedPosition() {
        return this._savedPositionStack.pop();
    }

    public void setIsWhitespaceFunction(Predicate<Character> isWhitespaceFunction) {
        this._isWhitespaceFunction = isWhitespaceFunction;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this._writer.write(cbuf, off, len);
        while (len > 0) {
            char c = cbuf[off++];
            int lastLine = this._line;
            int lastColumn = this._column;
            this.updateCurrentPosition(c);
            this._previousChar = c;
            if (this._isWhitespaceFunction.test(Character.valueOf(c))) {
                this.updateSavedPositionsForWhitespace(lastLine, lastColumn);
            } else {
                this._lastNonWhitespacePosition.line = lastLine;
                this._lastNonWhitespacePosition.column = lastColumn;
            }
            --len;
        }
    }

    @Override
    public void flush() throws IOException {
        this._writer.flush();
    }

    @Override
    public void close() throws IOException {
        this._writer.close();
    }

    public String toString() {
        return this._writer.toString();
    }

    private void updateCurrentPosition(char c) {
        if (this._previousChar == 13) {
            this._column = c == '\n' ? 1 : 2;
        } else if (c == '\n' || c == '\r') {
            this._column = 1;
            ++this._line;
        } else {
            ++this._column;
        }
    }

    private void updateSavedPositionsForWhitespace(int lastLine, int lastColumn) {
        CharacterPosition savedCharacterPosition;
        for (int i = this._savedPositionStack.size() - 1; i >= 0 && (savedCharacterPosition = (CharacterPosition)this._savedPositionStack.get(i)).line == lastLine && savedCharacterPosition.column == lastColumn; --i) {
            savedCharacterPosition.line = this._line;
            savedCharacterPosition.column = this._column;
        }
    }

    public static class CharacterPosition {
        private int line;
        private int column;

        CharacterPosition(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharacterPosition characterPosition = (CharacterPosition)o;
            return this.line == characterPosition.line && this.column == characterPosition.column;
        }

        public int hashCode() {
            return Objects.hash(this.line, this.column);
        }

        public String toString() {
            return "CharacterPosition{line=" + this.line + ", column=" + this.column + '}';
        }
    }
}

