/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.timeseries;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.StringArrayArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GenericTable
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.timeseries/**Defines a generic table.*/record GenericTable{/**The names of the columns.*/columnNames:array[string]/**The types of the columns.*/columnTypes:array[string]/**The data rows.*/rows:optional array[array[string]]}", SchemaFormatType.PDL);
    private StringArray _columnNamesField = null;
    private StringArray _columnTypesField = null;
    private StringArrayArray _rowsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_ColumnNames = SCHEMA.getField("columnNames");
    private static final RecordDataSchema.Field FIELD_ColumnTypes = SCHEMA.getField("columnTypes");
    private static final RecordDataSchema.Field FIELD_Rows = SCHEMA.getField("rows");

    public GenericTable() {
        super(new DataMap(4, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public GenericTable(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasColumnNames() {
        if (this._columnNamesField != null) {
            return true;
        }
        return this._map.containsKey("columnNames");
    }

    public void removeColumnNames() {
        this._map.remove("columnNames");
    }

    @Nullable
    public StringArray getColumnNames(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getColumnNames();
            }
            case DEFAULT: 
            case NULL: {
                if (this._columnNamesField != null) {
                    return this._columnNamesField;
                }
                Object __rawValue = this._map.get("columnNames");
                this._columnNamesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._columnNamesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getColumnNames() {
        if (this._columnNamesField != null) {
            return this._columnNamesField;
        }
        Object __rawValue = this._map.get("columnNames");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("columnNames");
        }
        this._columnNamesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._columnNamesField;
    }

    public GenericTable setColumnNames(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setColumnNames(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field columnNames of com.linkedin.timeseries.GenericTable");
                }
                CheckedUtil.putWithoutChecking(this._map, "columnNames", value.data());
                this._columnNamesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeColumnNames();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "columnNames", value.data());
                this._columnNamesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "columnNames", value.data());
                this._columnNamesField = value;
            }
        }
        return this;
    }

    public GenericTable setColumnNames(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field columnNames of com.linkedin.timeseries.GenericTable to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "columnNames", value.data());
        this._columnNamesField = value;
        return this;
    }

    public boolean hasColumnTypes() {
        if (this._columnTypesField != null) {
            return true;
        }
        return this._map.containsKey("columnTypes");
    }

    public void removeColumnTypes() {
        this._map.remove("columnTypes");
    }

    @Nullable
    public StringArray getColumnTypes(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getColumnTypes();
            }
            case DEFAULT: 
            case NULL: {
                if (this._columnTypesField != null) {
                    return this._columnTypesField;
                }
                Object __rawValue = this._map.get("columnTypes");
                this._columnTypesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._columnTypesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getColumnTypes() {
        if (this._columnTypesField != null) {
            return this._columnTypesField;
        }
        Object __rawValue = this._map.get("columnTypes");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("columnTypes");
        }
        this._columnTypesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._columnTypesField;
    }

    public GenericTable setColumnTypes(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setColumnTypes(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field columnTypes of com.linkedin.timeseries.GenericTable");
                }
                CheckedUtil.putWithoutChecking(this._map, "columnTypes", value.data());
                this._columnTypesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeColumnTypes();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "columnTypes", value.data());
                this._columnTypesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "columnTypes", value.data());
                this._columnTypesField = value;
            }
        }
        return this;
    }

    public GenericTable setColumnTypes(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field columnTypes of com.linkedin.timeseries.GenericTable to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "columnTypes", value.data());
        this._columnTypesField = value;
        return this;
    }

    public boolean hasRows() {
        if (this._rowsField != null) {
            return true;
        }
        return this._map.containsKey("rows");
    }

    public void removeRows() {
        this._map.remove("rows");
    }

    @Nullable
    public StringArrayArray getRows(GetMode mode) {
        return this.getRows();
    }

    @Nullable
    public StringArrayArray getRows() {
        if (this._rowsField != null) {
            return this._rowsField;
        }
        Object __rawValue = this._map.get("rows");
        this._rowsField = __rawValue == null ? null : new StringArrayArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._rowsField;
    }

    public GenericTable setRows(@Nullable StringArrayArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRows(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRows();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "rows", value.data());
                this._rowsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "rows", value.data());
                this._rowsField = value;
            }
        }
        return this;
    }

    public GenericTable setRows(@Nonnull StringArrayArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field rows of com.linkedin.timeseries.GenericTable to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "rows", value.data());
        this._rowsField = value;
        return this;
    }

    @Override
    public GenericTable clone() throws CloneNotSupportedException {
        GenericTable __clone = (GenericTable)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public GenericTable copy() throws CloneNotSupportedException {
        GenericTable __copy = (GenericTable)super.copy();
        __copy._columnNamesField = null;
        __copy._columnTypesField = null;
        __copy._rowsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final GenericTable __objectRef;

        private ChangeListener(GenericTable reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "columnNames": {
                    this.__objectRef._columnNamesField = null;
                    break;
                }
                case "columnTypes": {
                    this.__objectRef._columnTypesField = null;
                    break;
                }
                case "rows": {
                    this.__objectRef._rowsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec columnNames() {
            return new PathSpec(this.getPathComponents(), "columnNames");
        }

        public PathSpec columnNames(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "columnNames");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec columnTypes() {
            return new PathSpec(this.getPathComponents(), "columnTypes");
        }

        public PathSpec columnTypes(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "columnTypes");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec rows() {
            return new PathSpec(this.getPathComponents(), "rows");
        }

        public PathSpec rows(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "rows");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withColumnNames() {
            this.getDataMap().put("columnNames", 1);
            return this;
        }

        public ProjectionMask withColumnNames(Integer start, Integer count) {
            this.getDataMap().put("columnNames", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("columnNames").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("columnNames").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withColumnTypes() {
            this.getDataMap().put("columnTypes", 1);
            return this;
        }

        public ProjectionMask withColumnTypes(Integer start, Integer count) {
            this.getDataMap().put("columnTypes", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("columnTypes").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("columnTypes").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRows() {
            this.getDataMap().put("rows", 1);
            return this;
        }

        public ProjectionMask withRows(Integer start, Integer count) {
            this.getDataMap().put("rows", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("rows").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("rows").put("$count", count);
            }
            return this;
        }
    }
}

