/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.test;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.test.TestDefinition;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.test/**Information about a DataHub Test*/@Aspect.name=\"testInfo\"record TestInfo{/**The name of the test*/@Searchable.fieldType=\"TEXT_PARTIAL\"name:string/**Category of the test*/@Searchable.fieldType=\"KEYWORD\"category:string/**Description of the test*/@Searchable.fieldType=\"TEXT\"description:optional string/**Configuration for the Test*/definition:record TestDefinition{/**The Test Definition Type*/type:enum TestDefinitionType{/**JSON / YAML test def*/JSON}/**JSON format configuration for the test*/json:optional string}}", SchemaFormatType.PDL);
    private String _nameField = null;
    private String _categoryField = null;
    private String _descriptionField = null;
    private TestDefinition _definitionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Category = SCHEMA.getField("category");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_Definition = SCHEMA.getField("definition");

    public TestInfo() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public TestInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public TestInfo setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.test.TestInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public TestInfo setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.test.TestInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasCategory() {
        if (this._categoryField != null) {
            return true;
        }
        return this._map.containsKey("category");
    }

    public void removeCategory() {
        this._map.remove("category");
    }

    @Nullable
    public String getCategory(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCategory();
            }
            case DEFAULT: 
            case NULL: {
                if (this._categoryField != null) {
                    return this._categoryField;
                }
                Object __rawValue = this._map.get("category");
                this._categoryField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._categoryField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getCategory() {
        if (this._categoryField != null) {
            return this._categoryField;
        }
        Object __rawValue = this._map.get("category");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("category");
        }
        this._categoryField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._categoryField;
    }

    public TestInfo setCategory(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCategory(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field category of com.linkedin.test.TestInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "category", value);
                this._categoryField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCategory();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "category", value);
                this._categoryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "category", value);
                this._categoryField = value;
            }
        }
        return this;
    }

    public TestInfo setCategory(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field category of com.linkedin.test.TestInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "category", value);
        this._categoryField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public TestInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public TestInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.test.TestInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasDefinition() {
        if (this._definitionField != null) {
            return true;
        }
        return this._map.containsKey("definition");
    }

    public void removeDefinition() {
        this._map.remove("definition");
    }

    @Nullable
    public TestDefinition getDefinition(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDefinition();
            }
            case DEFAULT: 
            case NULL: {
                if (this._definitionField != null) {
                    return this._definitionField;
                }
                Object __rawValue = this._map.get("definition");
                this._definitionField = __rawValue == null ? null : new TestDefinition(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._definitionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public TestDefinition getDefinition() {
        if (this._definitionField != null) {
            return this._definitionField;
        }
        Object __rawValue = this._map.get("definition");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("definition");
        }
        this._definitionField = __rawValue == null ? null : new TestDefinition(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._definitionField;
    }

    public TestInfo setDefinition(@Nullable TestDefinition value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDefinition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field definition of com.linkedin.test.TestInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "definition", value.data());
                this._definitionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDefinition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "definition", value.data());
                this._definitionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "definition", value.data());
                this._definitionField = value;
            }
        }
        return this;
    }

    public TestInfo setDefinition(@Nonnull TestDefinition value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field definition of com.linkedin.test.TestInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "definition", value.data());
        this._definitionField = value;
        return this;
    }

    @Override
    public TestInfo clone() throws CloneNotSupportedException {
        TestInfo __clone = (TestInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public TestInfo copy() throws CloneNotSupportedException {
        TestInfo __copy = (TestInfo)super.copy();
        __copy._nameField = null;
        __copy._descriptionField = null;
        __copy._definitionField = null;
        __copy._categoryField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final TestInfo __objectRef;

        private ChangeListener(TestInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "definition": {
                    this.__objectRef._definitionField = null;
                    break;
                }
                case "category": {
                    this.__objectRef._categoryField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec category() {
            return new PathSpec(this.getPathComponents(), "category");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public TestDefinition.Fields definition() {
            return new TestDefinition.Fields(this.getPathComponents(), "definition");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TestDefinition.ProjectionMask _definitionMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withCategory() {
            this.getDataMap().put("category", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withDefinition(Function<TestDefinition.ProjectionMask, TestDefinition.ProjectionMask> nestedMask) {
            this._definitionMask = nestedMask.apply(this._definitionMask == null ? TestDefinition.createMask() : this._definitionMask);
            this.getDataMap().put("definition", this._definitionMask.getDataMap());
            return this;
        }

        public ProjectionMask withDefinition() {
            this._definitionMask = null;
            this.getDataMap().put("definition", 1);
            return this;
        }
    }
}

