/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.template;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.template.SummaryElementArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubPageTemplateAssetSummary
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.template/**The page template info for asset summaries*/record DataHubPageTemplateAssetSummary{/**The optional list of properties shown on an asset summary page header.*/summaryElements:optional array[/**Info for a given asset summary element*/record SummaryElement{/**The type of element/property*/elementType:enum SummaryElementType{CREATED,TAGS,GLOSSARY_TERMS,OWNERS,DOMAIN,STRUCTURED_PROPERTY}/**The urn of the structured property shown. Required if propertyType is STRUCTURED_PROPERTY*/@Relationship={\"entityTypes\":[\"structuredProperty\"],\"name\":\"ContainsStructuredProperty\"}structuredPropertyUrn:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}]}", SchemaFormatType.PDL);
    private SummaryElementArray _summaryElementsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_SummaryElements = SCHEMA.getField("summaryElements");

    public DataHubPageTemplateAssetSummary() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubPageTemplateAssetSummary(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSummaryElements() {
        if (this._summaryElementsField != null) {
            return true;
        }
        return this._map.containsKey("summaryElements");
    }

    public void removeSummaryElements() {
        this._map.remove("summaryElements");
    }

    @Nullable
    public SummaryElementArray getSummaryElements(GetMode mode) {
        return this.getSummaryElements();
    }

    @Nullable
    public SummaryElementArray getSummaryElements() {
        if (this._summaryElementsField != null) {
            return this._summaryElementsField;
        }
        Object __rawValue = this._map.get("summaryElements");
        this._summaryElementsField = __rawValue == null ? null : new SummaryElementArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._summaryElementsField;
    }

    public DataHubPageTemplateAssetSummary setSummaryElements(@Nullable SummaryElementArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSummaryElements(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSummaryElements();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "summaryElements", value.data());
                this._summaryElementsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "summaryElements", value.data());
                this._summaryElementsField = value;
            }
        }
        return this;
    }

    public DataHubPageTemplateAssetSummary setSummaryElements(@Nonnull SummaryElementArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field summaryElements of com.linkedin.template.DataHubPageTemplateAssetSummary to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "summaryElements", value.data());
        this._summaryElementsField = value;
        return this;
    }

    @Override
    public DataHubPageTemplateAssetSummary clone() throws CloneNotSupportedException {
        DataHubPageTemplateAssetSummary __clone = (DataHubPageTemplateAssetSummary)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubPageTemplateAssetSummary copy() throws CloneNotSupportedException {
        DataHubPageTemplateAssetSummary __copy = (DataHubPageTemplateAssetSummary)super.copy();
        __copy._summaryElementsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubPageTemplateAssetSummary __objectRef;

        private ChangeListener(DataHubPageTemplateAssetSummary reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "summaryElements": {
                    this.__objectRef._summaryElementsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public SummaryElementArray.Fields summaryElements() {
            return new SummaryElementArray.Fields(this.getPathComponents(), "summaryElements");
        }

        public PathSpec summaryElements(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "summaryElements");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SummaryElementArray.ProjectionMask _summaryElementsMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withSummaryElements(Function<SummaryElementArray.ProjectionMask, SummaryElementArray.ProjectionMask> nestedMask) {
            this._summaryElementsMask = nestedMask.apply(this._summaryElementsMask == null ? SummaryElementArray.createMask() : this._summaryElementsMask);
            this.getDataMap().put("summaryElements", this._summaryElementsMask.getDataMap());
            return this;
        }

        public ProjectionMask withSummaryElements() {
            this._summaryElementsMask = null;
            this.getDataMap().put("summaryElements", 1);
            return this;
        }

        public ProjectionMask withSummaryElements(Function<SummaryElementArray.ProjectionMask, SummaryElementArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._summaryElementsMask = nestedMask.apply(this._summaryElementsMask == null ? SummaryElementArray.createMask() : this._summaryElementsMask);
            this.getDataMap().put("summaryElements", this._summaryElementsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("summaryElements").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("summaryElements").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSummaryElements(Integer start, Integer count) {
            this._summaryElementsMask = null;
            this.getDataMap().put("summaryElements", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("summaryElements").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("summaryElements").put("$count", count);
            }
            return this;
        }
    }
}

