/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.settings.global;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.settings.global.OidcSettings;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SsoSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.settings.global/**SSO Integrations, supported on the UI.*/record SsoSettings{/**Auth base URL.*/baseUrl:string/**Optional OIDC SSO settings.*/oidcSettings:optional/**Settings for OIDC SSO integration.*/record OidcSettings{/**Whether OIDC SSO is enabled.*/enabled:boolean/**Unique client id issued by the identity provider.*/clientId:string/**Unique client secret issued by the identity provider.*/clientSecret:string/**The IdP OIDC discovery url.*/discoveryUri:string/**ADVANCED. The attribute / claim used to derive the DataHub username. Defaults to \"preferred_username\".*/userNameClaim:optional string/**ADVANCED. TThe regex used to parse the DataHub username from the user name claim. Defaults to (.*) (all).*/userNameClaimRegex:optional string/**ADVANCED. String representing the requested scope from the IdP. Defaults to \"oidc email profile\".*/scope:optional string/**ADVANCED. Which authentication method to use to pass credentials (clientId and clientSecret) to the token endpoint: Defaults to \"client_secret_basic\".*/clientAuthenticationMethod:optional string/**ADVANCED. Whether DataHub users should be provisioned on login if they do not exist. Defaults to true.*/jitProvisioningEnabled:optional boolean/**ADVANCED. Whether the user should already exist in DataHub on login, failing login if they are not. Defaults to false.*/preProvisioningRequired:optional boolean/**ADVANCED. Whether groups should be extracted from a claim in the OIDC profile. Only applies if JIT provisioning is enabled. Groups will be created if they do not exist. Defaults to true.*/extractGroupsEnabled:optional boolean/**ADVANCED. The OIDC claim to extract groups information from. Defaults to 'groups'.*/groupsClaim:optional string/**ADVANCED. Response type.*/responseType:optional string/**ADVANCED. Response mode.*/responseMode:optional string/**ADVANCED. Use Nonce.*/useNonce:optional boolean/**ADVANCED. Read timeout.*/readTimeout:optional long/**ADVANCED. Whether to extract claims from JWT access token.  Defaults to false.*/extractJwtAccessTokenClaims:optional boolean/** ADVANCED. Which jws algorithm to use. Unused.*/preferredJwsAlgorithm:optional string/** ADVANCED. Which jws algorithm to use.*/preferredJwsAlgorithm2:optional string}}", SchemaFormatType.PDL);
    private String _baseUrlField = null;
    private OidcSettings _oidcSettingsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_BaseUrl = SCHEMA.getField("baseUrl");
    private static final RecordDataSchema.Field FIELD_OidcSettings = SCHEMA.getField("oidcSettings");

    public SsoSettings() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public SsoSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasBaseUrl() {
        if (this._baseUrlField != null) {
            return true;
        }
        return this._map.containsKey("baseUrl");
    }

    public void removeBaseUrl() {
        this._map.remove("baseUrl");
    }

    @Nullable
    public String getBaseUrl(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getBaseUrl();
            }
            case DEFAULT: 
            case NULL: {
                if (this._baseUrlField != null) {
                    return this._baseUrlField;
                }
                Object __rawValue = this._map.get("baseUrl");
                this._baseUrlField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._baseUrlField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getBaseUrl() {
        if (this._baseUrlField != null) {
            return this._baseUrlField;
        }
        Object __rawValue = this._map.get("baseUrl");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("baseUrl");
        }
        this._baseUrlField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._baseUrlField;
    }

    public SsoSettings setBaseUrl(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setBaseUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field baseUrl of com.linkedin.settings.global.SsoSettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "baseUrl", value);
                this._baseUrlField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeBaseUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "baseUrl", value);
                this._baseUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "baseUrl", value);
                this._baseUrlField = value;
            }
        }
        return this;
    }

    public SsoSettings setBaseUrl(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field baseUrl of com.linkedin.settings.global.SsoSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "baseUrl", value);
        this._baseUrlField = value;
        return this;
    }

    public boolean hasOidcSettings() {
        if (this._oidcSettingsField != null) {
            return true;
        }
        return this._map.containsKey("oidcSettings");
    }

    public void removeOidcSettings() {
        this._map.remove("oidcSettings");
    }

    @Nullable
    public OidcSettings getOidcSettings(GetMode mode) {
        return this.getOidcSettings();
    }

    @Nullable
    public OidcSettings getOidcSettings() {
        if (this._oidcSettingsField != null) {
            return this._oidcSettingsField;
        }
        Object __rawValue = this._map.get("oidcSettings");
        this._oidcSettingsField = __rawValue == null ? null : new OidcSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._oidcSettingsField;
    }

    public SsoSettings setOidcSettings(@Nullable OidcSettings value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOidcSettings(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOidcSettings();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "oidcSettings", value.data());
                this._oidcSettingsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "oidcSettings", value.data());
                this._oidcSettingsField = value;
            }
        }
        return this;
    }

    public SsoSettings setOidcSettings(@Nonnull OidcSettings value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field oidcSettings of com.linkedin.settings.global.SsoSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "oidcSettings", value.data());
        this._oidcSettingsField = value;
        return this;
    }

    @Override
    public SsoSettings clone() throws CloneNotSupportedException {
        SsoSettings __clone = (SsoSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SsoSettings copy() throws CloneNotSupportedException {
        SsoSettings __copy = (SsoSettings)super.copy();
        __copy._baseUrlField = null;
        __copy._oidcSettingsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SsoSettings __objectRef;

        private ChangeListener(SsoSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "baseUrl": {
                    this.__objectRef._baseUrlField = null;
                    break;
                }
                case "oidcSettings": {
                    this.__objectRef._oidcSettingsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec baseUrl() {
            return new PathSpec(this.getPathComponents(), "baseUrl");
        }

        public OidcSettings.Fields oidcSettings() {
            return new OidcSettings.Fields(this.getPathComponents(), "oidcSettings");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private OidcSettings.ProjectionMask _oidcSettingsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withBaseUrl() {
            this.getDataMap().put("baseUrl", 1);
            return this;
        }

        public ProjectionMask withOidcSettings(Function<OidcSettings.ProjectionMask, OidcSettings.ProjectionMask> nestedMask) {
            this._oidcSettingsMask = nestedMask.apply(this._oidcSettingsMask == null ? OidcSettings.createMask() : this._oidcSettingsMask);
            this.getDataMap().put("oidcSettings", this._oidcSettingsMask.getDataMap());
            return this;
        }

        public ProjectionMask withOidcSettings() {
            this._oidcSettingsMask = null;
            this.getDataMap().put("oidcSettings", 1);
            return this;
        }
    }
}

