/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.settings.global;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.settings.global.OAuthProviderArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OAuthSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.settings.global/**Trust oauth providers to use for authentication.*/record OAuthSettings{/**Trusted OAuth Providers*/providers:array[/**An OAuth Provider. This provides information required to validate inbound\nrequests with OAuth 2.0 bearer tokens.*/record OAuthProvider{/**Whether this OAuth provider is enabled.*/enabled:boolean/**The name of this OAuth provider. This is used for display purposes only.*/name:string/**The URI of the JSON Web Key Set (JWKS) endpoint for this OAuth provider.*/jwksUri:optional string/**The expected issuer (iss) claim in the JWTs issued by this OAuth provider.*/issuer:string/**The expected audience (aud) claim in the JWTs issued by this OAuth provider.*/audience:string/**The JWT signing algorithm required for this provider.\nPrevents algorithm confusion attacks. Common values: RS256, RS384, RS512, PS256, ES256*/algorithm:string=\"RS256\"/**The JWT claim to use as the user identifier for this provider.\nDifferent providers use different claims (sub, email, preferred_username, etc.)*/userIdClaim:string=\"sub\"}]}", SchemaFormatType.PDL);
    private OAuthProviderArray _providersField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Providers = SCHEMA.getField("providers");

    public OAuthSettings() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public OAuthSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasProviders() {
        if (this._providersField != null) {
            return true;
        }
        return this._map.containsKey("providers");
    }

    public void removeProviders() {
        this._map.remove("providers");
    }

    @Nullable
    public OAuthProviderArray getProviders(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getProviders();
            }
            case DEFAULT: 
            case NULL: {
                if (this._providersField != null) {
                    return this._providersField;
                }
                Object __rawValue = this._map.get("providers");
                this._providersField = __rawValue == null ? null : new OAuthProviderArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._providersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public OAuthProviderArray getProviders() {
        if (this._providersField != null) {
            return this._providersField;
        }
        Object __rawValue = this._map.get("providers");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("providers");
        }
        this._providersField = __rawValue == null ? null : new OAuthProviderArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._providersField;
    }

    public OAuthSettings setProviders(@Nullable OAuthProviderArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setProviders(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field providers of com.linkedin.settings.global.OAuthSettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "providers", value.data());
                this._providersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeProviders();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "providers", value.data());
                this._providersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "providers", value.data());
                this._providersField = value;
            }
        }
        return this;
    }

    public OAuthSettings setProviders(@Nonnull OAuthProviderArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field providers of com.linkedin.settings.global.OAuthSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "providers", value.data());
        this._providersField = value;
        return this;
    }

    @Override
    public OAuthSettings clone() throws CloneNotSupportedException {
        OAuthSettings __clone = (OAuthSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public OAuthSettings copy() throws CloneNotSupportedException {
        OAuthSettings __copy = (OAuthSettings)super.copy();
        __copy._providersField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final OAuthSettings __objectRef;

        private ChangeListener(OAuthSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "providers": {
                    this.__objectRef._providersField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public OAuthProviderArray.Fields providers() {
            return new OAuthProviderArray.Fields(this.getPathComponents(), "providers");
        }

        public PathSpec providers(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "providers");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private OAuthProviderArray.ProjectionMask _providersMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withProviders(Function<OAuthProviderArray.ProjectionMask, OAuthProviderArray.ProjectionMask> nestedMask) {
            this._providersMask = nestedMask.apply(this._providersMask == null ? OAuthProviderArray.createMask() : this._providersMask);
            this.getDataMap().put("providers", this._providersMask.getDataMap());
            return this;
        }

        public ProjectionMask withProviders() {
            this._providersMask = null;
            this.getDataMap().put("providers", 1);
            return this;
        }

        public ProjectionMask withProviders(Function<OAuthProviderArray.ProjectionMask, OAuthProviderArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._providersMask = nestedMask.apply(this._providersMask == null ? OAuthProviderArray.createMask() : this._providersMask);
            this.getDataMap().put("providers", this._providersMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("providers").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("providers").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withProviders(Integer start, Integer count) {
            this._providersMask = null;
            this.getDataMap().put("providers", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("providers").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("providers").put("$count", count);
            }
            return this;
        }
    }
}

